<?php
namespace AegisShield;

defined( 'ABSPATH' ) || exit;

/**
 * Simple PSR-4-like autoloader for AegisShield classes.
 *
 * Phase 3: This loader supports sub-namespaces mapping directly to /includes/{subdir}/
 * (e.g., AegisShield\Intelligence\AS_Intelligence_Engine => /includes/intelligence/class-as-intelligence-engine.php).
 */
class AS_Autoloader {

    /**
     * Base namespace.
     *
     * @var string
     */
    protected static $base_namespace = 'AegisShield\\';

    /**
     * Initialize the autoloader.
     */
    public static function init() {
        spl_autoload_register( array( __CLASS__, 'autoload' ) );
    }

    /**
     * Autoload callback.
     *
     * @param string $class Class name.
     */
    public static function autoload( $class ) {
        if ( strpos( $class, self::$base_namespace ) !== 0 ) {
            return;
        }

        // Remove base namespace prefix.
        $relative = substr( $class, strlen( self::$base_namespace ) );

        // Break into namespace parts.
        $parts      = explode( '\\', $relative );
        $class_name = array_pop( $parts );
        $sub_path   = '';

        if ( ! empty( $parts ) ) {
            // Map sub-namespaces directly to subdirectories, lowercase.
            // Underscores are preserved so Admin_Pages => admin_pages.
            $sub_path = strtolower( implode( DIRECTORY_SEPARATOR, $parts ) ) . DIRECTORY_SEPARATOR;
        }

        // Convert class name to our file naming convention.
        $file_name = 'class-' . strtolower( str_replace( '_', '-', $class_name ) ) . '.php';

        $base_dir = trailingslashit( AEGISSHIELD_PLUGIN_DIR ) . 'includes/';
        $file     = $base_dir . $sub_path . $file_name;

        if ( file_exists( $file ) ) {
            require $file;
        }
    }
}