<?php
namespace AegisShield;

defined( 'ABSPATH' ) || exit;

/**
 * Cron management for AegisShield.
 */
class AS_Cron {

    const HOURLY_HOOK = 'aegisshield_hourly_maintenance';

    /**
     * Register cron schedules and hooks.
     */
    public function init() {
        add_action( 'init', array( $this, 'schedule_events' ) );
        add_action( self::HOURLY_HOOK, array( $this, 'run_hourly' ) );
    }

    /**
     * Schedule events if not already scheduled.
     */
    public function schedule_events() {
        if ( ! wp_next_scheduled( self::HOURLY_HOOK ) ) {
            wp_schedule_event( time() + 300, 'hourly', self::HOURLY_HOOK );
        }
    }

    /**
     * Clear scheduled events.
     */
    public function clear_events() {
        $timestamp = wp_next_scheduled( self::HOURLY_HOOK );
        if ( $timestamp ) {
            wp_unschedule_event( $timestamp, self::HOURLY_HOOK );
        }
    }

    /**
     * Hourly maintenance task.
     */
    public function run_hourly() {
        $plugin   = AS_Plugin::instance();
        $settings = $plugin->get_settings();
        $logger   = $plugin->get_logger();

        $retention_days = absint( $settings->get( 'activity_log', 'retention_days', 30 ) );
        if ( $retention_days > 0 ) {
            $logger->prune( $retention_days );
        }

        /**
         * Allow modules (e.g., file integrity) to hook into hourly maintenance.
         */
        do_action( 'aegisshield_hourly_maintenance' );
    }
}