<?php
namespace AegisShield;

defined( 'ABSPATH' ) || exit;

/**
 * Settings handler for AegisShield.
 */
class AS_Settings {

    protected $option_name = 'aegisshield_settings';
    protected $settings    = array();

    public function __construct() {
        $this->settings = get_option( $this->option_name, array() );
        if ( ! is_array( $this->settings ) ) {
            $this->settings = array();
        }
    }

    public function get( $section, $key, $default = null ) {
        if ( isset( $this->settings[ $section ] ) && isset( $this->settings[ $section ][ $key ] ) ) {
            return $this->settings[ $section ][ $key ];
        }
        return $default;
    }

    public function set( $section, $key, $value ) {
        if ( ! isset( $this->settings[ $section ] ) || ! is_array( $this->settings[ $section ] ) ) {
            $this->settings[ $section ] = array();
        }
        $this->settings[ $section ][ $key ] = $value;
    }

    public function save() {
        update_option( $this->option_name, $this->settings );
    }

    public function all() {
        return $this->settings;
    }
}