<?php
namespace AegisShield\Helpers;

defined( 'ABSPATH' ) || exit;

class AS_MFA_Test_Form {

    public static function init() {
        add_shortcode( 'aegis_mfa_test_form', array( __CLASS__, 'render_form' ) );
    }

    public static function render_form() {

        // PREP: generate TOTP provisioning URI for this test
        $user_label  = 'TestUser';
        $issuer      = get_bloginfo( 'name' );
        $secret      = 'TESTSECRET123456'; // replace with real TOTP generator later
        $uri         = "otpauth://totp/{$issuer}:{$user_label}?secret={$secret}&issuer={$issuer}&period=30&digits=6";

        // QR TEST (local)
        $qr = '';
        if ( class_exists( '\AegisShield\Utils\AS_QR' ) ) {
            try {
                $qr = \AegisShield\Utils\AS_QR::svg_base64( $uri );
            } catch (\Throwable $e) {
                $qr = '';
            }
        }

        ob_start();
        ?>
        <div class="as-mfa-test-form">
            <form method="post" action="">
                <h3 style="margin-bottom:15px;">Login + MFA Test</h3>

                <!-- USERNAME -->
                <div class="field">
                    <label>Username</label>
                    <input type="text" name="username" autocomplete="username" />
                </div>

                <!-- PASSWORD -->
                <div class="field">
                    <label>Password</label>
                    <input type="password" name="password" autocomplete="current-password" />
                </div>

                <!-- MFA SELECTOR -->
                <div class="field">
                    <label style="font-weight:bold; margin-bottom:8px; display:block;">Choose MFA Method</label>

                    <label class="mfa-option">
                        <input type="radio" name="mfa_method" value="totp" />
                        Authenticator App (QR)
                    </label>

                    <?php if ( ! empty( $qr ) ) : ?>
                        <div class="qr-wrapper">
                            <img src="<?php echo esc_attr( $qr ); ?>" alt="TOTP QR Code" />
                        </div>
                    <?php else : ?>
                        <p style="color:#aa0000; font-size:12px;">QR generator returned empty output.</p>
                    <?php endif; ?>

                    <label class="mfa-option">
                        <input type="radio" name="mfa_method" value="email" />
                        Email OTP
                    </label>

                    <label class="mfa-option">
                        <input type="radio" name="mfa_method" value="backup" />
                        Backup Code (future)
                    </label>
                </div>

                <button type="submit" class="as-btn">Login Test</button>
            </form>
        </div>

        <style>
            .as-mfa-test-form {
                width: 100%;
                background: transparent;
                border: 1px solid #ccc;
                padding: 20px;
                border-radius: 10px;
                box-sizing: border-box;
            }

            .as-mfa-test-form .field {
                margin-bottom: 15px;
                width: 100%;
            }

            .as-mfa-test-form label {
                font-size: 14px;
                display: block;
                margin-bottom: 4px;
            }

            .as-mfa-test-form input[type="text"],
            .as-mfa-test-form input[type="password"] {
                width: 100%;
                padding: 10px;
                border: 1px solid #bfbfbf;
                border-radius: 6px;
                background: transparent;
                color: inherit;
            }

            .as-mfa-test-form .mfa-option {
                display: block;
                margin-bottom: 8px;
                font-size: 14px;
            }

            .as-mfa-test-form .qr-wrapper {
                margin: 10px 0 15px;
                text-align: center;
            }
            .as-mfa-test-form .qr-wrapper img {
                width: 200px;
                height: 200px;
                border: 1px solid #ccc;
                background: #fff;
                padding: 5px;
                border-radius: 8px;
            }

            .as-mfa-test-form .as-btn {
                width: 100%;
                padding: 12px;
                background: #222;
                color: #fff;
                border: none;
                border-radius: 6px;
                cursor: pointer;
                font-size: 16px;
            }
        </style>

        <?php
        return ob_get_clean();
    }
}
