<?php
namespace AegisShield\Modules\Malware;

defined( 'ABSPATH' ) || exit;

/**
 * Malware incremental scan helper.
 *
 * Phase 1: provides incremental target list for quick scans.
 */
class AS_Malware_Incremental {

    /**
     * Get list of relative paths that should be scanned in an incremental (quick) malware scan.
     *
     * Uses the File Monitor table to return only files marked as new or modified,
     * capped to a safe maximum per run to protect shared hosting environments.
     *
     * @return array List of relative file paths from ABSPATH.
     */
    public static function get_incremental_targets() {
        global $wpdb;

        if ( ! isset( $wpdb ) ) {
            return array();
        }

        $table = $wpdb->prefix . 'aegisshield_file_monitor';
        if ( empty( $table ) ) {
            return array();
        }

        // Cap per-run files to keep quick scans lightweight.
        $limit = 300;

        $rows = $wpdb->get_results(
            $wpdb->prepare(
                "SELECT file_path FROM {$table} WHERE status IN ('new','modified') ORDER BY mtime DESC LIMIT %d",
                $limit
            ),
            ARRAY_A
        );

        if ( empty( $rows ) || ! is_array( $rows ) ) {
            return array();
        }

        $paths = array();

        foreach ( $rows as $row ) {
            if ( empty( $row['file_path'] ) ) {
                continue;
            }

            $rel_path = ltrim( (string) $row['file_path'], "/\\" );
            if ( '' === $rel_path ) {
                continue;
            }

            $paths[] = $rel_path;
        }

        return $paths;
    }
}
