<?php
namespace AegisShield\Modules\Malware;

defined( 'ABSPATH' ) || exit;

/**
 * Malware scheduler helper.
 *
 * v2.6.0-pre: provides structure only. Scheduling logic will be wired in a later Phase 1 build.
 */
class AS_Malware_Scheduler {

    /**
     * Holds the singleton instance.
     *
     * @var AS_Malware_Scheduler|null
     */
    protected static $instance = null;

    /**
     * Get instance.
     *
     * @return AS_Malware_Scheduler
     */
    public static function instance() {
        if ( null === self::$instance ) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * Initialize hooks for scheduled malware scans.
     *
     * Note: intentionally empty in v2.6.0-pre. Real logic will be added later.
     *
     * @return void
     */
    public function init() {
        // Future implementation: hook into aegisshield_hourly_maintenance to run scheduled scans.
    }
}
