<?php
namespace AegisLink\Admin;

use AegisLink\Utils\License;

if (!defined('ABSPATH')) { exit; }

class Admin_Menu {

    private $license;

    public function __construct(License $license) {
        $this->license = $license;
        add_action('admin_menu', array($this, 'register_menu'));
        add_action('admin_enqueue_scripts', array($this, 'enqueue_assets'));

    }

    public function register_menu() : void {
        $cap = 'manage_options';

        add_menu_page(
            __('AegisLink', 'aegislink'),
            __('AegisLink', 'aegislink'),
            $cap,
            'aegislink',
            array($this, 'render_links_page'),
            'dashicons-admin-links',
            56
        );

        add_submenu_page(
            'aegislink',
            __('Linking Assistant', 'aegislink'),
            __('Linking Assistant', 'aegislink'),
            $cap,
            'aegislink',
            array($this, 'render_links_page')
        );

        add_submenu_page(
            'aegislink',
            __('Aegisify Plugins', 'aegislink'),
            __('Aegisify Plugins', 'aegislink'),
            $cap,
            'aegislink-aegisify-plugins',
            array($this, 'render_aegisify_plugins_page')
        );

        add_submenu_page(
            'aegislink',
            __('Tools & License', 'aegislink'),
            __('Tools & License', 'aegislink'),
            $cap,
            'aegislink-license',
            array($this, 'render_license_page')
        );
    }


    public function enqueue_assets(string $hook) : void {

        if (strpos($hook, 'aegislink') === false) { return; }

        wp_enqueue_style('aegislink-admin', AEGISLINK_URL . 'assets/css/admin.css', array(), AEGISLINK_VERSION);

        wp_enqueue_script('aegislink-qrcodegen', AEGISLINK_URL . 'assets/js/qrcodegen.js', array(), AEGISLINK_VERSION, true);
        wp_enqueue_script('aegislink-admin', AEGISLINK_URL . 'assets/js/admin.js', array('jquery','aegislink-qrcodegen'), AEGISLINK_VERSION, true);
    }

    public function render_links_page() : void {
        require AEGISLINK_DIR . 'includes/admin/pages/links-page.php';
    }

    public function render_license_page() : void {
        require AEGISLINK_DIR . 'includes/admin/pages/license-page.php';
    }

    public function render_aegisify_plugins_page() : void {
        if (class_exists('Aegisify_Bundled_Plugins_Page') && method_exists('Aegisify_Bundled_Plugins_Page', 'render_page')) {
			if (method_exists('Aegisify_Bundled_Plugins_Page', 'init')) {
            \Aegisify_Bundled_Plugins_Page::init();
        }
            \Aegisify_Bundled_Plugins_Page::render_page();
            return;
        }

        $path = AEGISLINK_DIR . 'includes/class-aegisify-bundled-plugins-page.php';
        if (file_exists($path)) {
            require_once $path;
        }
        if (class_exists('Aegisify_Bundled_Plugins_Page') && method_exists('Aegisify_Bundled_Plugins_Page', 'render_page')) {
            \Aegisify_Bundled_Plugins_Page::render_page();
            return;
        }

        echo '<div class="wrap"><h1>' . esc_html__('Aegisify Plugins', 'aegislink') . '</h1><p>' . esc_html__('Bundled plugins page is unavailable (class not loaded).', 'aegislink') . '</p></div>';
    }
}
