<?php
if (!defined('ABSPATH')) { exit; }

$license = aegislink()->license;
$free_optin  = (int) get_option(\AegisLink\Utils\License::OPTION_FREE_OPTIN, 0);
$free_status = (string) get_option(\AegisLink\Utils\License::OPTION_FREE_STATUS, 'unregistered');

if (!current_user_can('read')) {
    echo '<p>' . esc_html__('Forbidden', 'aegislink') . '</p>';
    return;
}

$is_embedded = (isset($_GET['page']) && sanitize_key((string) $_GET['page']) === 'aegislink' && isset($_GET['tab']) && sanitize_key((string) $_GET['tab']) === 'tools');
$tab_key = $is_embedded ? 'tools_tab' : 'tab';
$tab = isset($_GET[$tab_key]) ? sanitize_key((string) $_GET[$tab_key]) : 'license';
if (!in_array($tab, array('license','health'), true)) { $tab = 'license'; }

if ($tab === 'license') {
    $base_url = $is_embedded ? admin_url('admin.php?page=aegislink&tab=tools') : admin_url('admin.php?page=aegislink-license');
    $base_url = add_query_arg(array($tab_key => 'license'), $base_url);

    if (!empty($_POST['aegislink_license_action'])) {
        check_admin_referer('aegislink_license_action');

        $key = isset($_POST['license_key']) ? sanitize_text_field((string) $_POST['license_key']) : '';
        $email = isset($_POST['license_email']) ? sanitize_email((string) $_POST['license_email']) : '';

        $license->set_key($key);
        update_option('aegislink_license_email', $email, false);

        $msg = 'saved';

        if (isset($_POST['aegislink_activate_license'])) {
            $resp = $license->activate_now(AEGISLINK_VERSION);
            $msg = !empty($resp['success']) ? 'activated' : 'activate_failed';
        } elseif (isset($_POST['aegislink_deactivate_license'])) {
            $resp = $license->deactivate_now(AEGISLINK_VERSION);
            $msg = !empty($resp['success']) ? 'deactivated' : 'deactivate_failed';
        } elseif (isset($_POST['aegislink_check_license'])) {
            $license->check_now(AEGISLINK_VERSION);
            $msg = 'checked';
        } elseif (isset($_POST['aegislink_register_free_install'])) {

            $consent = isset($_POST['aegislink_free_reg_consent']) && (string) $_POST['aegislink_free_reg_consent'] === '1';

            if (!$consent) {
                $msg = 'consent_required';
            } else {
                update_option(\AegisLink\Utils\License::OPTION_FREE_OPTIN, 1, false);
                update_option(\AegisLink\Utils\License::OPTION_FREE_STATUS, 'unregistered', false);
				delete_transient('aegislink_clm_free_reg_sent'); 
                $license->maybe_send_free_register(AEGISLINK_VERSION);

                $free_status = (string) get_option(\AegisLink\Utils\License::OPTION_FREE_STATUS, 'unregistered');
                $msg = ($free_status === 'registered') ? 'free_registered' : 'free_register_failed';
            }

        } elseif (isset($_POST['aegislink_unregister_free_install'])) {

            update_option(\AegisLink\Utils\License::OPTION_FREE_OPTIN, 0, false);
            update_option(\AegisLink\Utils\License::OPTION_FREE_STATUS, 'unregistered', false);
            $msg = 'free_unregistered';
        }

		// Do NOT redirect/exit after POST (prevents blank screen). Just show message and continue rendering.
		$_GET['aegislink_msg'] = $msg;

		// Refresh these so the UI updates immediately after submit.
		$free_optin  = (int) get_option(\AegisLink\Utils\License::OPTION_FREE_OPTIN, 0);
		$free_status = (string) get_option(\AegisLink\Utils\License::OPTION_FREE_STATUS, 'unregistered');

    }

    if (!empty($_POST['aegislink_license_save'])) {
        check_admin_referer('aegislink_license_save');

        $key = isset($_POST['license_key']) ? sanitize_text_field($_POST['license_key']) : '';
        $email = isset($_POST['license_email']) ? sanitize_email($_POST['license_email']) : '';

        $license->set_key($key);
        update_option('aegislink_license_email', $email, false);

        $license->check_now(AEGISLINK_VERSION);

        echo '<div class="notice notice-success"><p>' . esc_html__('License saved.', 'aegislink') . '</p></div>';
    }

    if (!empty($_POST['aegislink_license_refresh'])) {
        check_admin_referer('aegislink_license_refresh');
        $license->check_now(AEGISLINK_VERSION);
        echo '<div class="notice notice-success"><p>' . esc_html__('License status refreshed.', 'aegislink') . '</p></div>';
    }
}

$status = method_exists($license, 'get_status') ? $license->get_status() : (method_exists($license, 'get_cached_status') ? $license->get_cached_status() : array());

echo '<div class="wrap">';
echo '<h1>' . esc_html__('AegisLink', 'aegislink') . '</h1>';

$base_url = $is_embedded ? admin_url('admin.php?page=aegislink&tab=tools') : admin_url('admin.php?page=aegislink-license');
echo '<h2 class="nav-tab-wrapper">';
echo '<a href="' . esc_url(add_query_arg(array($tab_key=>'license'), $base_url)) . '" class="nav-tab ' . ($tab==='license' ? 'nav-tab-active' : '') . '">' . esc_html__('License', 'aegislink') . '</a>';echo '<a href="' . esc_url(add_query_arg(array($tab_key=>'health'), $base_url)) . '" class="nav-tab ' . ($tab === 'health' ? 'nav-tab-active' : '') . '">' . esc_html__('Health Checks', 'aegislink') . '</a>';
echo '</h2>';
$is_pro    = !empty($status['is_pro']);
$plan      = isset($status['plan']) ? (string) $status['plan'] : '';
$expires   = isset($status['expires']) ? (string) $status['expires'] : '';
$lic_state = isset($status['status']) ? (string) $status['status'] : '';
$is_active = $is_pro || ($lic_state === 'active');

echo '<h2 style="margin-top:18px;">' . esc_html__('License Status', 'aegislink') . '</h2>';

echo '<table class="widefat striped" style="max-width:600px;margin-bottom:20px;">';
echo '<tbody>';

echo '<tr><th scope="row">' . esc_html__('Status', 'aegislink') . '</th><td>';
if ($is_active) {
    echo '<span style="color:#46b450;font-weight:600;">' . esc_html__($is_pro ? 'Active (Pro enabled)' : 'Active', 'aegislink') . '</span>';
} else {
    echo '<span style="color:#dc3232;font-weight:600;">' . esc_html__('Inactive', 'aegislink') . '</span>';
}
echo '</td></tr>';

echo '<tr><th scope="row">' . esc_html__('Plan', 'aegislink') . '</th><td>' . esc_html($plan !== '' ? $plan : '-') . '</td></tr>';
echo '<tr><th scope="row">' . esc_html__('Expires At', 'aegislink') . '</th><td>' . esc_html($expires !== '' ? $expires : '-') . '</td></tr>';

echo '</tbody></table>';

if ($tab === 'health') {

    // Actions
    if (!empty($_POST['aegislink_health_run'])) {
        check_admin_referer('aegislink_health_run');
        if (isset(aegislink()->shortlinks) && is_object(aegislink()->shortlinks) && method_exists(aegislink()->shortlinks, 'run_health_check')) {
            aegislink()->shortlinks->run_health_check();
            echo '<div class="notice notice-success"><p>' . esc_html__('Health check executed.', 'aegislink') . '</p></div>';
        }
    }

    if (!empty($_POST['aegislink_health_reschedule'])) {
        check_admin_referer('aegislink_health_reschedule');
        if (class_exists('AegisLink\\Shortlinks\\Shortlinks')) {
            \AegisLink\Shortlinks\Shortlinks::unschedule_health_check();
            \AegisLink\Shortlinks\Shortlinks::maybe_schedule_health_check();
            echo '<div class="notice notice-success"><p>' . esc_html__('Daily schedule refreshed.', 'aegislink') . '</p></div>';
        }
    }

    if (!empty($_POST['aegislink_health_disable'])) {
        check_admin_referer('aegislink_health_disable');
        if (class_exists('AegisLink\\Shortlinks\\Shortlinks')) {
            \AegisLink\Shortlinks\Shortlinks::unschedule_health_check();
            echo '<div class="notice notice-warning"><p>' . esc_html__('Daily schedule disabled.', 'aegislink') . '</p></div>';
        }
    }

    $hook = 'aegislink_shortlinks_health_check';
    $next = function_exists('wp_next_scheduled') ? wp_next_scheduled($hook) : 0;

    $last_run_gmt = (string) get_option('aegislink_health_last_run_gmt', '');
    $last_checked = (int) get_option('aegislink_health_last_run_checked', 0);
    $last_ok = (int) get_option('aegislink_health_last_run_ok', 0);
    $last_broken = (int) get_option('aegislink_health_last_run_broken', 0);

    $batch = (int) apply_filters('aegislink_shortlinks_health_batch', 25);
    if ($batch < 1) { $batch = 25; }

    echo '<div class="postbox" style="max-width:1100px; padding:14px; margin-top:14px;">';
    echo '<h2 style="margin:0 0 10px 0;">' . esc_html__('Health Checks (Short Links)', 'aegislink') . '</h2>';

    echo '<p class="description" style="margin:0 0 10px 0;">' . esc_html__('Health checks run daily and scan a small batch each run to keep shared hosting safe.', 'aegislink') . '</p>';

    echo '<table class="widefat striped" style="max-width:900px;">';
    echo '<tbody>';
    echo '<tr><td style="width:220px;"><strong>' . esc_html__('Batch size per run', 'aegislink') . '</strong></td><td>' . esc_html($batch) . '</td></tr>';
    echo '<tr><td><strong>' . esc_html__('Schedule', 'aegislink') . '</strong></td><td>' . ($next ? esc_html(sprintf(__('Next run: %s', 'aegislink'), wp_date('Y-m-d H:i:s', $next))) : esc_html__('Disabled', 'aegislink')) . '</td></tr>';
    echo '<tr><td><strong>' . esc_html__('Last run (GMT)', 'aegislink') . '</strong></td><td>' . ($last_run_gmt !== '' ? esc_html($last_run_gmt) : esc_html__('—', 'aegislink')) . '</td></tr>';
    echo '<tr><td><strong>' . esc_html__('Last run summary', 'aegislink') . '</strong></td><td>' . esc_html(sprintf(__('Checked: %d | Healthy: %d | Broken: %d', 'aegislink'), $last_checked, $last_ok, $last_broken)) . '</td></tr>';
    echo '</tbody>';
    echo '</table>';

    echo '<div style="margin-top:12px; display:flex; gap:10px; align-items:center; flex-wrap:wrap;">';

    echo '<form method="post" style="margin:0;">';
    wp_nonce_field('aegislink_health_run');
    echo '<input type="hidden" name="aegislink_health_run" value="1" />';
    echo '<button type="submit" class="button button-primary">' . esc_html__('Run Now', 'aegislink') . '</button>';
    echo '</form>';

    echo '<form method="post" style="margin:0;">';
    wp_nonce_field('aegislink_health_reschedule');
    echo '<input type="hidden" name="aegislink_health_reschedule" value="1" />';
    echo '<button type="submit" class="button">' . esc_html__('Reschedule Daily', 'aegislink') . '</button>';
    echo '</form>';

    echo '<form method="post" style="margin:0;">';
    wp_nonce_field('aegislink_health_disable');
    echo '<input type="hidden" name="aegislink_health_disable" value="1" />';
    echo '<button type="submit" class="button">' . esc_html__('Disable Schedule', 'aegislink') . '</button>';
    echo '</form>';

    echo '</div>';

    echo '<hr style="margin:14px 0;" />';
    echo '<p class="description" style="margin:0;">' . esc_html__('Tip: Broken links are marked in External Linking → Manage. You can edit targets, delete dead links, or re-run checks after updates.', 'aegislink') . '</p>';

    echo '</div>';

} else {

if (isset($_GET['aegislink_msg'])) {
    $m = sanitize_key((string) $_GET['aegislink_msg']);
    $map = array(
        'saved' => array('success', __('License saved.', 'aegislink')),
        'activated' => array('success', __('License activated.', 'aegislink')),
        'activate_failed' => array('error', __('Activation failed. Check /includes/log/aegislink.log', 'aegislink')),
        'deactivated' => array('success', __('License deactivated.', 'aegislink')),
        'deactivate_failed' => array('error', __('Deactivation failed. Check /includes/log/aegislink.log', 'aegislink')),
        'checked' => array('success', __('License status refreshed.', 'aegislink')),
        'consent_required' => array('error', __('Please confirm consent before registering this installation.', 'aegislink')),
        'free_registered' => array('success', __('Registered successfully with Aegisify.', 'aegislink')),
        'free_register_failed' => array('error', __('Registration failed. Check /includes/log/aegislink.log', 'aegislink')),
        'free_unregistered' => array('success', __('Free-install registration set to Unregistered.', 'aegislink')),
    );

    if (isset($map[$m])) {
        echo '<div class="notice notice-' . esc_attr($map[$m][0]) . '"><p>' . esc_html($map[$m][1]) . '</p></div>';
    }
}

echo '<div style="margin:10px 0 14px;color:#50575e;font-size:13px;">'
    . esc_html__('Enter your license key and the email used at checkout. Activate to unlock PRO features and updates.', 'aegislink')
    . '</div>';

$free_optin  = (int) get_option(\AegisLink\Utils\License::OPTION_FREE_OPTIN, 0);
$free_status = (string) get_option(\AegisLink\Utils\License::OPTION_FREE_STATUS, 'unregistered');

echo '<form method="post">';
wp_nonce_field('aegislink_license_action');
echo '<input type="hidden" name="aegislink_license_action" value="1" />';

echo '<table class="form-table" role="presentation"><tbody>';

echo '<tr><th scope="row"><label for="license_key">' . esc_html__('License Key', 'aegislink') . '</label></th>';
echo '<td><input type="text" id="license_key" name="license_key" class="regular-text" style="width:420px;" value="' . esc_attr($license->get_key()) . '" autocomplete="off" /></td></tr>';

echo '<tr><th scope="row"><label for="license_email">' . esc_html__('License Email', 'aegislink') . '</label></th>';
echo '<td><input type="email" id="license_email" name="license_email" class="regular-text" style="width:420px;" value="' . esc_attr(get_option('aegislink_license_email', '')) . '" autocomplete="email" /></td></tr>';

echo '</tbody></table>';

$confirm = esc_js(__('Deactivate this license on this site?', 'aegislink'));

echo '<p>';
echo '<button type="submit" class="button button-primary" name="aegislink_activate_license" value="1">' . esc_html__('Activate License', 'aegislink') . '</button> ';
echo '<button type="submit" class="button" name="aegislink_deactivate_license" value="1" onclick="return confirm(\'' . $confirm . '\');">' . esc_html__('Deactivate', 'aegislink') . '</button> ';
echo '<button type="submit" class="button button-secondary" name="aegislink_check_license" value="1">' . esc_html__('Check Status', 'aegislink') . '</button>';
echo '</p>';

echo '<hr style="margin:18px 0;" />';

if ($is_active) {
    echo '<h3 style="margin:0 0 6px 0;">' . esc_html__('Free install registration', 'aegislink') . '</h3>';
    echo '<p class="description" style="margin:0 0 10px 0;">' . esc_html__('You already have an active license. Free-install registration is not required.', 'aegislink') . '</p>';
} else {
echo '<h3 style="margin:0 0 6px 0;">' . esc_html__('Optional: Register this free installation', 'aegislink') . '</h3>';

echo '<p class="description" style="margin:0 0 10px 0;">'
    . esc_html__('This is optional and if you want update checks and license-related features through Aegisify, you can register this free installation. This will send your site domain, site URL, and the WordPress admin email to Aegisify. Your information will never leave our database nor be sold to any 3rd party.', 'aegislink')
    . '</p>';

echo '<label style="display:block; margin:0 0 10px 0;">'
    . '<input type="checkbox" name="aegislink_free_reg_consent" value="1" ' . (($free_optin === 1) ? 'checked="checked"' : '') . ' /> '
    . esc_html__('I consent to send the data described above to Aegisify.', 'aegislink')
    . '</label>';

echo '<p style="margin:0 0 10px 0;"><strong>' . esc_html__('Registration Status:', 'aegislink') . '</strong> ';

if ($free_status === 'registered') {
    echo '<span style="color:#0a7b34; font-weight:600;">' . esc_html__('Registered', 'aegislink') . '</span>';
} elseif ($free_status === 'error') {
    echo '<span style="color:#b32d2e; font-weight:600;">' . esc_html__('Error', 'aegislink') . '</span>';
} else {
    echo '<span style="color:#555; font-weight:600;">' . esc_html__('Unregistered', 'aegislink') . '</span>';
}
echo '</p>';

echo '<p style="margin:0;">';
if ($free_status !== 'registered') {
    echo '<button type="submit" class="button" name="aegislink_register_free_install" value="1">' . esc_html__('Register Free Installation', 'aegislink') . '</button>';
} else {
    echo '<button type="submit" class="button" name="aegislink_unregister_free_install" value="1">' . esc_html__('Unregister Free Installation', 'aegislink') . '</button>';
}
echo '</p>';

}

echo '</form>';

echo '<hr />';
echo '<h4>'
    . esc_html__('Create an account on', 'aegislink') . ' '
    . '<a href="' . esc_url('https://aegisify.com/register/') . '" target="_blank" rel="noopener noreferrer">https://aegisify.com/register/</a> '
    . esc_html__('and help support Aegisify by buying a license today!', 'aegislink')
    . '</h4>';
echo '<hr />';

foreach ($fields as $k => $v) {
    echo '<tr><td><strong>' . esc_html($k) . '</strong></td><td>' . esc_html($v) . '</td></tr>';
}
echo '</tbody></table>';

echo '<hr style="margin:22px 0;" />';
echo '<h2>' . esc_html__('Need a license?', 'aegislink') . '</h2>';
echo '<p>' . wp_kses_post(sprintf(__('Create an account at %s and buy a license to unlock PRO features.', 'aegislink'),
    '<a href="https://aegisify.com/register/" target="_blank" rel="noopener noreferrer">https://aegisify.com/register/</a>'
)) . '</p>';
}
echo '</div>';
