<?php
if (!defined('ABSPATH')) { exit; }

if (!current_user_can('edit_posts')) {
    echo '<p>' . esc_html__('Forbidden', 'aegislink') . '</p>';
    return;
}


$active_tab = isset($_GET['tab']) ? sanitize_key((string) $_GET['tab']) : 'keyword';

if ($active_tab === 'internal') { $active_tab = 'keyword'; }
if ($active_tab === 'external') { $active_tab = 'shorturl'; }
if ($active_tab === 'shorturl') { $active_tab = 'shorturl'; }

if (!in_array($active_tab, array('wordcloud','keyword','shorturl','tools'), true)) { $active_tab = 'keyword'; }
$smart_opt_key = 'aegislink_smart_links';
$smart_opts = get_option($smart_opt_key, array('enabled' => 0, 'map' => array()));
if (!is_array($smart_opts)) { $smart_opts = array('enabled' => 0, 'map' => array()); }
if (!isset($smart_opts['enabled'])) { $smart_opts['enabled'] = 0; }
if (!isset($smart_opts['map']) || !is_array($smart_opts['map'])) { $smart_opts['map'] = array(); }

$max_rows = 100;

if (!empty($_POST['aegislink_smart_links_save'])) {
    check_admin_referer('aegislink_smart_links_save');

    $enabled = !empty($_POST['smart_links_enabled']) ? 1 : 0;

    $keywords = isset($_POST['smart_keyword']) && is_array($_POST['smart_keyword']) ? $_POST['smart_keyword'] : array();
    $urls     = isset($_POST['smart_url']) && is_array($_POST['smart_url']) ? $_POST['smart_url'] : array();

    $map = array();
    $count = min($max_rows, max(count($keywords), count($urls)));

    for ($i = 0; $i < $count; $i++) {
        $kw  = isset($keywords[$i]) ? sanitize_text_field($keywords[$i]) : '';
        $url = isset($urls[$i]) ? esc_url_raw(trim($urls[$i])) : '';

        $kw = trim($kw);

        if ($kw === '' || preg_match('/\s/', $kw)) { continue; }
        if ($url === '') { continue; }

        $map[strtolower($kw)] = array(
            'keyword' => $kw,
            'url'     => $url,
        );
    }

    $smart_opts = array(
        'enabled' => $enabled,
        'map'     => array_values($map),
    );

    update_option($smart_opt_key, $smart_opts, false);

    echo '<div class="notice notice-success"><p>' . esc_html__('Smart Links saved.', 'aegislink') . '</p></div>';
}

$post_id = isset($_GET['post_id']) ? (int) $_GET['post_id'] : 0;

echo '<div class="wrap">';
echo '<h1>' . esc_html__('Linking Assistant', 'aegislink') . '</h1>';
echo '<p class="description" style="max-width:1100px;">' . esc_html__('Generate internal link suggestions for a Page or Post and manage Smart Links (keyword → URL) that auto-link across your content.', 'aegislink') . '</p>';

$base_url = admin_url('admin.php?page=aegislink');
$tools_url = admin_url('admin.php?page=aegislink&tab=tools');

echo '<h2 class="nav-tab-wrapper" style="margin-top:14px;">';
echo '<a class="nav-tab ' . ($active_tab === 'wordcloud' ? 'nav-tab-active' : '') . '" href="' . esc_url(add_query_arg(array('tab'=>'wordcloud'), $base_url)) . '">' . esc_html__('Word Cloud', 'aegislink') . '</a>';
echo '<a class="nav-tab ' . ($active_tab === 'keyword' ? 'nav-tab-active' : '') . '" href="' . esc_url(add_query_arg(array('tab'=>'keyword'), $base_url)) . '">' . esc_html__('Keyword Links', 'aegislink') . '</a>';
echo '<a class="nav-tab ' . ($active_tab === 'shorturl' ? 'nav-tab-active' : '') . '" href="' . esc_url(add_query_arg(array('tab'=>'shorturl'), $base_url)) . '">' . esc_html__('ShortURL Links', 'aegislink') . '</a>';
echo '<a class="nav-tab ' . ($active_tab === 'tools' ? 'nav-tab-active' : '') . '" href="' . esc_url($tools_url) . '">' . esc_html__('Tools & Licensing', 'aegislink') . '</a>';
echo '</h2>';

if ($active_tab === 'wordcloud') {
    require_once AEGISLINK_DIR . 'includes/admin/pages/wordcloud-page.php';
    return;
}

if ($active_tab === 'tools') {
    require_once AEGISLINK_DIR . 'includes/admin/pages/license-page.php';
    return;
}

if ($active_tab === 'shorturl') {
    require_once AEGISLINK_DIR . 'includes/admin/pages/external-links-page.php';
    return;
}


echo '<hr style="margin:18px 0;" />';
echo '<h2 style="margin:0 0 10px 0;">' . esc_html__('Select a Page or Post', 'aegislink') . '</h2>';

$args = array(
    'post_type'      => array('post','page'),
    'post_status'    => array('publish','draft','private'),
    'posts_per_page' => 200,
    'orderby'        => 'type',
    'order'          => 'ASC',
);
$q = new WP_Query($args);

echo '<form method="get" action="" style="margin:0 0 10px 0;">';
echo '<input type="hidden" name="page" value="aegislink" />';
echo '<select name="post_id" style="min-width:420px; max-width:100%;">';
echo '<option value="0">' . esc_html__('— Select —', 'aegislink') . '</option>';
if ($q->have_posts()) {
    foreach ($q->posts as $p) {
        $label = sprintf('[%s] %s', strtoupper($p->post_type), $p->post_title ? $p->post_title : '(no title)');
        echo '<option value="' . (int) $p->ID . '" ' . selected($post_id, $p->ID, false) . '>' . esc_html($label) . '</option>';
    }
}
echo '</select> ';
submit_button(__('Load Suggestions', 'aegislink'), 'secondary', 'submit', false);
echo '</form>';

echo '<hr style="margin:18px 0;" />';
echo '<h2 style="margin:0 0 6px 0;">' . esc_html__('Smart Links (Keyword → URL)', 'aegislink') . '</h2>';
echo '<p class="description" style="margin:0 0 12px 0; max-width:1100px;">' . esc_html__('Create one-word keywords that automatically link across your entire site content. Example: AegisWAF → https://aegisify.com/aegiswaf/', 'aegislink') . '</p>';

echo '<form method="post" action="" id="aegislink-smartlinks-form">';
wp_nonce_field('aegislink_smart_links_save');
echo '<input type="hidden" name="aegislink_smart_links_save" value="1" />';

echo '<label style="display:inline-flex; align-items:center; gap:8px; margin: 0 0 10px 0;">';
echo '<input type="checkbox" name="smart_links_enabled" value="1" ' . checked(!empty($smart_opts['enabled']), true, false) . ' />';
echo '<strong>' . esc_html__('Enable Smart Links site-wide', 'aegislink') . '</strong>';
echo '</label>';

echo '<table class="widefat striped" style="max-width:1100px;" id="aegislink-smartlinks-table">';
echo '<thead><tr>';
echo '<th style="width:240px;">' . esc_html__('Keyword (one word)', 'aegislink') . '</th>';
echo '<th>' . esc_html__('Destination URL', 'aegislink') . '</th>';
echo '<th style="width:120px;">' . esc_html__('Actions', 'aegislink') . '</th>';
echo '</tr></thead><tbody>';

$rows = !empty($smart_opts['map']) ? $smart_opts['map'] : array();
$min_visible = 5;
if (count($rows) < $min_visible) {
    for ($i = count($rows); $i < $min_visible; $i++) { $rows[] = array('keyword'=>'', 'url'=>''); }
}

$row_index = 0;
foreach ($rows as $row) {
    $kw  = isset($row['keyword']) ? $row['keyword'] : '';
    $url = isset($row['url']) ? $row['url'] : '';
    echo '<tr class="aegislink-smartlinks-row">';
    echo '<td><input class="regular-text" type="text" name="smart_keyword[]" value="' . esc_attr($kw) . '" placeholder="AegisWAF" /></td>';
    echo '<td><input class="large-text" type="url" name="smart_url[]" value="' . esc_attr($url) . '" placeholder="https://aegisify.com/aegiswaf/" /></td>';
    echo '<td>';
    echo '<button type="button" class="button aegislink-add-row" ' . ($row_index === 0 ? '' : 'style="display:none;"') . '>' . esc_html__('Add', 'aegislink') . '</button> ';
    echo '<button type="button" class="button aegislink-remove-row">' . esc_html__('Remove', 'aegislink') . '</button>';
    echo '</td>';
    echo '</tr>';
    $row_index++;
}

echo '</tbody></table>';

echo '<p class="description" style="margin-top:10px;">' . esc_html__('Rules: one keyword = one URL. Keywords are case-insensitive. Existing links are not modified. Max 100 rows.', 'aegislink') . '</p>';

submit_button(__('Save Smart Links', 'aegislink'), 'primary', 'submit', false);
echo '</form>';

echo '<hr style="margin:18px 0;" />';

echo '<h2 style="margin:0 0 8px 0;">' . esc_html__('Suggestions', 'aegislink') . '</h2>';

if ($post_id > 0) {
    $post = get_post($post_id);
    if ($post) {
        echo '<p class="description" style="margin:0 0 10px 0;">' . esc_html__('Showing suggestions for:', 'aegislink') . ' <strong>' . esc_html($post->post_title ? $post->post_title : '(no title)') . '</strong></p>';

        $suggestions = aegislink()->linking->suggest_links($post_id, 10);

        if (!empty($suggestions) && is_array($suggestions)) {
            echo '<ul style="max-width:1100px; margin:0; padding-left:18px;">';
            foreach ($suggestions as $s) {
                $anchor = isset($s['anchor']) ? $s['anchor'] : '';
                $url    = isset($s['url']) ? $s['url'] : '';
                $why    = isset($s['why']) ? $s['why'] : '';
                echo '<li style="margin:0 0 8px 0;">';
                echo '<strong>' . esc_html($anchor) . '</strong> → <a href="' . esc_url($url) . '" target="_blank" rel="noopener noreferrer">' . esc_html($url) . '</a>';
                if ($why) {
                    echo '<div class="description" style="margin-top:2px;">' . esc_html($why) . '</div>';
                }
                echo '</li>';
            }
            echo '</ul>';
        } else {
            echo '<p class="description">' . esc_html__('No suggestions available for this content yet.', 'aegislink') . '</p>';
        }
    } else {
        echo '<p class="description">' . esc_html__('Invalid post/page selected.', 'aegislink') . '</p>';
    }
} else {
    echo '<p class="description">' . esc_html__('Select a Page or Post above to generate internal link suggestions.', 'aegislink') . '</p>';
}

?>
<script>
(function(){
  const table = document.getElementById('aegislink-smartlinks-table');
  if(!table) return;
  const tbody = table.querySelector('tbody');
  const maxRows = <?php echo (int) $max_rows; ?>;

  function updateAddButtons(){
    const rows = tbody.querySelectorAll('tr.aegislink-smartlinks-row');
    rows.forEach((r,i)=>{
      const addBtn = r.querySelector('.aegislink-add-row');
      if(addBtn) addBtn.style.display = (i === rows.length-1) ? '' : 'none';
    });
  }

  function rowCount(){
    return tbody.querySelectorAll('tr.aegislink-smartlinks-row').length;
  }

  tbody.addEventListener('click', function(e){
    const t = e.target;
    if(!(t instanceof HTMLElement)) return;

    if(t.classList.contains('aegislink-add-row')){
      e.preventDefault();
      if(rowCount() >= maxRows) return;

      const tr = t.closest('tr');
      if(!tr) return;

      const clone = tr.cloneNode(true);
      // clear values
      clone.querySelectorAll('input').forEach(inp => inp.value = '');
      tbody.appendChild(clone);
      updateAddButtons();
    }

    if(t.classList.contains('aegislink-remove-row')){
      e.preventDefault();
      const tr = t.closest('tr');
      if(!tr) return;
      const rows = tbody.querySelectorAll('tr.aegislink-smartlinks-row');
      if(rows.length <= 1) return;
      tr.remove();
      updateAddButtons();
    }
  });

  updateAddButtons();
})();
</script>
<?php

echo '</div>';
