<?php
if (!defined('ABSPATH')) { exit; }

if (!current_user_can('edit_posts')) {
    echo '<p>' . esc_html__('Forbidden', 'aegislink') . '</p>';
    return;
}

$opt_key = 'aegislink_wordcloud_defaults';

$defaults = get_option($opt_key, array());
if (!is_array($defaults)) { $defaults = array(); }

$hard = array(
    'title'       => __('Keyword Word Cloud', 'aegislink'),
    'limit'       => 50,
    'min_len'     => 3,
    'max_len'     => 32,
    'show_footer' => 1,
    'lg_size'     => 42,
    'md_size'     => 28,
    'sm_size'     => 18,
    'lg_count'    => 10,
    'md_count'    => 20,
);

$cfg = array_merge($hard, $defaults);
$cfg['show_footer'] = 1; 

if (!empty($_POST['aegislink_wc_save']) && check_admin_referer('aegislink_wc_save_defaults')) {

    $cfg['title']       = sanitize_text_field(wp_unslash($_POST['title'] ?? $cfg['title']));
    $cfg['limit']       = max(5, min(200, (int) ($_POST['limit'] ?? $cfg['limit'])));
    $cfg['min_len']     = max(2, min(20, (int) ($_POST['min_len'] ?? $cfg['min_len'])));
    $cfg['max_len']     = max($cfg['min_len'], min(64, (int) ($_POST['max_len'] ?? $cfg['max_len'])));
    $cfg['show_footer'] = 1;

    $cfg['lg_size']   = max(16, min(120, (int) ($_POST['lg_size'] ?? $cfg['lg_size'])));
    $cfg['md_size']   = max(14, min(100, (int) ($_POST['md_size'] ?? $cfg['md_size'])));
    $cfg['sm_size']   = max(10, min(80,  (int) ($_POST['sm_size'] ?? $cfg['sm_size'])));

    $cfg['lg_count']  = max(0, min(200, (int) ($_POST['lg_count'] ?? $cfg['lg_count'])));
    $cfg['md_count']  = max(0, min(200, (int) ($_POST['md_count'] ?? $cfg['md_count'])));

    update_option($opt_key, $cfg, false);

    echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Word Cloud defaults saved.', 'aegislink') . '</p></div>';
}

$shortcode = sprintf(
    '[aegislink_keywords_block title="%s" limit="%d" min_len="%d" max_len="%d" show_footer="%d" lg_size="%d" md_size="%d" sm_size="%d" lg_count="%d" md_count="%d"]',
    esc_attr($cfg['title']),
    (int) $cfg['limit'],
    (int) $cfg['min_len'],
    (int) $cfg['max_len'],
    (int) $cfg['show_footer'],
    (int) $cfg['lg_size'],
    (int) $cfg['md_size'],
    (int) $cfg['sm_size'],
    (int) $cfg['lg_count'],
    (int) $cfg['md_count']
);

echo '<div class="wrap">';
echo '<h1>' . esc_html__('Word Cloud', 'aegislink') . '</h1>';
echo '<p class="description" style="max-width:1100px;">' . esc_html__('Generate a keyword word cloud from your content. Use the controls below to set your preferred defaults, then paste the shortcode anywhere you want the cloud to appear.', 'aegislink') . '</p>';

echo '<div class="postbox" style="max-width:1100px; padding:14px; margin-top:14px;">';
echo '<h2 style="margin:0 0 10px 0;">' . esc_html__('Word Cloud Defaults', 'aegislink') . '</h2>';
echo '<p class="description" style="margin:0 0 12px 0;">' . esc_html__('These defaults apply when you don’t specify attributes in the shortcode. They also control the visual font-size buckets (how many words appear large/medium/small).', 'aegislink') . '</p>';

echo '<form method="post" action="">';
wp_nonce_field('aegislink_wc_save_defaults');

echo '<table class="form-table" role="presentation">';

echo '<tr><th scope="row"><label for="aegislink_wc_title">' . esc_html__('Title', 'aegislink') . '</label></th>';
echo '<td><input type="text" class="regular-text" id="aegislink_wc_title" name="title" value="' . esc_attr($cfg['title']) . '" /></td></tr>';

echo '<tr><th scope="row">' . esc_html__('Word selection', 'aegislink') . '</th><td>';
echo '<label>' . esc_html__('Limit', 'aegislink') . ' <input type="number" min="5" max="200" name="limit" value="' . esc_attr((int)$cfg['limit']) . '" style="width:90px;" /></label> &nbsp; ';
echo '<label>' . esc_html__('Min length', 'aegislink') . ' <input type="number" min="2" max="20" name="min_len" value="' . esc_attr((int)$cfg['min_len']) . '" style="width:90px;" /></label> &nbsp; ';
echo '<label>' . esc_html__('Max length', 'aegislink') . ' <input type="number" min="2" max="64" name="max_len" value="' . esc_attr((int)$cfg['max_len']) . '" style="width:90px;" /></label>';
echo '<p class="description" style="margin:6px 0 0 0;">' . esc_html__('Tip: keep Max length modest to avoid ultra-long phrases dominating the cloud.', 'aegislink') . '</p>';
echo '</td></tr>';

echo '<tr><th scope="row">' . esc_html__('Font sizes (px)', 'aegislink') . '</th><td>';
echo '<label>' . esc_html__('Large', 'aegislink') . ' <input type="number" min="16" max="120" name="lg_size" value="' . esc_attr((int)$cfg['lg_size']) . '" style="width:90px;" /></label> &nbsp; ';
echo '<label>' . esc_html__('Medium', 'aegislink') . ' <input type="number" min="14" max="100" name="md_size" value="' . esc_attr((int)$cfg['md_size']) . '" style="width:90px;" /></label> &nbsp; ';
echo '<label>' . esc_html__('Small', 'aegislink') . ' <input type="number" min="10" max="80" name="sm_size" value="' . esc_attr((int)$cfg['sm_size']) . '" style="width:90px;" /></label>';
echo '<p class="description" style="margin:6px 0 0 0;">' . esc_html__('These are rendered as real HTML text for readability and search engines (not a canvas image).', 'aegislink') . '</p>';
echo '</td></tr>';

echo '<tr><th scope="row">' . esc_html__('How many words per size', 'aegislink') . '</th><td>';
echo '<label>' . esc_html__('Large count', 'aegislink') . ' <input type="number" min="0" max="200" name="lg_count" value="' . esc_attr((int)$cfg['lg_count']) . '" style="width:90px;" /></label> &nbsp; ';
echo '<label>' . esc_html__('Medium count', 'aegislink') . ' <input type="number" min="0" max="200" name="md_count" value="' . esc_attr((int)$cfg['md_count']) . '" style="width:90px;" /></label>';
echo '<p class="description" style="margin:6px 0 0 0;">' . esc_html__('The remaining words render as Small. Use this to control visual balance without relying on frequency thresholds.', 'aegislink') . '</p>';
echo '</td></tr>';

echo '</table>';

echo '<p><button type="submit" name="aegislink_wc_save" value="1" class="button button-primary">' . esc_html__('Save Defaults', 'aegislink') . '</button></p>';

echo '</form>';
echo '</div>';

echo '<div class="postbox" style="max-width:1100px; padding:14px; margin-top:14px;">';
echo '<h2 style="margin:0 0 8px 0;">' . esc_html__('Shortcode: Keyword Word Cloud', 'aegislink') . '</h2>';
echo '<p class="description" style="margin:0 0 12px 0; max-width:1100px;">'
   . esc_html__('Shortcode Keyword Word Cloud generates a clean, SEO-friendly keyword frequency cloud from your content. It helps you visualize the most important terms on a page, product, or landing page using real HTML text (not a canvas image), making it readable for both visitors and search engines while keeping a professional “word cloud” look and feel.  An example Aegis Word Cloud below.', 'aegislink')
   . '</p>';
   
echo '<div style="margin:16px 0; max-width:1100px;">
        <img src="' . esc_url( plugins_url( 'assets/wordcloud.png', AEGISLINK_FILE ) ) . '"
             alt="' . esc_attr__( 'Keyword Word Cloud Example', 'aegislink' ) . '"
             style="width:650px; max-width:650px; height:auto; display:block; border-radius:6px;" />
      </div>';
	  
echo '<p class="description" style="margin:0 0 12px 0; max-width:1100px;">'
   . esc_html__('From your template, you should be able to add code blocks, so if you insert [aegislink_keywords_block] into the code block without any switches, AegisLink will automatically use the Word Cloud Defaults above (limit, min/max length, font sizes, and size distribution). This is the recommended approach for most sites because it keeps output consistent and easy to manage.', 'aegislink')
   . '</p>';

echo '<p class="description" style="margin:0 0 12px 0; max-width:1100px;">'
   . esc_html__('If you want to override the defaults for a specific page, you can include switches directly in the shortcode. Example: [aegislink_keywords_block title="" limit="50" min_len="3" max_len="32" show_footer="1" lg_size="42" md_size="28" sm_size="18" lg_count="10" md_count="20"]. Use this when you need a different size balance or word limit for a particular post, product, or landing page.', 'aegislink')
   . '</p>';


echo '<pre style="background:#f6f7f7; padding:10px; border:1px solid #dcdcde; overflow:auto;"><code>' . esc_html($shortcode) . '</code></pre>';

echo '<h3 style="margin:14px 0 8px 0;">' . esc_html__('Optional Attributes', 'aegislink') . '</h3>';
echo '<ul style="margin:8px 0 0 18px; list-style:disc;">';
echo '<li><code>title</code> — ' . esc_html__('Title displayed above the cloud.', 'aegislink') . '</li>';
echo '<li><code>limit</code> — ' . esc_html__('Number of words to show (default 50).', 'aegislink') . '</li>';
echo '<li><code>min_len</code> — ' . esc_html__('Minimum keyword length (default 3).', 'aegislink') . '</li>';
echo '<li><code>max_len</code> — ' . esc_html__('Maximum keyword length (default 32).', 'aegislink') . '</li>';
echo '<li><code>lg_size / md_size / sm_size</code> — ' . esc_html__('Font sizes (px) used for Large/Medium/Small buckets.', 'aegislink') . '</li>';
echo '<li><code>lg_count / md_count</code> — ' . esc_html__('How many words render as Large and Medium (remainder becomes Small).', 'aegislink') . '</li>';
echo '<li><code>post_id</code> — ' . esc_html__('Force extraction from a specific post ID (default current page).', 'aegislink') . '</li>';
echo '</ul>';

echo '<p class="description" style="margin:12px 0 0 0;">' . esc_html__('Use this to create a clean, SEO-friendly “keyword snapshot” of a page, product, or landing page.', 'aegislink') . '</p>';

echo '</div>';
echo '</div>';
