<?php
namespace AegisLink\Integrations;

use AegisLink\Shortlinks\Shortlinks;

if (!defined('ABSPATH')) { exit; }

class Woo_Share {

    public function hooks() : void {
        add_action('wp_enqueue_scripts', array($this, 'enqueue_assets'));

        add_action('woocommerce_single_product_summary', array($this, 'render_button_single'), 35);

    }

    public function enqueue_assets() : void {
        if (!$this->is_enabled()) { return; }
        if (!function_exists('is_product') || !is_product()) { return; }

        wp_register_script(
            'aegislink-share-frontend',
            AEGISLINK_URL . 'assets/js/share-frontend.js',
            array(),
            defined('AEGISLINK_VERSION') ? AEGISLINK_VERSION : null,
            true
        );
        wp_enqueue_script('aegislink-share-frontend');
    }

    private function is_enabled() : bool {
        $opts = (array) get_option(Shortlinks::OPT_SETTINGS, array());
        return !empty($opts['woo_share_enabled']);
    }

    public function render_button_single() : void {
        if (!$this->is_enabled()) { return; }
        if (!function_exists('is_product') || !is_product()) { return; }

        global $product;
        if (!$product || !method_exists($product, 'get_id')) { return; }

        $product_id = (int) $product->get_id();
        if ($product_id <= 0) { return; }

        $short_id = (int) get_post_meta($product_id, '_aegislink_shortlink_id', true);
        if ($short_id <= 0) { return; }

        $p = get_post($short_id);
        if (!$p || $p->post_type !== Shortlinks::CPT) { return; }

        $slug = isset($p->post_name) ? (string) $p->post_name : '';
        if ($slug === '') { return; }

        $prefix = 'go';
        $opts = (array) get_option(Shortlinks::OPT_SETTINGS, array());
        if (!empty($opts['prefix'])) {
            $prefix = sanitize_title((string) $opts['prefix']);
        }
        if ($prefix === '') { $prefix = 'go'; }

        $short_url = home_url('/' . $prefix . '/' . $slug);

        echo '<div class="aegislink-share-wrap" style="margin-top:10px;">';
        echo '<a href="' . esc_url($short_url) . '" class="button aegislink-share-btn" data-aegislink-share-url="' . esc_attr($short_url) . '">'
            . esc_html__('Share', 'aegislink')
            . '</a>';
        echo '</div>';
    }
}
