<?php
namespace AegisLink\Log;

if (!defined('ABSPATH')) { exit; }

class Logger {

    public static function file_path() : string {
        if (defined('AEGISLINK_DIR')) {
            return rtrim(AEGISLINK_DIR, '/\\') . '/includes/log/aegislink.log';
        }
        return '';
    }

    public static function write(string $level, string $msg, array $ctx = array()) : void {
        $path = self::file_path();
        if ($path === '') { return; }

        $dir = dirname($path);
        if (!is_dir($dir)) {
            if (function_exists('wp_mkdir_p')) {
                wp_mkdir_p($dir);
            } else {
                @mkdir($dir, 0755, true);
            }
        }

        $ts = function_exists('wp_date') ? wp_date('Y-m-d H:i:s') : gmdate('Y-m-d H:i:s');
        $line = '[' . $ts . '] [' . strtoupper($level) . '] ' . $msg;

        if (!empty($ctx)) {
            $json = function_exists('wp_json_encode') ? wp_json_encode($ctx) : json_encode($ctx);
            $line .= ' | ' . $json;
        }

        $line .= "\n";
        @file_put_contents($path, $line, FILE_APPEND | LOCK_EX);
    }

    public static function info(string $msg, array $ctx = array()) : void { self::write('INFO', $msg, $ctx); }
    public static function warn(string $msg, array $ctx = array()) : void { self::write('WARN', $msg, $ctx); }
    public static function error(string $msg, array $ctx = array()) : void { self::write('ERROR', $msg, $ctx); }
    public static function debug(string $msg, array $ctx = array()) : void { self::write('DEBUG', $msg, $ctx); }
}
