<?php
namespace AegisLink\Shortlinks;

if (!defined('ABSPATH')) { exit; }

class Bulk_Terms {

    public static function get_taxonomies() : array {
        $taxes = get_taxonomies(array(
            'public' => true,
            'show_ui' => true,
        ), 'objects');

        $out = array();
        if (is_array($taxes)) {
            foreach ($taxes as $t) {
                if (!isset($t->name)) { continue; }
                $out[$t->name] = array(
                    'name'  => (string) $t->name,
                    'label' => isset($t->labels->singular_name) ? (string) $t->labels->singular_name : (string) $t->name,
                );
            }
        }

        if (taxonomy_exists('product_cat') && !isset($out['product_cat'])) {
            $out['product_cat'] = array('name'=>'product_cat','label'=>'Product Categories');
        }
        if (taxonomy_exists('product_tag') && !isset($out['product_tag'])) {
            $out['product_tag'] = array('name'=>'product_tag','label'=>'Product Tags');
        }

        ksort($out);
        return $out;
    }

    public static function build_slug_for_term($term, string $strategy = 'term') : string {
        $base = isset($term->slug) ? (string) $term->slug : '';
        $base = sanitize_title($base);

        if ($base === '') {
            $base = 'term-' . (isset($term->term_id) ? (int) $term->term_id : 0);
        }

        if ($strategy === 'cat') {
            return 'cat-' . $base;
        }
        if ($strategy === 'tag') {
            return 'tag-' . $base;
        }

        return $base;
    }
}
