<?php
if (!defined('ABSPATH')) { exit; }

$license = aegislink()->license;

if (!current_user_can('read')) {
    echo '<p>' . esc_html__('Forbidden', 'aegislink') . '</p>';
    return;
}

$tab = isset($_GET['tab']) ? sanitize_key($_GET['tab']) : 'license';
if (!in_array($tab, array('license','helper'), true)) { $tab = 'license'; }

if ($tab === 'license') {
    if (!empty($_POST['aegislink_license_save'])) {
        check_admin_referer('aegislink_license_save');

        $key = isset($_POST['license_key']) ? sanitize_text_field($_POST['license_key']) : '';
        $email = isset($_POST['license_email']) ? sanitize_email($_POST['license_email']) : '';

        $license->set_key($key);
        update_option('aegislink_license_email', $email, false);

        // Check immediately
        $license->check_now(AEGISLINK_VERSION);

        echo '<div class="notice notice-success"><p>' . esc_html__('License saved.', 'aegislink') . '</p></div>';
    }

    if (!empty($_POST['aegislink_license_refresh'])) {
        check_admin_referer('aegislink_license_refresh');
        $license->check_now(AEGISLINK_VERSION);
        echo '<div class="notice notice-success"><p>' . esc_html__('License status refreshed.', 'aegislink') . '</p></div>';
    }
}

$status = method_exists($license, 'get_status') ? $license->get_status() : (method_exists($license, 'get_cached_status') ? $license->get_cached_status() : array());

echo '<div class="wrap">';
echo '<h1>' . esc_html__('AegisLink', 'aegislink') . '</h1>';

$base_url = admin_url('admin.php?page=aegislink-license');
echo '<h2 class="nav-tab-wrapper">';
echo '<a href="' . esc_url(add_query_arg(array('tab'=>'license'), $base_url)) . '" class="nav-tab ' . ($tab==='license' ? 'nav-tab-active' : '') . '">' . esc_html__('License', 'aegislink') . '</a>';
echo '<a href="' . esc_url(add_query_arg(array('tab'=>'helper'), $base_url)) . '" class="nav-tab ' . ($tab==='helper' ? 'nav-tab-active' : '') . '">' . esc_html__('Helper', 'aegislink') . '</a>';
echo '</h2>';

if ($tab === 'helper') {

    echo '<div class="postbox" style="max-width:1100px; padding:14px; margin-top:14px;">';
    echo '<h2 style="margin:0 0 8px 0;">' . esc_html__('Shortcode: Keyword Word Cloud', 'aegislink') . '</h2>';
    echo '<p class="description" style="margin:0 0 12px 0;">' . esc_html__('This shortcode scans the content of the current Page/Post (or a specific ID) and renders a keyword word cloud based on word frequency.', 'aegislink') . '</p>';

    echo '<h3 style="margin:14px 0 8px 0;">' . esc_html__('Basic Usage', 'aegislink') . '</h3>';
    echo '<pre class="code" style="padding:10px; background:#f6f7f7; overflow:auto;">[aegislink_keywords_block]</pre>';
    echo '<p class="description">' . esc_html__('Place this in any Page, Post, or text block that supports shortcodes.', 'aegislink') . '</p>';

    echo '<h3 style="margin:14px 0 8px 0;">' . esc_html__('Optional Attributes', 'aegislink') . '</h3>';
    echo '<ul style="margin:0; padding-left:18px;">';
    echo '<li><strong>title</strong> — ' . esc_html__('Heading above the cloud (default: “The Most Blocked Keywords”)', 'aegislink') . '</li>';
    echo '<li><strong>limit</strong> — ' . esc_html__('How many keywords to show (default: 25, max: 100)', 'aegislink') . '</li>';
    echo '<li><strong>post_id</strong> — ' . esc_html__('Scan a specific Page/Post by ID (default: current page/post)', 'aegislink') . '</li>';
    echo '</ul>';

    echo '<h3 style="margin:14px 0 8px 0;">' . esc_html__('Examples', 'aegislink') . '</h3>';
    echo '<pre class="code" style="padding:10px; background:#f6f7f7; overflow:auto;">'
        . '[aegislink_keywords_block limit="30" title="The Most Blocked Keywords"]' . "\n"
        . '[aegislink_keywords_block post_id="123" limit="40"]'
        . '</pre>';

    echo '<h3 style="margin:14px 0 8px 0;">' . esc_html__('Notes', 'aegislink') . '</h3>';
    echo '<ul style="margin:0; padding-left:18px;">';
    echo '<li>' . esc_html__('Words inside existing links, code blocks, and scripts/styles are ignored.', 'aegislink') . '</li>';
    echo '<li>' . esc_html__('The “Powered by AegisSEO” footer is added automatically beneath the cloud.', 'aegislink') . '</li>';
    echo '</ul>';

    echo '</div>';

    echo '</div>'; // wrap
    return;
}

// LICENSE TAB (default)
echo '<form method="post" action="">';
wp_nonce_field('aegislink_license_save');
echo '<input type="hidden" name="aegislink_license_save" value="1" />';

echo '<table class="form-table" role="presentation">';
echo '<tr><th scope="row"><label for="license_key">' . esc_html__('License Key', 'aegislink') . '</label></th>';
echo '<td><input type="text" id="license_key" name="license_key" class="regular-text" value="' . esc_attr($license->get_key()) . '" /></td></tr>';

echo '<tr><th scope="row"><label for="license_email">' . esc_html__('Email (optional)', 'aegislink') . '</label></th>';
echo '<td><input type="email" id="license_email" name="license_email" class="regular-text" value="' . esc_attr(get_option('aegislink_license_email', '')) . '" /></td></tr>';
echo '</table>';

submit_button(__('Save License', 'aegislink'));
echo '</form>';

echo '<form method="post" action="" style="margin-top:10px;">';
wp_nonce_field('aegislink_license_refresh');
echo '<input type="hidden" name="aegislink_license_refresh" value="1" />';
submit_button(__('Refresh Status', 'aegislink'), 'secondary', 'submit', false);
echo '</form>';

echo '<h2 style="margin-top:18px;">' . esc_html__('Current Status', 'aegislink') . '</h2>';
echo '<table class="widefat striped" style="max-width:1100px;">';
echo '<thead><tr><th>' . esc_html__('Field', 'aegislink') . '</th><th>' . esc_html__('Value', 'aegislink') . '</th></tr></thead><tbody>';

$fields = array(
    'success' => !empty($status['success']) ? 'true' : 'false',
    'is_pro'  => !empty($status['is_pro']) ? 'true' : 'false',
    'plan'    => isset($status['plan']) ? (string) $status['plan'] : '',
    'expires' => isset($status['expires']) ? (string) $status['expires'] : '',
    'max_sites' => isset($status['max_sites']) ? (string) $status['max_sites'] : '',
    'last_check' => isset($status['checked_at']) ? (string) $status['checked_at'] : '',
    'message' => isset($status['message']) ? (string) $status['message'] : '',
);

foreach ($fields as $k => $v) {
    echo '<tr><td><strong>' . esc_html($k) . '</strong></td><td>' . esc_html($v) . '</td></tr>';
}
echo '</tbody></table>';

echo '<hr style="margin:22px 0;" />';
echo '<h2>' . esc_html__('Need a license?', 'aegislink') . '</h2>';
echo '<p>' . wp_kses_post(sprintf(__('Create an account at %s and buy a license to unlock PRO features.', 'aegislink'),
    '<a href="https://aegisify.com/register/" target="_blank" rel="noopener noreferrer">https://aegisify.com/register/</a>'
)) . '</p>';

echo '</div>';
