<?php
namespace AegisSEO\Admin;

use AegisSEO\SEO\Score;
use AegisSEO\Utils\Options;

if (!defined('ABSPATH')) { exit; }

class Admin_Ajax {

    private $options;

    private $score;

    public function __construct(Options $options, Score $score) {
        $this->options = $options;
        $this->score   = $score;

        add_action('wp_ajax_aegisseo_analyze_content', array($this, 'analyze_content'));
        add_action('wp_ajax_aegisseo_bulk_save_ajax', array($this, 'bulk_save_ajax'));
    }

    public function analyze_content() {
        if (!current_user_can('edit_posts')) {
            wp_send_json_error(array('message' => 'Forbidden'), 403);
        }
        check_ajax_referer('aegisseo_analyze', 'nonce');

        $post_id = isset($_POST['post_id']) ? (int) $_POST['post_id'] : 0;

        $focus = isset($_POST['focus']) ? sanitize_text_field(wp_unslash($_POST['focus'])) : '';
        $title = isset($_POST['title']) ? sanitize_text_field(wp_unslash($_POST['title'])) : '';
        $desc  = isset($_POST['description']) ? sanitize_textarea_field(wp_unslash($_POST['description'])) : '';
        $content = isset($_POST['content']) ? (string) wp_unslash($_POST['content']) : '';

        $result = $this->score->analyze_raw($post_id, $content, $title, $desc, $focus);

        wp_send_json_success($result);
    }
    public function bulk_save_ajax() {
        if (!current_user_can('manage_options')) {
            wp_send_json_error(array('message' => 'Forbidden'), 403);
        }
        check_ajax_referer('aegisseo_bulk_save_ajax', 'nonce');

        $rows = isset($_POST['rows']) ? (array) $_POST['rows'] : array();
        $updated = 0;
        $skipped = 0;
        $errors = array();

        foreach ($rows as $post_id => $data) {
            $post_id = (int) $post_id;
            if ($post_id <= 0) { $skipped++; continue; }
            if (!current_user_can('edit_post', $post_id)) { $skipped++; continue; }

            $title = isset($data['title']) ? sanitize_text_field(wp_unslash($data['title'])) : '';
            $desc  = isset($data['description']) ? sanitize_textarea_field(wp_unslash($data['description'])) : '';
            $canon = isset($data['canonical']) ? esc_url_raw((string) wp_unslash($data['canonical'])) : '';
            $noindex = !empty($data['noindex']) ? 1 : 0;
            $nofollow= !empty($data['nofollow']) ? 1 : 0;

            update_post_meta($post_id, '_aegisseo_title', $title);
            update_post_meta($post_id, '_aegisseo_description', $desc);
            update_post_meta($post_id, '_aegisseo_canonical', $canon);
            update_post_meta($post_id, '_aegisseo_noindex', $noindex);
            update_post_meta($post_id, '_aegisseo_nofollow', $nofollow);

            $updated++;
        }

        wp_send_json_success(array(
            'updated' => (int) $updated,
            'skipped' => (int) $skipped,
            'errors'  => $errors,
        ));
    }


}
