<?php
namespace AegisSEO\Admin;

use AegisSEO\Utils\Options;

require_once AEGISSEO_DIR . 'includes/class-aegisify-bundled-plugins-page.php';

if (!defined('ABSPATH')) { exit; }

class Admin_Menu {

	private function get_capability() {
		return 'read';
	}

	private function role_allows() {
		$opts = $this->options->get_all();
		$allowed = $opts['allowed_roles'] ?? array('administrator' => 1);

		if (current_user_can('manage_options')) {
			return true;
		}

		$user = wp_get_current_user();
		if (!$user || empty($user->roles)) {
			return false;
		}

		foreach ($user->roles as $r) {
			if (!empty($allowed[$r])) {
				return true;
			}
		}

		return false;
	}

    private $options;

    public function __construct(Options $options) {
        $this->options = $options;
        add_action('admin_menu', array($this, 'register_menu'));
        add_action('admin_enqueue_scripts', array($this, 'enqueue_assets'));
    }

	public function register_menu() {
		add_menu_page(
			__('AegisSEO', 'aegisseo'),
			__('AegisSEO', 'aegisseo'),
			$this->get_capability(),
			'aegisseo',
			array($this, 'render_main'),
			'dashicons-chart-area',
			58
		);

		if (class_exists('\\Aegisify_Bundled_Plugins_Page')) {
			\Aegisify_Bundled_Plugins_Page::init(array(
				'parent_slug' => 'aegisseo',
			));
			\Aegisify_Bundled_Plugins_Page::add_submenu();
		}
	}

    public function enqueue_assets($hook) {
        if (strpos($hook, 'aegisseo') === false) { return; }
        wp_enqueue_style('dashicons');
        wp_enqueue_style('aegisseo-admin', AEGISSEO_URL . 'assets/css/admin.css', array('dashicons'), AEGISSEO_VERSION);
        wp_enqueue_script('aegisseo-admin', AEGISSEO_URL . 'assets/js/admin.js', array('jquery'), AEGISSEO_VERSION, true);

        $tab = isset($_GET['tab']) ? sanitize_key((string)$_GET['tab']) : '';
        if ($tab === 'ops') {
            wp_enqueue_script('aegisseo-chartjs', 'https://cdn.jsdelivr.net/npm/chart.js', array(), AEGISSEO_VERSION, true);
            wp_enqueue_script('aegisseo-ops-center', AEGISSEO_URL . 'assets/js/ops-center.js', array('jquery','aegisseo-chartjs'), AEGISSEO_VERSION, true);
        }
        wp_localize_script('aegisseo-admin', 'AegisSEOAdmin', array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce'    => wp_create_nonce('aegisseo_analyze'),
        ));
    }

private function redirect_to_tab($tab) {
    wp_safe_redirect(admin_url('admin.php?page=aegisseo&tab=' . $tab));
    exit;
}

public function redirect_global() { $this->redirect_to_tab('global'); }
public function redirect_social() { $this->redirect_to_tab('social'); }
public function redirect_sitemap() { $this->redirect_to_tab('sitemap'); }
public function redirect_schema() { $this->redirect_to_tab('schema'); }
public function redirect_tools() { $this->redirect_to_tab('tools'); }


    public function redirect_404() { $this->redirect_to_tab('404'); }
    public function redirect_redirects() { $this->redirect_to_tab('redirects'); }
    public function redirect_advanced() { $this->redirect_to_tab('advanced'); }
	public function render_main() {
		if (!$this->role_allows()) {
			wp_die(esc_html__('Sorry, you are not allowed to access this page.', 'aegisseo'));
		}
		require AEGISSEO_DIR . 'views/admin/settings-page.php';
	}

    public function render_wizard() {
        if (!current_user_can($this->get_capability())) { return; }
        require AEGISSEO_DIR . 'views/admin/wizard-page.php';
    }
}
