<?php
namespace AegisSEO\Admin;

use AegisSEO\Utils\Options;
use AegisSEO\Utils\Sanitize;

if (!defined('ABSPATH')) { exit; }

class Admin_Wizard {

    private $options;

    public function __construct(Options $options) {
        $this->options = $options;

        add_action('admin_post_aegisseo_wizard_save', array($this, 'handle_save'));
        add_action('admin_init', array($this, 'set_wizard_transient_on_activation'));
    }

    public function set_wizard_transient_on_activation() {

        $opts = $this->options->get_all();
        if ((int) $opts['wizard_complete'] === 1) { return; }

        if (isset($_GET['activate']) && $_GET['activate'] === 'true') {
    $activated_plugin = isset($_GET['plugin']) ? sanitize_text_field(wp_unslash($_GET['plugin'])) : '';
    $self_plugin = function_exists('plugin_basename') ? plugin_basename(AEGISSEO_FILE) : '';
    if ($activated_plugin && $self_plugin && $activated_plugin === $self_plugin) {
        set_transient('aegisseo_do_wizard', '1', 60);
    }
}
    }

    public function handle_save() {
        if (!current_user_can('manage_options')) { wp_die('Forbidden'); }
        check_admin_referer('aegisseo_wizard_save');

        $site_type = Sanitize::text($_POST['site_type'] ?? 'organization', 20);
        if (!in_array($site_type, array('organization','person'), true)) {
            $site_type = 'organization';
        }

        $org_name = Sanitize::text($_POST['org_name'] ?? '', 150);
        $person_name = Sanitize::text($_POST['person_name'] ?? '', 150);
        $logo_id = Sanitize::int($_POST['logo_id'] ?? 0);

        $social = array(
            'facebook'  => Sanitize::url($_POST['social_facebook'] ?? ''),
            'twitter'   => Sanitize::url($_POST['social_twitter'] ?? ''),
            'instagram' => Sanitize::url($_POST['social_instagram'] ?? ''),
            'linkedin'  => Sanitize::url($_POST['social_linkedin'] ?? ''),
            'youtube'   => Sanitize::url($_POST['social_youtube'] ?? ''),
        );

        $this->options->update(array(
            'site_type' => $site_type,
            'org_name' => $org_name,
            'person_name' => $person_name,
            'logo_id' => $logo_id,
            'social_profiles' => $social,
            'title_home' => Sanitize::text($_POST['title_home'] ?? $this->options->get('title_home'), 300),
            'wizard_complete' => 1,
        ));

        wp_safe_redirect(admin_url('admin.php?page=aegisseo&wizard=done'));
        exit;
    }
}
