<?php
namespace AegisSEO\Admin;

use AegisSEO\Utils\Options;
use AegisSEO\SEO\Score;

if (!defined('ABSPATH')) { exit; }

class Admin {

    private $options;

    private $menu;

    private $settings;

    private $wizard;

    private $metabox;

    private $technical;

    private $tools;

    private $issues;

    private $ajax;

    private $bulk;

    private $migration;

    private $ops;

    public function __construct(Options $options, Score $score) {
        $this->options = $options;

        $this->menu     = new Admin_Menu($this->options);
        $this->settings = new Admin_Settings($this->options);
        $this->wizard   = new Admin_Wizard($this->options);
        $this->metabox  = new Admin_Metabox($this->options);
        $this->tools    = new Admin_Tools($this->options);
        $this->issues   = new Admin_Issues();
        $this->ajax     = new Admin_Ajax($this->options, $score);
        $this->bulk     = new Admin_Bulk($this->options);
        $this->migration= new Admin_Migration($this->options);
        $this->ops      = new Admin_Ops($this->options);

        add_action('admin_init', array($this, 'maybe_redirect_to_wizard'));
        add_action('plugins_loaded', array($this, 'load_textdomain'));
    }

    public function load_textdomain() {
        load_plugin_textdomain('aegisseo', false, dirname(AEGISSEO_BASENAME) . '/languages');
    }

    public function maybe_redirect_to_wizard() {
        if (!current_user_can('manage_options')) { return; }
        if (defined('DOING_AJAX') && DOING_AJAX) { return; }

        $opts = $this->options->get_all();
        $complete = (int) $opts['wizard_complete'];

        if ($complete === 1) { return; }

        if (get_transient('aegisseo_do_wizard') !== '1') { return; }
        delete_transient('aegisseo_do_wizard');

        wp_safe_redirect(admin_url('admin.php?page=aegisseo&tab=setup'));
        exit;
    }
}
