<?php
namespace AegisSEO\SEO;

if (!defined('ABSPATH')) { exit; }

class Linking {
    public function suggest_links($post_id, $limit = 8) {
        $post = get_post($post_id);
        if (!$post) return array();
        $keywords = $this->extract_keywords($post_id);
        if (empty($keywords)) return array();

        $q = new \WP_Query(array(
            'post_type' => 'any',
            'post_status' => 'publish',
            'posts_per_page' => max(1,(int)$limit),
            'post__not_in' => array((int)$post_id),
            's' => implode(' ', array_slice($keywords,0,6)),
            'no_found_rows' => true,
        ));

        $out = array();
        foreach ((array)$q->posts as $p) {
            $out[] = array('ID'=>$p->ID,'title'=>get_the_title($p->ID),'url'=>get_permalink($p->ID));
        }
        wp_reset_postdata();
        return $out;
    }

    private function extract_keywords($post_id) {
        $title = strtolower((string)get_the_title($post_id));
        $terms = wp_get_post_terms($post_id, array('category','post_tag'), array('fields'=>'names'));
        if (!is_array($terms)) $terms = array();
        $text = $title . ' ' . strtolower(implode(' ', $terms));
        $text = preg_replace('/[^a-z0-9\s]/', ' ', $text);
        $words = preg_split('/\s+/', $text, -1, PREG_SPLIT_NO_EMPTY);

        $stop = array('the','and','for','with','that','this','from','your','you','are','was','were','but','not','have','has','had','into','onto','over','under','about','how','why','what','when','where','which','who','a','an','to','in','on','of','is','it');
        $k = array();
        foreach ($words as $w) {
            if (strlen($w) < 3) continue;
            if (in_array($w,$stop,true)) continue;
            $k[] = $w;
        }
        return array_values(array_unique($k));
    }
}
