<?php
namespace AegisSEO\SEO;

if (!defined('ABSPATH')) { exit; }

class Variables {

    public static function replace($template, $context = array()) {
        $template = is_string($template) ? $template : '';

        $sep = isset($context['sep']) ? $context['sep'] : '|';

        $replacements = array(
            '%%title%%'   => isset($context['title']) ? $context['title'] : '',
            '%%sitename%%'=> get_bloginfo('name'),
            '%%tagline%%' => get_bloginfo('description'),
            '%%sep%%'     => ' ' . $sep . ' ',
            '%%excerpt%%' => isset($context['excerpt']) ? $context['excerpt'] : '',
            '%%term%%'    => isset($context['term']) ? $context['term'] : '',
            '%%category%%'=> isset($context['category']) ? $context['category'] : '',
        );

        $out = strtr($template, $replacements);
        $out = preg_replace('/\s{2,}/', ' ', trim($out));
        return $out;
    }

    public static function get_excerpt_for_post($post) {
        if (!$post) { return ''; }
        $excerpt = has_excerpt($post) ? $post->post_excerpt : '';
        if (empty($excerpt)) {
            $content = wp_strip_all_tags($post->post_content);
            $content = preg_replace('/\s{2,}/', ' ', trim($content));
            $excerpt = mb_substr($content, 0, 160);
        }
        return $excerpt;
    }
}
