<?php
if (!defined('ABSPATH')) { exit; }

$aegisseo_has_pro = false;
if (function_exists('aegisseo') && isset(aegisseo()->license) && aegisseo()->license) {
    $aegisseo_has_pro = (bool) aegisseo()->license->is_pro();
}

if (!$aegisseo_has_pro && class_exists('AegisSEO\\Utils\\License')) {

    \AegisSEO\Utils\License::render_pro_banner(
        __('Upgrade to PRO', 'aegisseo'),
        __('(PRO feature: Evidence Reporting (GSC deltas, annotations, annotated events, and “why” explanations) is available in AegisSEO PRO.)', 'aegisseo')
    );

    echo '<p class="description" style="margin-top:10px;">' .
        esc_html__('Activate a PRO license to unlock Evidence Reporting.', 'aegisseo') .
    '</p>';

    return;
}

$post_id = isset($_GET['post_id']) ? absint($_GET['post_id']) : 0;
$url = isset($_GET['url']) ? esc_url_raw(wp_unslash($_GET['url'])) : '';
?>

<form method="get" action="" style="margin:10px 0 16px;">
    <input type="hidden" name="page" value="aegisseo" />
    <input type="hidden" name="tab" value="evidence" />
    <label for="aegisseo-evidence-url" style="display:block; font-weight:600; margin-bottom:6px;"><?php echo esc_html__('Evidence Timeline per URL', 'aegisseo'); ?></label>
    <div style="display:flex; gap:8px; align-items:center; flex-wrap:wrap;">
        <input id="aegisseo-evidence-url" class="regular-text" type="url" name="url" value="<?php echo esc_attr($url); ?>" placeholder="<?php echo esc_attr(site_url('/example-page/')); ?>" style="min-width:320px;" />
        <button class="button"><?php echo esc_html__('Load', 'aegisseo'); ?></button>
        <?php if ($post_id): ?>
            <a class="button button-link-delete" href="<?php echo esc_url(admin_url('admin.php?page=aegisseo&tab=evidence')); ?>"><?php echo esc_html__('Clear', 'aegisseo'); ?></a>
        <?php endif; ?>
    </div>
    <p class="description" style="margin-top:6px;"><?php echo esc_html__('Paste a URL from your site. AegisSEO will resolve it to a post/page and show exactly what changed and what happened in Search Console.', 'aegisseo'); ?></p>
</form>

<?php
$ran = isset($_GET['ran']) ? (int) $_GET['ran'] : 0;
if ($ran === 1) {
    echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Snapshot runner executed (best-effort).', 'aegisseo') . '</p></div>';
}

$post_id = isset($_GET['post_id']) ? absint($_GET['post_id']) : 0;
$url = isset($_GET['url']) ? esc_url_raw(wp_unslash($_GET['url'])) : '';
if ($post_id === 0 && $url !== '') {
    $post_id = url_to_postid($url);
}


?>
<h2><?php echo esc_html__('Evidence Reporting', 'aegisseo'); ?></h2>
<p class="description">
    <?php echo esc_html__('Proof > toggles. This screen correlates SEO changes (events) with Search Console metrics (snapshots) to explain what moved and why.', 'aegisseo'); ?>
</p>

<div style="margin:16px 0; padding:12px; border:1px solid #dcdcde; background:#fff;">
    <strong><?php echo esc_html__('Snapshot Runner', 'aegisseo'); ?></strong>
    <p class="description" style="margin-top:6px;">
        <?php echo esc_html__('Runs a best-effort GSC snapshot pull (last 3 days window, up to 50 latest posts). Use daily cron for normal operation.', 'aegisseo'); ?>
    </p>
    <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="margin:0;">
        <?php wp_nonce_field('aegisseo_run_gsc_snapshot_now'); ?>
        <input type="hidden" name="action" value="aegisseo_run_gsc_snapshot_now" />
        <button class="button button-secondary" type="submit"><?php echo esc_html__('Run Snapshots Now', 'aegisseo'); ?></button>
    </form>
</div>

<div style="margin:16px 0; padding:12px; border:1px solid #dcdcde; background:#fff;">
    <strong><?php echo esc_html__('Per-Page Before/After Card', 'aegisseo'); ?></strong>

    <form method="get" action="<?php echo esc_url(admin_url('admin.php')); ?>" style="margin-top:10px;">
        <input type="hidden" name="page" value="aegisseo" />
        <input type="hidden" name="tab" value="evidence" />
        <label for="aegisseo_evidence_post" style="display:inline-block; min-width:120px;"><?php echo esc_html__('Choose Page', 'aegisseo'); ?></label>
        <select name="post_id" id="aegisseo_evidence_post">
            <option value="0"><?php echo esc_html__('-- Select --', 'aegisseo'); ?></option>
            <?php
            $picks = get_posts(array(
                'post_type' => 'any',
                'post_status' => 'publish',
                'posts_per_page' => 50,
                'orderby' => 'modified',
                'order' => 'DESC',
            ));
            foreach ($picks as $p) {
                echo '<option value="' . (int)$p->ID . '" ' . selected($post_id, (int)$p->ID, false) . '>' . esc_html(get_the_title($p->ID)) . ' (#' . (int)$p->ID . ')</option>';
            }
            ?>
        </select>
        <button class="button" type="submit" style="margin-left:8px;"><?php echo esc_html__('View Evidence', 'aegisseo'); ?></button>
    </form>

    <?php if ($post_id > 0): ?>
        <?php
        $post = get_post($post_id);
        $url = $post ? get_permalink($post_id) : '';
        $series = array();
        if (isset(aegisseo()->gsc_snapshots) && aegisseo()->gsc_snapshots) {
            $series = aegisseo()->gsc_snapshots->get_series($post_id, 28);
        }

        $last14 = 0; $prev14 = 0;
        if (!empty($series)) {
            $by = array();
            foreach ($series as $row) {
                $by[(string)$row['snap_date']] = $row;
            }
            $dates = array_keys($by);
            sort($dates);
            $cut = max(0, count($dates)-14);
            $last_dates = array_slice($dates, $cut);
            $prev_dates = array_slice($dates, max(0, $cut-14), 14);

            foreach ($last_dates as $d) { $last14 += isset($by[$d]['clicks']) ? (float)$by[$d]['clicks'] : 0; }
            foreach ($prev_dates as $d) { $prev14 += isset($by[$d]['clicks']) ? (float)$by[$d]['clicks'] : 0; }
        }

        $delta = ($prev14 > 0) ? (($last14 - $prev14) / $prev14) * 100 : 0;
        ?>
        <hr style="margin:14px 0;" />
        <h3 style="margin:0;"><?php echo esc_html(get_the_title($post_id)); ?></h3>
        <p class="description" style="margin-top:6px;">
            <a href="<?php echo esc_url($url); ?>" target="_blank" rel="noopener"><?php echo esc_html($url); ?></a>
        </p>

        <div style="display:flex; gap:12px; flex-wrap:wrap; margin-top:10px;">
            <div style="flex:1; min-width:220px; padding:10px; border:1px solid #dcdcde; background:#f6f7f7;">
                <div style="font-size:12px; color:#666;"><?php echo esc_html__('Clicks (last 14 days)', 'aegisseo'); ?></div>
                <div style="font-size:22px; font-weight:600;"><?php echo esc_html(number_format_i18n($last14, 2)); ?></div>
            </div>
            <div style="flex:1; min-width:220px; padding:10px; border:1px solid #dcdcde; background:#f6f7f7;">
                <div style="font-size:12px; color:#666;"><?php echo esc_html__('Clicks (previous 14 days)', 'aegisseo'); ?></div>
                <div style="font-size:22px; font-weight:600;"><?php echo esc_html(number_format_i18n($prev14, 2)); ?></div>
            </div>
            <div style="flex:1; min-width:220px; padding:10px; border:1px solid #dcdcde; background:#f6f7f7;">
                <div style="font-size:12px; color:#666;"><?php echo esc_html__('Change', 'aegisseo'); ?></div>
                <div style="font-size:22px; font-weight:600;">
                    <?php
                    $sign = ($last14 - $prev14) >= 0 ? '+' : '';
                    echo esc_html($sign . number_format_i18n(($last14 - $prev14), 2));
                    ?>
                    <span style="font-size:14px; color:#666;">(<?php echo esc_html(number_format_i18n($delta, 1)); ?>%)</span>
                </div>
            </div>
        </div>

        <div style="margin-top:12px;">
            <strong><?php echo esc_html__('Annotated Timeline (snapshots + events)', 'aegisseo'); ?></strong>
            <p class="description" style="margin-top:6px;">
                <?php echo esc_html__('Each row is a daily snapshot. Events are shown as markers (title/meta/schema/redirect/link actions).', 'aegisseo'); ?>
            </p>
            <?php

            $ev = array();
            if (isset(aegisseo()->events) && aegisseo()->events) {
                $ev = aegisseo()->events->get_recent(200, 'post', $post_id);
            }
            $ev_by_date = array();
            foreach ((array)$ev as $e) {
                if (empty($e['created_at'])) continue;
                $d = substr((string)$e['created_at'], 0, 10);
                if (!isset($ev_by_date[$d])) $ev_by_date[$d] = array();
                $ev_by_date[$d][] = $e;
            }

            $max_clicks = 0;
            foreach ((array)$series as $s) {
                $c = isset($s['clicks']) ? (float)$s['clicks'] : 0;
                if ($c > $max_clicks) $max_clicks = $c;
            }
            if ($max_clicks <= 0) $max_clicks = 1;
            ?>

            <table class="widefat striped" style="margin-top:10px;">
                <thead>
                    <tr>
                        <th style="width:120px;"><?php echo esc_html__('Date', 'aegisseo'); ?></th>
                        <th style="width:90px;"><?php echo esc_html__('Clicks', 'aegisseo'); ?></th>
                        <th><?php echo esc_html__('Trend + Event Markers', 'aegisseo'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($series)): ?>
                        <tr><td colspan="3"><?php echo esc_html__('No snapshots yet for this page. Run the snapshot runner and ensure GSC is connected.', 'aegisseo'); ?></td></tr>
                    <?php else: ?>
                        <?php foreach ($series as $s): ?>
                            <?php
                            $d = (string)$s['snap_date'];
                            $clicks = isset($s['clicks']) ? (float)$s['clicks'] : 0;
                            $w = (int) round(($clicks / $max_clicks) * 100);
                            $markers = isset($ev_by_date[$d]) ? $ev_by_date[$d] : array();
                            ?>
                            <tr>
                                <td><code><?php echo esc_html($d); ?></code></td>
                                <td><?php echo esc_html(number_format_i18n($clicks, 2)); ?></td>
                                <td>
                                    <div style="height:12px; background:#e5e5e5; border-radius:8px; overflow:hidden; display:inline-block; width:220px; vertical-align:middle;">
                                        <div style="height:12px; width:<?php echo (int)$w; ?>%; background:#2271b1;"></div>
                                    </div>
                                    <?php if (!empty($markers)): ?>
                                        <span style="margin-left:10px;">
                                            <?php foreach ($markers as $e): ?>
                                                <?php
                                                $t = isset($e['event_type']) ? (string)$e['event_type'] : '';
                                                $label = $t;
                                                if ($t === 'schema_approved') $label = 'Schema';
                                                if ($t === 'links_applied') $label = 'Links';
                                                if ($t === 'redirect_approved') $label = 'Redirect';
                                                if ($t === 'fix_applied') $label = 'Fix';
                                                if ($t === 'meta_update' || $t === 'meta_add' || $t === 'meta_delete') $label = 'Meta';
                                                ?>
                                                <span title="<?php echo esc_attr($t); ?>" style="display:inline-block; margin-right:6px; padding:2px 6px; border-radius:10px; border:1px solid #dcdcde; background:#fff; font-size:11px;">
                                                    <?php echo esc_html($label); ?>
                                                </span>
                                            <?php endforeach; ?>
                                        </span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>

            <?php
            $schema_event_date = '';
            foreach ((array)$ev as $e) {
                if (!empty($e['event_type']) && $e['event_type'] === 'schema_approved' && !empty($e['created_at'])) {
                    $schema_event_date = substr((string)$e['created_at'], 0, 10);
                    break;
                }
            }
            if ($schema_event_date !== '' && $prev14 > 0 && $last14 > $prev14):
            ?>
                <div style="margin-top:12px; padding:10px; border-left:4px solid #2271b1; background:#f0f6fc;">
                    <strong><?php echo esc_html__('Why it moved', 'aegisseo'); ?></strong>
                    <p style="margin:6px 0 0;">
                        <?php echo esc_html__('Clicks improved after a schema change was applied. Review queries in GSC to confirm which terms benefited.', 'aegisseo'); ?>
                        <span style="color:#666;"><?php echo esc_html__('Schema event date:', 'aegisseo'); ?> <code><?php echo esc_html($schema_event_date); ?></code></span>
                    </p>
                </div>
            
            <?php
            $property = isset(aegisseo()->options) ? (string) aegisseo()->options->get('gsc_property', '') : '';
            $page_url = $url;
            if ($property !== '' && !empty(aegisseo()->gsc) && method_exists(aegisseo()->gsc, 'fetch_page_queries')) {
                $cache_key = 'aegisseo_gsc_q_' . (int)$post_id . '_' . md5($property . '|' . $page_url . '|' . $p14_start . '|' . $last14_start);
                $qpack = get_transient($cache_key);
                if (!is_array($qpack)) {
                    $q_last = aegisseo()->gsc->fetch_page_queries($property, $page_url, $last14_start, $today, 12);
                    $q_prev = aegisseo()->gsc->fetch_page_queries($property, $page_url, $p14_start, $p14_end, 12);
                    $qpack = array('last'=>$q_last, 'prev'=>$q_prev);
                    set_transient($cache_key, $qpack, 10 * MINUTE_IN_SECONDS);
                }

                $q_last = $qpack['last'];
                $q_prev = $qpack['prev'];

                if (!is_wp_error($q_last) && !is_wp_error($q_prev)) {
                    $m_last = array();
                    foreach ((array)$q_last as $r) { $m_last[(string)$r['query']] = $r; }
                    $m_prev = array();
                    foreach ((array)$q_prev as $r) { $m_prev[(string)$r['query']] = $r; }

                    $diff = array();
                    $allq = array_unique(array_merge(array_keys($m_last), array_keys($m_prev)));
                    foreach ($allq as $q) {
                        $a = $m_last[$q] ?? array('clicks'=>0,'impressions'=>0);
                        $b = $m_prev[$q] ?? array('clicks'=>0,'impressions'=>0);
                        $diff[] = array(
                            'query' => $q,
                            'clicks_delta' => (float)$a['clicks'] - (float)$b['clicks'],
                            'impr_delta' => (float)$a['impressions'] - (float)$b['impressions'],
                            'last_clicks' => (float)$a['clicks'],
                            'prev_clicks' => (float)$b['clicks'],
                        );
                    }
                    usort($diff, function($x,$y){
                        return ($y['clicks_delta'] <=> $x['clicks_delta']);
                    });
                    $diff = array_slice($diff, 0, 10);

                    ?>
                    <hr style="margin:16px 0;" />
                    <h3 style="margin:0 0 8px;"><?php echo esc_html__('Top Query Changes (Last 14d vs Prev 14d)', 'aegisseo'); ?></h3>
                    <p class="description" style="margin-top:0;">
                        <?php echo esc_html__('This is live GSC query data (cached ~10 min). It helps explain which searches moved after SEO changes.', 'aegisseo'); ?>
                    </p>
                    <table class="widefat striped">
                        <thead>
                            <tr>
                                <th><?php echo esc_html__('Query', 'aegisseo'); ?></th>
                                <th style="width:120px;"><?php echo esc_html__('Clicks Δ', 'aegisseo'); ?></th>
                                <th style="width:140px;"><?php echo esc_html__('Impressions Δ', 'aegisseo'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($diff as $drow): ?>
                            <tr>
                                <td><?php echo esc_html($drow['query']); ?></td>
                                <td><?php echo esc_html(number_format_i18n($drow['clicks_delta'], 0)); ?></td>
                                <td><?php echo esc_html(number_format_i18n($drow['impr_delta'], 0)); ?></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>

                    <?php
                    $schema_type = (string) get_post_meta($post_id, '_aegisseo_schema_type', true);
                    if ($schema_event_date !== '' && $schema_type !== '') {
                        $pos_hits = 0;
                        foreach ($diff as $drow) { if ($drow['clicks_delta'] > 0) { $pos_hits++; } }
                        if ($pos_hits > 0) {
                            ?>
                            <div style="margin-top:12px; padding:10px; border-left:4px solid #00a32a; background:#edfaef;">
                                <strong><?php echo esc_html__('Why it changed (best-effort)', 'aegisseo'); ?></strong>
                                <p style="margin:6px 0 0;">
                                    <?php
                                    echo esc_html(sprintf(
                                        'After applying %s schema, some queries gained clicks in the last 14 days vs the previous 14 days. Review the table above to confirm which terms benefited.',
                                        $schema_type
                                    ));
                                    ?>
                                    <span style="color:#666;"><?php echo esc_html__('Schema applied on', 'aegisseo'); ?> <code><?php echo esc_html($schema_event_date); ?></code></span>
                                </p>
                            </div>
                            <?php
                        }
                    }
                }
            }
            ?>
<?php endif; ?>

        </div>
    <?php endif; ?>
</div>