<?php
if (!defined('ABSPATH')) { exit; }

$aegisseo_has_pro = false;
if (function_exists('aegisseo') && isset(aegisseo()->license) && aegisseo()->license) {
    $aegisseo_has_pro = (bool) aegisseo()->license->is_pro();
}
if (!$aegisseo_has_pro && class_exists('AegisSEO\\Utils\\License')) {
    \AegisSEO\Utils\License::render_pro_banner(
        __('Upgrade to PRO', 'aegisseo'),
        __('PRO feature: SEO Ops Center, Issues & Fixex, Evidence and Migration Wizard with advanced autopilot detection, guided fixes, and bulk remediation actions are available in AegisSEO PRO.', 'aegisseo')
    );
    echo '<p class="description" style="margin-top:10px;">' . esc_html__('Activate a PRO license to unlock Issues & Fixes.', 'aegisseo') . '</p>';
    return;
}

$applied = isset($_GET['applied']) ? (int) $_GET['applied'] : 0;
$fix     = isset($_GET['fix']) ? sanitize_key($_GET['fix']) : '';
$post_id = isset($_GET['post_id']) ? (int) $_GET['post_id'] : 0;

if ($applied === 1) {
    echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Fix applied successfully.', 'aegisseo') . '</p></div>';
} elseif (isset($_GET['rolled']) && (int) $_GET['rolled'] === 1) {
    echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Rollback completed.', 'aegisseo') . '</p></div>';
} elseif (isset($_GET['error'])) {
    echo '<div class="notice notice-error"><p>' . esc_html__('Could not apply fix. Please try again.', 'aegisseo') . '</p></div>';
}

$args = array(
    'post_type'      => array('post', 'page'),
    'post_status'    => array('publish'),
    'posts_per_page' => 50,
    'orderby'        => 'modified',
    'order'          => 'DESC',
    'fields'         => 'ids',
);

$ids = get_posts($args);

$rows = array();

foreach ($ids as $pid) {
    $title_override = (string) get_post_meta($pid, '_aegisseo_title', true);
    $desc_override  = (string) get_post_meta($pid, '_aegisseo_description', true);

    $post = get_post($pid);
    if (!$post) { continue; }

    $content_raw = wp_strip_all_tags((string) $post->post_content, true);
    $content_raw = preg_replace('/\s+/', ' ', $content_raw);
    $content_raw = trim($content_raw);

    $word_count = 0;
    if ($content_raw !== '') {
        $word_count = str_word_count($content_raw);
    }

    $issues = array();

    if ($desc_override === '') {
        $issues[] = __('Missing meta description override', 'aegisseo');
    }

    if ($word_count > 0 && $word_count < 300) {
        $issues[] = sprintf(__('Thin content (%d words)', 'aegisseo'), $word_count);
    }
$schema_type = '';
if (!empty(aegisseo()->schema) && method_exists(aegisseo()->schema, 'resolve_schema_type')) {
    $schema_type = (string) aegisseo()->schema->resolve_schema_type($post->ID);
    $schema_issues = (array) aegisseo()->schema->validate_schema($post->ID, $schema_type);
    foreach ($schema_issues as $si) {
        $issues[] = $si;
    }
}

    if (empty($issues)) { continue; }

    $rows[] = array(
        'ID'     => $pid,
        'title'  => get_the_title($pid),
        'type'   => $post->post_type,
        'issues' => $issues,
        'desc_missing' => ($desc_override === ''),
        'schema_issues' => !empty($schema_issues) ? 1 : 0,
    );
}

?>
<h2><?php echo esc_html__('Issues & Fixes', 'aegisseo'); ?></h2>

<?php
if (isset($_GET['pack']) && (int) $_GET['pack'] === 1 && !empty($_GET['pack_id'])) {
    $pack_id = sanitize_text_field(wp_unslash($_GET['pack_id']));
    $pack_name = isset($_GET['pack_name']) ? sanitize_key($_GET['pack_name']) : '';
    $changed = isset($_GET['changed']) ? (int) $_GET['changed'] : 0;
    $flagged = isset($_GET['flagged']) ? (int) $_GET['flagged'] : 0;
    echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Fix Pack applied.', 'aegisseo') . ' <strong>' . esc_html($pack_name) . '</strong> — ' . esc_html(sprintf(__('Changed: %d, Flagged: %d', 'aegisseo'), $changed, $flagged)) . '</p>';
    $rollback_url = wp_nonce_url(admin_url('admin-post.php?action=aegisseo_rollback_fix_pack&pack_id=' . urlencode($pack_id)), 'aegisseo_fix_pack_rollback');
    echo '<p style="margin:6px 0 0;"><a class="button" href="' . esc_url($rollback_url) . '">' . esc_html__('Rollback this Fix Pack', 'aegisseo') . '</a></p></div>';
} elseif (isset($_GET['rolled_pack']) && (int) $_GET['rolled_pack'] === 1) {
    $rolled = isset($_GET['rolled']) ? (int) $_GET['rolled'] : 0;
    echo '<div class="notice notice-success is-dismissible"><p>' . esc_html(sprintf(__('Fix Pack rolled back (%d changes).', 'aegisseo'), $rolled)) . '</p></div>';
}
?>

<div style="margin:14px 0; padding:12px; border:1px solid #dcdcde; background:#fff; border-radius:8px;">
    <div style="display:flex; align-items:flex-start; justify-content:space-between; gap:12px; flex-wrap:wrap;">
        <div>
            <strong><?php echo esc_html__('Fix Packs (batch actions with rollback)', 'aegisseo'); ?></strong>
            <div class="description" style="margin-top:6px;">
                <?php echo esc_html__('Run a safe batch fix. Every change is logged into the Evidence Timeline so you can rollback.', 'aegisseo'); ?>
            </div>
        </div>
        <div style="display:flex; gap:8px; flex-wrap:wrap;">
            <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="margin:0;">
                <?php wp_nonce_field('aegisseo_fix_pack'); ?>
                <input type="hidden" name="action" value="aegisseo_apply_fix_pack" />
                <input type="hidden" name="pack" value="duplicate_titles" />
                <button class="button"><?php echo esc_html__('Fix duplicate titles', 'aegisseo'); ?></button>
            </form>
            <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="margin:0;">
                <?php wp_nonce_field('aegisseo_fix_pack'); ?>
                <input type="hidden" name="action" value="aegisseo_apply_fix_pack" />
                <input type="hidden" name="pack" value="missing_og_image" />
                <button class="button"><?php echo esc_html__('Fix missing OG image', 'aegisseo'); ?></button>
            </form>
            <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="margin:0;">
                <?php wp_nonce_field('aegisseo_fix_pack'); ?>
                <input type="hidden" name="action" value="aegisseo_apply_fix_pack" />
                <input type="hidden" name="pack" value="orphan_pages" />
                <button class="button"><?php echo esc_html__('Find orphan pages', 'aegisseo'); ?></button>
            </form>
        </div>
    </div>
</div>

<p class="description"><?php echo esc_html__('One screen: find issues, apply safe fixes, and track what changed. ', 'aegisseo'); ?></p>

<?php if (empty($rows)): ?>
    <div class="notice notice-info"><p><?php echo esc_html__('No issues detected in the last 50 published posts/pages using current checks.', 'aegisseo'); ?></p></div>
<?php else: ?>
    <table class="widefat fixed striped">
        <thead>
            <tr>
                <th style="width:70px;"><?php echo esc_html__('ID', 'aegisseo'); ?></th>
                <th><?php echo esc_html__('Title', 'aegisseo'); ?></th>
                <th style="width:110px;"><?php echo esc_html__('Type', 'aegisseo'); ?></th>
                <th><?php echo esc_html__('Issues', 'aegisseo'); ?></th>
                <th style="width:240px;"><?php echo esc_html__('Fix', 'aegisseo'); ?></th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($rows as $r): ?>
            <tr>
                <td><?php echo (int) $r['ID']; ?></td>
                <td>
                    <strong><?php echo esc_html($r['title']); ?></strong>
                    <div class="row-actions">
                        <span class="edit"><a href="<?php echo esc_url(get_edit_post_link($r['ID'])); ?>"><?php echo esc_html__('Edit', 'aegisseo'); ?></a></span>
                        |
                        <span class="view"><a href="<?php echo esc_url(get_permalink($r['ID'])); ?>" target="_blank" rel="noopener"><?php echo esc_html__('View', 'aegisseo'); ?></a></span>
                    </div>
                </td>
                <td><?php echo esc_html($r['type']); ?></td>
                <td>
                    <ul style="margin:0; padding-left:18px;">
                        <?php foreach ($r['issues'] as $issue): ?>
                            <li><?php echo esc_html($issue); ?></li>
                        <?php endforeach; ?>
                    </ul>
                </td>
                <td>
                    <?php if ($r['desc_missing']): ?>
                        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="display:inline-block; margin:0;">
                            <?php wp_nonce_field('aegisseo_apply_fix'); ?>
                            <input type="hidden" name="action" value="aegisseo_apply_fix" />
                            <input type="hidden" name="post_id" value="<?php echo (int) $r['ID']; ?>" />
                            <input type="hidden" name="fix_type" value="gen_meta_desc" />
                            <button type="submit" class="button button-primary"><?php echo esc_html__('Generate Meta Description', 'aegisseo'); ?></button>
                        </form>
                    <?php else: ?>
                        <span class="dashicons dashicons-yes" style="color:#46b450;"></span>
                        <?php echo esc_html__('No safe one-click fix available (yet).', 'aegisseo'); ?>
                    <?php endif; ?>

<?php

$pid = (int) $r['ID'];

$current_schema_type = (string) get_post_meta($pid, '_aegisseo_schema_type', true);
$schema_sug = array();
if (isset(aegisseo()->autopilot) && aegisseo()->autopilot) {
    $schema_sug = aegisseo()->autopilot->suggest_schema($pid);
}

if ($current_schema_type === '' && !empty($schema_sug['type'])): ?>
    <div style="margin-top:10px; padding:10px; border:1px solid #dcdcde; background:#fff;">
        <strong><?php echo esc_html__('Autopilot: Schema Suggestion', 'aegisseo'); ?></strong>
        <div style="margin-top:6px;">
            <span class="dashicons dashicons-lightbulb" style="color:#2271b1;"></span>
            <?php echo esc_html($schema_sug['type']); ?>
            <span style="color:#666;">(<?php echo esc_html__('why', 'aegisseo'); ?>)</span>
        </div>
        <?php if (!empty($schema_sug['why']) && is_array($schema_sug['why'])): ?>
            <ul style="margin:6px 0 0 18px;">
                <?php foreach ($schema_sug['why'] as $w): ?>
                    <li><?php echo esc_html($w); ?></li>
                <?php endforeach; ?>
            </ul>
        <?php endif; ?>
        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="margin-top:8px;">
            <?php wp_nonce_field('aegisseo_schema_approve'); ?>
            <input type="hidden" name="action" value="aegisseo_schema_approve" />
            <input type="hidden" name="post_id" value="<?php echo (int) $pid; ?>" />
            <input type="hidden" name="schema_type" value="<?php echo esc_attr($schema_sug['type']); ?>" />
            <button type="submit" class="button button-secondary"><?php echo esc_html__('Approve & Apply Schema', 'aegisseo'); ?></button>
        </form>
    </div>
<?php elseif ($current_schema_type !== ''): ?>
    <div style="margin-top:10px; color:#1d2327;">
        <span class="dashicons dashicons-yes" style="color:#46b450;"></span>
        <?php echo esc_html__('Schema locked:', 'aegisseo'); ?> <strong><?php echo esc_html($current_schema_type); ?></strong>
    </div>
<?php endif; ?>

<?php
global $wpdb;
$tred = $wpdb->prefix . 'aegisseo_redirects';
$pending_redirects = $wpdb->get_results($wpdb->prepare(
    "SELECT * FROM {$tred} WHERE is_suggestion=1 AND suggestion_status=%s AND source_post_id=%d ORDER BY id DESC LIMIT 5",
    'pending',
    $pid
), ARRAY_A);

if (!empty($pending_redirects)): ?>
    <div style="margin-top:10px; padding:10px; border:1px solid #dcdcde; background:#fff;">
        <strong><?php echo esc_html__('Autopilot: Redirect Suggestions', 'aegisseo'); ?></strong>
        <ul style="margin:8px 0 0 18px;">
            <?php foreach ($pending_redirects as $pr): ?>
                <li style="margin-bottom:8px;">
                    <code><?php echo esc_html($pr['source']); ?></code>
                    &rarr;
                    <code><?php echo esc_html($pr['target']); ?></code>
                    <div style="margin-top:6px;">
                        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="display:inline-block; margin:0 6px 0 0;">
                            <?php wp_nonce_field('aegisseo_redirect_approve'); ?>
                            <input type="hidden" name="action" value="aegisseo_redirect_approve" />
                            <input type="hidden" name="id" value="<?php echo (int) $pr['id']; ?>" />
                            <button type="submit" class="button button-secondary button-small"><?php echo esc_html__('Approve & Enable', 'aegisseo'); ?></button>
                        </form>
                        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="display:inline-block; margin:0;">
                            <?php wp_nonce_field('aegisseo_redirect_dismiss'); ?>
                            <input type="hidden" name="action" value="aegisseo_redirect_dismiss" />
                            <input type="hidden" name="id" value="<?php echo (int) $pr['id']; ?>" />
                            <button type="submit" class="button button-link-delete button-small"><?php echo esc_html__('Dismiss', 'aegisseo'); ?></button>
                        </form>
                    </div>
                </li>
            <?php endforeach; ?>
        </ul>
    </div>
<?php endif; ?>

<?php
$link_sugs = array();
if (isset(aegisseo()->autopilot) && aegisseo()->autopilot) {
    $max_links = 3;
if (function_exists('aegisseo') && isset(aegisseo()->options) && aegisseo()->options) {
    $max_links = (int) aegisseo()->options->get('autopilot_max_internal_links', 3);
    if ($max_links <= 0) { $max_links = 3; }
}
$link_sugs = aegisseo()->autopilot->suggest_internal_links($pid, $max_links);
}

if (!empty($link_sugs)): 
    $post_obj = get_post($pid);
    $orig = $post_obj ? (string)$post_obj->post_content : '';
    $preview = aegisseo()->autopilot->apply_internal_links($pid, $link_sugs, 3);
    $proposed = (!empty($preview['new_content'])) ? (string)$preview['new_content'] : $orig;
    ?>
    <div style="margin-top:10px; padding:10px; border:1px solid #dcdcde; background:#fff;">
        <strong><?php echo esc_html__('Autopilot: Internal Link Suggestions (max 3)', 'aegisseo'); ?></strong>
        <ul style="margin:8px 0 0 18px;">
            <?php foreach ($link_sugs as $ls): ?>
                <li>
                    <em><?php echo esc_html($ls['anchor']); ?></em>
                    &rarr;
                    <a href="<?php echo esc_url(get_edit_post_link((int)$ls['target_id'])); ?>"><?php echo esc_html($ls['title']); ?></a>
                </li>
            <?php endforeach; ?>
        </ul>

        <details style="margin-top:8px;">
            <summary><?php echo esc_html__('Preview diff (safe preview)', 'aegisseo'); ?></summary>
            <div style="margin-top:8px; background:#fff;">
                <?php
                if (function_exists('wp_text_diff')) {
                    echo wp_text_diff(wp_strip_all_tags($orig), wp_strip_all_tags($proposed), array('show_split_view' => true));
                } else {
                    echo '<pre style="white-space:pre-wrap;">' . esc_html(wp_strip_all_tags($proposed)) . '</pre>';
                }
                ?>
            </div>
        </details>

        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="margin-top:8px;">
            <?php wp_nonce_field('aegisseo_apply_links'); ?>
            <input type="hidden" name="action" value="aegisseo_apply_links" />
            <input type="hidden" name="post_id" value="<?php echo (int) $pid; ?>" />
            <button type="submit" class="button button-secondary"><?php echo esc_html__('Approve & Apply Links', 'aegisseo'); ?></button>
            <span class="description" style="margin-left:6px;"><?php echo esc_html__('Applies up to 3 internal links by inserting anchors into safe text nodes only.', 'aegisseo'); ?></span>
        </form>
    </div>
<?php endif; ?>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>


<hr style="margin:24px 0;" />
<h2><?php echo esc_html__('Recent SEO Events', 'aegisseo'); ?></h2>
<p class="description"><?php echo esc_html__('Aegis-style audit trail. Rollback restores the previous value for AegisSEO meta fields.', 'aegisseo'); ?></p>

<?php
$events = array();
if (isset(aegisseo()->events) && aegisseo()->events) {
    $events = aegisseo()->events->get_recent(30);
}

$can_rollback_keys = array(
    '_aegisseo_title',
    '_aegisseo_description',
    '_aegisseo_canonical',
    '_aegisseo_robots',
    '_aegisseo_focus_phrase',
    '_aegisseo_schema_mode',
);

$can_rollback_types = array('meta_add','meta_update','meta_delete','fix_applied');

function aegisseo_evt_short($v) {
    if (null === $v) { return '—'; }
    $v = (string) $v;
    $v = trim($v);
    if ($v === '') { return '—'; }
    if (mb_strlen($v) > 80) { return mb_substr($v, 0, 80) . '…'; }
    return $v;
}
?>

<table class="widefat striped">
    <thead>
        <tr>
            <th style="width:140px;"><?php echo esc_html__('When', 'aegisseo'); ?></th>
            <th style="width:110px;"><?php echo esc_html__('Type', 'aegisseo'); ?></th>
            <th><?php echo esc_html__('Object', 'aegisseo'); ?></th>
            <th style="width:170px;"><?php echo esc_html__('Field', 'aegisseo'); ?></th>
            <th><?php echo esc_html__('Old', 'aegisseo'); ?></th>
            <th><?php echo esc_html__('New', 'aegisseo'); ?></th>
            <th style="width:90px;"><?php echo esc_html__('User', 'aegisseo'); ?></th>
            <th style="width:110px;"><?php echo esc_html__('Action', 'aegisseo'); ?></th>
        </tr>
    </thead>
    <tbody>
    <?php if (empty($events)) : ?>
        <tr><td colspan="8"><?php echo esc_html__('No events recorded yet.', 'aegisseo'); ?></td></tr>
    <?php else : ?>
        <?php foreach ($events as $e) : ?>
            <?php
                $etype = isset($e['event_type']) ? (string) $e['event_type'] : '';
                $otype = isset($e['object_type']) ? (string) $e['object_type'] : '';
                $oid   = isset($e['object_id']) ? (int) $e['object_id'] : 0;
                $mkey  = isset($e['meta_key']) ? (string) $e['meta_key'] : '';
                $oldv  = isset($e['old_value']) ? $e['old_value'] : null;
                $newv  = isset($e['new_value']) ? $e['new_value'] : null;
                $when  = isset($e['created_at']) ? (string) $e['created_at'] : '';
                $uid   = isset($e['user_id']) ? (int) $e['user_id'] : 0;

                $obj_label = $otype . ':' . $oid;
                $obj_link = '';
                if ($otype === 'post' && $oid > 0) {
                    $ptitle = get_the_title($oid);
                    if ($ptitle) {
                        $obj_label = $ptitle . ' (#' . $oid . ')';
                        $obj_link = get_edit_post_link($oid, '');
                    }
                }

                $u = $uid ? get_userdata($uid) : null;
                $uname = ($u && !empty($u->user_login)) ? $u->user_login : '—';

                $can_rb = ($otype === 'post' && in_array($etype, $can_rollback_types, true) && in_array($mkey, $can_rollback_keys, true));
                if ($can_rb && (string)$oldv === (string)$newv) { $can_rb = false; }
            ?>
            <tr>
                <td><?php echo esc_html($when); ?></td>
                <td><code><?php echo esc_html($etype); ?></code></td>
                <td>
                    <?php if ($obj_link) : ?>
                        <a href="<?php echo esc_url($obj_link); ?>"><?php echo esc_html($obj_label); ?></a>
                    <?php else : ?>
                        <?php echo esc_html($obj_label); ?>
                    <?php endif; ?>
                </td>
                <td><code><?php echo esc_html($mkey ? $mkey : '—'); ?></code></td>
                <td><span title="<?php echo esc_attr((string)$oldv); ?>"><?php echo esc_html(aegisseo_evt_short($oldv)); ?></span></td>
                <td><span title="<?php echo esc_attr((string)$newv); ?>"><?php echo esc_html(aegisseo_evt_short($newv)); ?></span></td>
                <td><?php echo esc_html($uname); ?></td>
                <td>
                    <?php if ($can_rb) : ?>
                        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="margin:0; display:inline-block;" onsubmit="return confirm('<?php echo esc_js(__('Rollback this change?', 'aegisseo')); ?>');">
                            <?php wp_nonce_field('aegisseo_rollback_event'); ?>
                            <input type="hidden" name="action" value="aegisseo_rollback_event" />
                            <input type="hidden" name="event_id" value="<?php echo (int) $e['id']; ?>" />
                            <button type="submit" class="button button-small"><?php echo esc_html__('Rollback', 'aegisseo'); ?></button>
                        </form>
                    <?php else : ?>
                        <span style="color:#666;">—</span>
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; ?>
    <?php endif; ?>
    </tbody>
</table>

<?php
$orphans = get_posts(array(
    'post_type' => 'page',
    'post_status' => 'publish',
    'numberposts' => 50,
    'meta_key' => '_aegisseo_orphan',
    'meta_value' => '1',
    'fields' => 'ids',
));
if (!empty($orphans)):
?>
<div style="margin-top:16px; padding:12px; border:1px solid #dcdcde; background:#fff; border-radius:8px;">
    <strong><?php echo esc_html__('Orphan Pages (needs internal links)', 'aegisseo'); ?></strong>
    <p class="description" style="margin-top:6px;"><?php echo esc_html__('These pages were detected as having no inbound mentions in published content (best-effort). Add at least one internal link from a relevant hub page.', 'aegisseo'); ?></p>
    <ul style="margin:8px 0 0; padding-left:18px;">
        <?php foreach ((array)$orphans as $oid): ?>
            <li>
                <a href="<?php echo esc_url(get_edit_post_link((int)$oid)); ?>"><?php echo esc_html(get_the_title((int)$oid)); ?></a>
                <span style="color:#666;"> — <?php echo esc_html(get_permalink((int)$oid)); ?></span>
            </li>
        <?php endforeach; ?>
    </ul>
</div>
<?php endif; ?>

