<?php
if (!defined('ABSPATH')) { exit; }

if (!current_user_can('manage_options')) { return; }

$notice = array('type' => '', 'message' => '');

$license_key   = '';
$license_email = '';
$status        = array();

function aegisseo_clm_post(string $endpoint, array $body): array {
    $args = array(
        'timeout' => 20,
        'headers' => array('Content-Type' => 'application/json'),
        'body'    => wp_json_encode($body),
    );

    $resp = wp_remote_post($endpoint, $args);

    if (is_wp_error($resp)) {
        return array('success' => false, 'message' => $resp->get_error_message());
    }

    $code = (int) wp_remote_retrieve_response_code($resp);
    $raw  = (string) wp_remote_retrieve_body($resp);
    $data = json_decode($raw, true);

    if (!is_array($data)) {
        return array(
            'success' => false,
            'message' => 'Invalid response from license server.',
            'http_code' => $code,
            'raw' => $raw,
        );
    }

    if (!isset($data['success'])) {
        $data['success'] = ($code >= 200 && $code < 300);
    }

    return $data;
}

if (function_exists('aegisseo') && isset(aegisseo()->license) && aegisseo()->license) {
    if (method_exists(aegisseo()->license, 'get_key')) {
        $license_key = (string) aegisseo()->license->get_key();
    } else {
        $license_key = (string) get_option('aegisseo_license_key', '');
    }

    if (method_exists(aegisseo()->license, 'get_email')) {
        $license_email = (string) aegisseo()->license->get_email();
    } else {
        $license_email = (string) get_option('aegisseo_license_email', '');
    }

    if (method_exists(aegisseo()->license, 'get_cached_status')) {
        $status = (array) aegisseo()->license->get_cached_status();
    }
} else {
    $license_key   = (string) get_option('aegisseo_license_key', '');
    $license_email = (string) get_option('aegisseo_license_email', '');
    $status        = (array) get_option('aegisseo_license_status_cache', array());
}

if (!empty($_POST) && isset($_POST['aegisseo_license_action'])) {
    check_admin_referer('aegisseo_license_action');

    $posted_key   = isset($_POST['license_key']) ? sanitize_text_field(wp_unslash($_POST['license_key'])) : '';
    $posted_email = isset($_POST['license_email']) ? sanitize_email(wp_unslash($_POST['license_email'])) : '';

    update_option('aegisseo_license_key', $posted_key);
    update_option('aegisseo_license_email', $posted_email);

    $license_key   = $posted_key;
    $license_email = $posted_email;

	if (isset($_POST['aegisseo_activate_license'])) {

		$payload = array(
			'license_key' => $posted_key,
			'email'       => $posted_email,
			'site_url'    => home_url(),
			'version'     => defined('AEGISSEO_VERSION') ? (string) AEGISSEO_VERSION : '',
		);

		$res = aegisseo_clm_post(AEGISSEO_CLM_ACTIVATE_ENDPOINT, $payload);

		update_option('aegisseo_license_status_cache', $res);
		if (function_exists('aegisseo') && isset(aegisseo()->license) && aegisseo()->license) {
			aegisseo()->license->check_now(defined('AEGISSEO_VERSION') ? (string) AEGISSEO_VERSION : '');
		}

		$notice['type']    = !empty($res['success']) ? 'success' : 'error';
		$notice['message'] = (string) ($res['message'] ?? 'Activation completed.');
	}

	if (isset($_POST['aegisseo_deactivate_license'])) {

		$payload = array(
			'license_key' => $posted_key,
			'email'       => $posted_email,
			'site_url'    => home_url(),
			'version'     => defined('AEGISSEO_VERSION') ? (string) AEGISSEO_VERSION : '',
		);

		$res = aegisseo_clm_post(AEGISSEO_CLM_DEACTIVATE_ENDPOINT, $payload);

		update_option('aegisseo_license_status_cache', $res);
		if (function_exists('aegisseo') && isset(aegisseo()->license) && aegisseo()->license) {
			aegisseo()->license->check_now(defined('AEGISSEO_VERSION') ? (string) AEGISSEO_VERSION : '');
		}

		$notice['type']    = !empty($res['success']) ? 'success' : 'error';
		$notice['message'] = (string) ($res['message'] ?? 'Deactivation completed.');
	}

	if (isset($_POST['aegisseo_check_license'])) {

		$payload = array(
			'license_key' => $posted_key,
			'email'       => $posted_email,
			'site_url'    => home_url(),
			'version'     => defined('AEGISSEO_VERSION') ? (string) AEGISSEO_VERSION : '',
		);

		$res = aegisseo_clm_post(AEGISSEO_CLM_STATUS_ENDPOINT, $payload);

		update_option('aegisseo_license_status_cache', $res);
		if (function_exists('aegisseo') && isset(aegisseo()->license) && aegisseo()->license) {
			aegisseo()->license->check_now(defined('AEGISSEO_VERSION') ? (string) AEGISSEO_VERSION : '');
		}

		$notice['type']    = !empty($res['success']) ? 'success' : 'error';
		$notice['message'] = (string) ($res['message'] ?? 'Status updated.');
	}

    if (function_exists('aegisseo') && isset(aegisseo()->license) && aegisseo()->license && method_exists(aegisseo()->license, 'get_cached_status')) {
        $status = (array) aegisseo()->license->get_cached_status();
    } else {
        $status = (array) get_option('aegisseo_license_status_cache', $status);
    }
}

$is_pro = false;
if (function_exists('aegisseo') && isset(aegisseo()->license) && aegisseo()->license && method_exists(aegisseo()->license, 'is_pro')) {
    $is_pro = (bool) aegisseo()->license->is_pro();
} elseif (!empty($status['is_pro'])) {
    $is_pro = true;
}

?>
<div class="aegisseo-card">
    <h2><?php echo esc_html__('License', 'aegisseo'); ?></h2>

    <?php if (!empty($notice['message'])): ?>
        <div class="notice notice-<?php echo esc_attr($notice['type']); ?> is-dismissible">
            <p><?php echo esc_html($notice['message']); ?></p>
        </div>
    <?php endif; ?>

    <div style="margin:10px 0 14px;color:#50575e;font-size:13px;">
        <?php echo esc_html__('Enter your license key and the email used at checkout. Activate to unlock PRO features and updates.', 'aegisseo'); ?>
    </div>

    <form method="post">
        <?php wp_nonce_field('aegisseo_license_action'); ?>
        <input type="hidden" name="aegisseo_license_action" value="1" />

        <table class="form-table" role="presentation">
            <tbody>
                <tr>
                    <th scope="row">
                        <label for="aegisseo_license_key"><?php echo esc_html__('License Key', 'aegisseo'); ?></label>
                    </th>
                    <td>
                        <input type="text"
                               id="aegisseo_license_key"
                               name="license_key"
                               class="regular-text"
                               style="width:420px;"
                               value="<?php echo esc_attr($license_key); ?>"
                               autocomplete="off" />
                    </td>
                </tr>

                <tr>
                    <th scope="row">
                        <label for="aegisseo_license_email"><?php echo esc_html__('License Email', 'aegisseo'); ?></label>
                    </th>
                    <td>
                        <input type="email"
                               id="aegisseo_license_email"
                               name="license_email"
                               class="regular-text"
                               style="width:420px;"
                               value="<?php echo esc_attr($license_email); ?>"
                               autocomplete="email" />
                    </td>
                </tr>
            </tbody>
        </table>

        <p>
            <button type="submit" class="button button-primary" name="aegisseo_activate_license" value="1">
                <?php echo esc_html__('Activate License', 'aegisseo'); ?>
            </button>

            <?php
            $confirm = esc_js(__('Deactivate this license on this site?', 'aegisseo'));
            ?>
            <button type="submit"
                    class="button"
                    name="aegisseo_deactivate_license"
                    value="1"
                    onclick="return confirm('<?php echo $confirm; ?>');">
                <?php echo esc_html__('Deactivate', 'aegisseo'); ?>
            </button>

            <button type="submit" class="button button-secondary" name="aegisseo_check_license" value="1">
                <?php echo esc_html__('Check Status', 'aegisseo'); ?>
            </button>
        </p>
    </form>
<hr />
<h4>
    <?php echo esc_html__( 'Create an account on', 'aegisseo' ); ?>
    <a href="<?php echo esc_url( 'https://aegisify.com/register/' ); ?>" target="_blank" rel="noopener noreferrer">
        <?php echo esc_html( 'https://aegisify.com/register/' ); ?>
    </a>
    <?php echo esc_html__( 'and help support Aegisify by buying a license today!', 'aegisseo' ); ?>
</h4>
<hr />

    <h3><?php echo esc_html__('Status', 'aegisseo'); ?></h3>
    <table class="widefat striped">
        <tbody>
            <tr>
                <th><?php echo esc_html__('Tier', 'aegisseo'); ?></th>
                <td><?php echo esc_html($is_pro ? 'PRO' : 'FREE'); ?></td>
            </tr>
            <tr>
                <th><?php echo esc_html__('License Status', 'aegisseo'); ?></th>
                <td><?php echo esc_html((string)($status['status'] ?? '—')); ?></td>
            </tr>
            <tr>
                <th><?php echo esc_html__('Plan', 'aegisseo'); ?></th>
                <td><?php echo esc_html((string)($status['plan'] ?? '—')); ?></td>
            </tr>
            <tr>
                <th><?php echo esc_html__('Expires', 'aegisseo'); ?></th>
                <td><?php echo esc_html((string)($status['expires'] ?? '—')); ?></td>
            </tr>
            <tr>
                <th><?php echo esc_html__('Last Checked', 'aegisseo'); ?></th>
                <td>
                    <?php
                    $checked_at = isset($status['checked_at']) ? (int) $status['checked_at'] : 0;
                    echo esc_html($checked_at ? date_i18n(get_option('date_format') . ' ' . get_option('time_format'), $checked_at) : '—');
                    ?>
                </td>
            </tr>
        </tbody>
    </table>
</div>

