<?php
if (!defined('ABSPATH')) { exit; }
if (!current_user_can('edit_posts')) { echo '<p>' . esc_html__('Forbidden', 'aegisseo') . '</p>'; return; }
$post_id = isset($_GET['post_id']) ? (int) $_GET['post_id'] : 0;
echo '<h2>' . esc_html__('Internal Linking Assistant (v1)', 'aegisseo') . '</h2>';
echo '<p class="description">' . esc_html__('Suggestions are based on the post title + categories/tags keywords.', 'aegisseo') . '</p>';
$posts = get_posts(array('post_type'=>'post','numberposts'=>50,'post_status'=>array('publish','draft')));
echo '<form method="get" action="">';
echo '<input type="hidden" name="page" value="aegisseo" />';
echo '<input type="hidden" name="tab" value="links" />';
echo '<select name="post_id">';
echo '<option value="0">' . esc_html__('-- Select a post --', 'aegisseo') . '</option>';
foreach ($posts as $p) {
    echo '<option value="' . esc_attr($p->ID) . '" ' . selected($post_id, $p->ID, false) . '>' . esc_html(get_the_title($p->ID)) . '</option>';
}
echo '</select> ';
submit_button(__('Suggest', 'aegisseo'), 'secondary', '', false);
echo '</form>';
if ($post_id) {
    $suggestions = aegisseo()->linking->suggest_links($post_id, 10);
    if (empty($suggestions)) echo '<p>' . esc_html__('No suggestions found yet.', 'aegisseo') . '</p>';
    else {
        echo '<ul>';
        foreach ($suggestions as $s) echo '<li><a href="' . esc_url($s['url']) . '" target="_blank" rel="noopener">' . esc_html($s['title']) . '</a></li>';
        echo '</ul>';
    }
}
