<?php
if (!defined('ABSPATH')) { exit; }
if (!current_user_can('manage_options')) {
    echo '<p>' . esc_html__('Forbidden', 'aegisseo') . '</p>';
    return;
}
$opts = function_exists('aegisseo') ? aegisseo()->options->get_all() : array();

echo '<h2>' . esc_html__('Local SEO', 'aegisseo') . '</h2>';
echo '<p class="description">' . esc_html__('Adds LocalBusiness schema to your homepage and provides a Locations post type.', 'aegisseo') . '</p>';
?>
<form method="post" action="options.php">
    <?php settings_fields('aegisseo_settings_group'); ?>
    <table class="form-table" role="presentation">
        <tr>
            <th scope="row"><?php echo esc_html__('Enable Local SEO', 'aegisseo'); ?></th>
            <td><label><input type="checkbox" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[local_enabled]" value="1" <?php checked(1, (int)($opts['local_enabled'] ?? 0)); ?> /> <?php echo esc_html__('Enabled', 'aegisseo'); ?></label></td>
        </tr>
        <tr><th><?php echo esc_html__('Business Type', 'aegisseo'); ?></th><td><input type="text" class="regular-text" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[local_business_type]" value="<?php echo esc_attr($opts['local_business_type'] ?? 'LocalBusiness'); ?>" /></td></tr>
        <tr><th><?php echo esc_html__('Business Name', 'aegisseo'); ?></th><td><input type="text" class="regular-text" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[local_name]" value="<?php echo esc_attr($opts['local_name'] ?? ''); ?>" /></td></tr>
        <tr><th><?php echo esc_html__('Phone', 'aegisseo'); ?></th><td><input type="text" class="regular-text" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[local_phone]" value="<?php echo esc_attr($opts['local_phone'] ?? ''); ?>" /></td></tr>
        <tr><th><?php echo esc_html__('Email', 'aegisseo'); ?></th><td><input type="text" class="regular-text" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[local_email]" value="<?php echo esc_attr($opts['local_email'] ?? ''); ?>" /></td></tr>

        <tr><th colspan="2"><h3><?php echo esc_html__('Address', 'aegisseo'); ?></h3></th></tr>
        <tr><th><?php echo esc_html__('Street', 'aegisseo'); ?></th><td><input type="text" class="regular-text" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[local_street]" value="<?php echo esc_attr($opts['local_street'] ?? ''); ?>" /></td></tr>
        <tr><th><?php echo esc_html__('City', 'aegisseo'); ?></th><td><input type="text" class="regular-text" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[local_city]" value="<?php echo esc_attr($opts['local_city'] ?? ''); ?>" /></td></tr>
        <tr><th><?php echo esc_html__('State/Region', 'aegisseo'); ?></th><td><input type="text" class="regular-text" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[local_state]" value="<?php echo esc_attr($opts['local_state'] ?? ''); ?>" /></td></tr>
        <tr><th><?php echo esc_html__('ZIP', 'aegisseo'); ?></th><td><input type="text" class="regular-text" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[local_zip]" value="<?php echo esc_attr($opts['local_zip'] ?? ''); ?>" /></td></tr>
        <tr><th><?php echo esc_html__('Country', 'aegisseo'); ?></th><td><input type="text" class="regular-text" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[local_country]" value="<?php echo esc_attr($opts['local_country'] ?? ''); ?>" /></td></tr>
        <tr><th><?php echo esc_html__('Latitude', 'aegisseo'); ?></th><td><input type="text" class="regular-text" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[local_lat]" value="<?php echo esc_attr($opts['local_lat'] ?? ''); ?>" /></td></tr>
        <tr><th><?php echo esc_html__('Longitude', 'aegisseo'); ?></th><td><input type="text" class="regular-text" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[local_lng]" value="<?php echo esc_attr($opts['local_lng'] ?? ''); ?>" /></td></tr>
    </table>
    <?php submit_button(__('Save Local SEO Settings', 'aegisseo')); ?>
</form>
<p class="description"><?php echo esc_html__('Locations: use the "Locations" post type (created by AegisSEO) to build location pages.', 'aegisseo'); ?></p>
