<?php
if (!defined('ABSPATH')) { exit; }

$aegisseo_has_pro = false;
if (function_exists('aegisseo') && isset(aegisseo()->license) && aegisseo()->license) {
    $aegisseo_has_pro = (bool) aegisseo()->license->is_pro();
}
if (!$aegisseo_has_pro && class_exists('AegisSEO\\Utils\\License')) {
    \AegisSEO\Utils\License::render_pro_banner(
        __('Upgrade to PRO', 'aegisseo'),
        __('PRO feature: SEO Ops Center, Issues & Fixex, Evidence and Migration Wizard with advanced autopilot detection, guided fixes, and bulk remediation actions are available in AegisSEO PRO.', 'aegisseo')
    );
    echo '<p class="description" style="margin-top:10px;">' . esc_html__('Activate a PRO license to unlock Issues & Fixes.', 'aegisseo') . '</p>';
    return;
}

$ops = null;
if (function_exists('aegisseo') && isset(aegisseo()->admin)) {

    $ops = new \AegisSEO\Admin\Admin_Ops(aegisseo()->options);
} else {

    $ops = new \AegisSEO\Admin\Admin_Ops(new \AegisSEO\Utils\Options());
}

$data = $ops->get_dashboard_payload();

function aegisseo_num($n) {
    if ($n === null || $n === '') return '0';
    if (is_numeric($n)) {
        if ((float)$n >= 1000) return number_format_i18n((float)$n, 0);
        return number_format_i18n((float)$n, 2);
    }
    return esc_html((string)$n);
}

$overview28 = $data['overview']['28'] ?? array('clicks'=>0,'impressions'=>0,'ctr'=>0,'position'=>0);
?>

<div id="aegisseo-ops-center">
    <h2 style="margin-top:0;">SEO Ops Center</h2>

    <?php if (!empty($data['notes'])): ?>
        <div class="notice notice-info"><p><?php echo esc_html(implode(' ', (array)$data['notes'])); ?></p></div>
    <?php endif; ?>

    <div class="aegisseo-grid" style="display:grid; grid-template-columns:repeat(4,1fr); gap:12px; margin:12px 0;">
        <div class="aegisseo-card" style="padding:14px;">
            <div style="font-size:12px; opacity:.8;">Clicks (28d)</div>
            <div style="font-size:22px; font-weight:700; margin-top:6px;"><?php echo esc_html(aegisseo_num($overview28['clicks'] ?? 0)); ?></div>
        </div>
        <div class="aegisseo-card" style="padding:14px;">
            <div style="font-size:12px; opacity:.8;">Impressions (28d)</div>
            <div style="font-size:22px; font-weight:700; margin-top:6px;"><?php echo esc_html(aegisseo_num($overview28['impressions'] ?? 0)); ?></div>
        </div>
        <div class="aegisseo-card" style="padding:14px;">
            <div style="font-size:12px; opacity:.8;">CTR (28d)</div>
            <div style="font-size:22px; font-weight:700; margin-top:6px;"><?php echo esc_html(aegisseo_num($overview28['ctr'] ?? 0)); ?>%</div>
        </div>
        <div class="aegisseo-card" style="padding:14px;">
            <div style="font-size:12px; opacity:.8;">Avg Position (28d)</div>
            <div style="font-size:22px; font-weight:700; margin-top:6px;"><?php echo esc_html(aegisseo_num($overview28['position'] ?? 0)); ?></div>
        </div>
    </div>

    <div class="aegisseo-card" style="padding:14px; margin:12px 0;">
        <div style="display:flex; align-items:center; justify-content:space-between; gap:12px;">
            <h3 style="margin:0;">Performance (GSC)</h3>
            <div>
                <label for="aegisseo_ops_window" style="margin-right:6px; font-weight:600;">Window</label>
                <select id="aegisseo_ops_window">
                    <option value="7">Last 7d vs prev 7d</option>
                    <option value="28" selected>Last 28d vs prev 28d</option>
                    <option value="90">Last 90d vs prev 90d</option>
                </select>
            </div>
        </div>
        <p style="margin:8px 0 0; opacity:.8;">Winners and losers are ranked by change in clicks for the selected window.</p>

        <div style="margin-top:12px;">
            <canvas id="aegisseo_ops_chart" height="90"></canvas>
        </div>

        <div style="display:grid; grid-template-columns:1fr 1fr; gap:12px; margin-top:12px;">
            <div>
                <h4 style="margin:0 0 8px;">Top Winners</h4>
                <table class="widefat striped" id="aegisseo_ops_winners">
                    <thead><tr><th>Page</th><th>Δ Clicks</th><th>Clicks</th><th>Impr</th></tr></thead>
                    <tbody></tbody>
                </table>
            </div>
            <div>
                <h4 style="margin:0 0 8px;">Top Losers</h4>
                <table class="widefat striped" id="aegisseo_ops_losers">
                    <thead><tr><th>Page</th><th>Δ Clicks</th><th>Clicks</th><th>Impr</th></tr></thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>

    <div style="display:grid; grid-template-columns:1.2fr .8fr; gap:12px;">
        <div class="aegisseo-card" style="padding:14px;">
            <h3 style="margin-top:0;">Query Clusters & Content Gaps</h3>
            <?php if (empty($data['gsc_connected'])): ?>
                <div class="notice notice-warning"><p>Connect Search Console in the <strong>Search Console</strong> tab to unlock query clusters and content gaps.</p></div>
            <?php else: ?>
                <div style="display:grid; grid-template-columns:1fr 1fr; gap:12px;">
                    <div>
                        <h4 style="margin:0 0 8px;">Top Query Clusters (28d)</h4>
                        <table class="widefat striped" id="aegisseo_ops_clusters">
                            <thead><tr><th>Cluster</th><th>Impr</th><th>CTR</th></tr></thead>
                            <tbody>
                            <?php foreach ((array)($data['clusters'] ?? array()) as $c): ?>
                                <tr>
                                    <td><strong><?php echo esc_html($c['topic'] ?? ''); ?></strong><br><span style="opacity:.75; font-size:12px;"><?php echo esc_html(implode(', ', (array)($c['queries'] ?? array()))); ?></span></td>
                                    <td><?php echo esc_html(aegisseo_num($c['impressions'] ?? 0)); ?></td>
                                    <td><?php echo esc_html(aegisseo_num($c['ctr'] ?? 0)); ?>%</td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <div>
                        <h4 style="margin:0 0 8px;">Content Gaps (high impr, low CTR)</h4>
                        <table class="widefat striped" id="aegisseo_ops_gaps">
                            <thead><tr><th>Query</th><th>Impr</th><th>CTR</th><th>Hint</th></tr></thead>
                            <tbody>
                            <?php foreach ((array)($data['content_gaps'] ?? array()) as $g): ?>
                                <tr>
                                    <td><?php echo esc_html($g['query'] ?? ''); ?></td>
                                    <td><?php echo esc_html(aegisseo_num($g['impressions'] ?? 0)); ?></td>
                                    <td><?php echo esc_html(aegisseo_num($g['ctr'] ?? 0)); ?>%</td>
                                    <td><?php echo esc_html($g['hint'] ?? ''); ?></td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                        <p style="margin:8px 0 0; opacity:.8;">Action: create/expand a page that answers the query, and improve title/meta to raise CTR.</p>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <div class="aegisseo-card" style="padding:14px;">
            <h3 style="margin-top:0;">Core Web Vitals Guidance</h3>
            <?php if (empty($data['cwv_warnings'])): ?>
                <div class="notice notice-success"><p>No CWV guidance items detected from WordPress signals.</p></div>
            <?php else: ?>
                <?php foreach ((array)$data['cwv_warnings'] as $w): ?>
                    <?php
                        $cls = 'notice-info';
                        if (($w['level'] ?? '') === 'warning') $cls = 'notice-warning';
                        if (($w['level'] ?? '') === 'error') $cls = 'notice-error';
                    ?>
                    <div class="notice <?php echo esc_attr($cls); ?>" style="margin:10px 0 0;">
                        <p><strong><?php echo esc_html($w['title'] ?? ''); ?></strong><br><?php echo esc_html($w['detail'] ?? ''); ?></p>
                    </div>
                <?php endforeach; ?>
                <p style="margin:10px 0 0; opacity:.8;">AegisSEO does not run external speed tests. Use Search Console CWV report (or Site Kit) to validate improvements.</p>
            <?php endif; ?>
        </div>
    </div>

    <script>
        window.AegisSEOOpsData = <?php echo wp_json_encode($data); ?>;
    </script>
</div>
