<?php
if (!defined('ABSPATH')) { exit; }
if (!current_user_can('edit_posts')) { echo '<p>' . esc_html__('Forbidden', 'aegisseo') . '</p>'; return; }
$post_id = isset($_GET['post_id']) ? (int) $_GET['post_id'] : 0;
echo '<h2>' . esc_html__('Aegis Score', 'aegisseo') . '</h2>';
echo '<p class="description">' . esc_html__('Pick a post to see the on-page checklist score.', 'aegisseo') . '</p>';
$posts = get_posts(array('post_type'=>'post','numberposts'=>50,'post_status'=>array('publish','draft')));
echo '<form method="get" action="">';
echo '<input type="hidden" name="page" value="aegisseo" />';
echo '<input type="hidden" name="tab" value="score" />';
echo '<select name="post_id">';
echo '<option value="0">' . esc_html__('-- Select a post --', 'aegisseo') . '</option>';
foreach ($posts as $p) {
    echo '<option value="' . esc_attr($p->ID) . '" ' . selected($post_id, $p->ID, false) . '>' . esc_html(get_the_title($p->ID)) . '</option>';
}
echo '</select> ';
submit_button(__('Analyze', 'aegisseo'), 'secondary', '', false);
echo '</form>';
if ($post_id) {
    $focus = get_post_meta($post_id, '_aegisseo_focus_phrase', true);
    $res = aegisseo()->score->analyze_post($post_id, (string)$focus);
    echo '<h3>' . esc_html__('Score', 'aegisseo') . ': ' . esc_html((int)$res['score']) . '/100</h3>';
    echo '<table class="widefat striped"><thead><tr><th>' . esc_html__('Check','aegisseo') . '</th><th>' . esc_html__('Status','aegisseo') . '</th><th>' . esc_html__('Details','aegisseo') . '</th></tr></thead><tbody>';
    foreach ($res['checks'] as $c) {
        $ok = !empty($c['ok']);
        echo '<tr><td>' . esc_html($c['label']) . '</td><td>' . ($ok ? '✅' : '⚠️') . '</td><td>' . esc_html($c['detail'] ?? '') . '</td></tr>';
    }
    echo '</tbody></table>';
}
