<?php
if (!defined('ABSPATH')) { exit; }

$tab = isset($_GET['tab']) ? sanitize_key($_GET['tab']) : 'global';
$allowed = array('setup','ops','global','social','schema','sitemap','issues','score','links','search','evidence','local','roles','tools','monitor','redirects','advanced','license','bulk','migration');
if (!in_array($tab, $allowed, true)) { $tab = 'global'; }

function aegisseo_tab_url($t) {
    return admin_url('admin.php?page=aegisseo&tab=' . urlencode($t));
}

$tabs = array(
    'setup'   => __('Setup Wizard', 'aegisseo'),
    'migration' => __('Migration Wizard', 'aegisseo'),
    'ops'     => __('SEO Ops Center', 'aegisseo'),
    'global'  => __('Global SEO', 'aegisseo'),
    'social'  => __('Social', 'aegisseo'),
    'schema'  => __('Schema', 'aegisseo'),
    'sitemap' => __('Sitemap', 'aegisseo'),
    'issues'  => __('Issues & Fixes', 'aegisseo'),
    'score'   => __('Aegis Score', 'aegisseo'),
    'links'   => __('Linking Assistant', 'aegisseo'),
    'search'  => __('Search Console', 'aegisseo'),
    'evidence'=> __('Evidence', 'aegisseo'),
    'local'   => __('Local SEO', 'aegisseo'),
    'roles'   => __('Role Manager', 'aegisseo'),
    'tools'   => __('Tools', 'aegisseo'),
    'license' => __('License', 'aegisseo'),
);


$tab_summaries = array(
    'setup'    => __('The Setup Wizard guides you through the essential first-time configuration of AegisSEO, including site identity, schema foundation, logos, and social profiles. By completing this wizard, AegisSEO automatically establishes a correct baseline for titles, structured data, and brand signals without requiring advanced SEO knowledge. This ensures your site starts with clean, consistent, and search-engine-friendly defaults, reducing setup errors and saving time.', 'aegisseo'),
    'migration' => __('The Migration Wizard helps you import SEO titles, meta descriptions, canonical URLs, robots settings, and social metadata from popular SEO plugins so you can switch to AegisSEO without losing your existing work. Run it in batches and it will only fill fields that are currently empty, making it safe to re-run.', 'aegisseo'),
    'ops'      => __('The SEO Ops Center is your command hub for monitoring and acting on SEO opportunities across your site. It centralizes issues, fixes, automation suggestions, and evidence into a single operational view so you can move from insight to action quickly. Instead of managing SEO page-by-page, this tab helps you prioritize impact, apply fixes efficiently, and track improvements with confidence.', 'aegisseo'),
    'global'   => __('Global SEO controls your site-wide SEO behavior, including title templates, meta description defaults, separators, and indexing rules. You use this tab to define how your site appears in search results consistently across all pages and post types. The benefit is uniform branding, predictable metadata output, and reduced risk of SEO inconsistencies as your site grows.', 'aegisseo'),
    'social'   => __('The Social tab configures how your site appears when shared on social platforms like Facebook, X (Twitter), and others. It allows you to define Open Graph and Twitter Card settings, default images, and social profile associations. This ensures your content looks professional and engaging when shared, improving click-through rates and brand trust on social media.', 'aegisseo'),
    'schema'   => __('The Schema tab manages structured data that helps search engines understand your content more accurately. You can control schema behavior globally and allow AegisSEO to intelligently apply schema types such as Article, FAQ, HowTo, or Organization where appropriate. The benefit is enhanced eligibility for rich results and clearer semantic signals without manually writing JSON-LD.', 'aegisseo'),
    'sitemap'  => __('The Sitemap tab controls XML sitemap generation and submission. You can choose which post types and taxonomies are included and allow AegisSEO to automatically notify search engines when content changes. This improves crawl efficiency, ensures new or updated pages are discovered faster, and reduces the risk of orphaned content.', 'aegisseo'),
    'issues'   => __('The Issues & Fixes tab proactively identifies SEO problems such as missing metadata, thin content, redirect gaps, and optimization opportunities. Each issue includes a clear explanation, impact description, and—when available—a one-click fix with guardrails. This tab turns SEO into an actionable workflow, helping you fix problems faster while understanding why each fix matters.', 'aegisseo'),
    'score'    => __('Aegis Score evaluates individual pages using practical, real-world SEO signals such as title quality, content depth, internal linking, and focus phrase usage. It provides a clear score and actionable feedback rather than abstract SEO grades. The benefit is fast clarity on page quality and a reliable way to improve content without chasing vanity metrics.', 'aegisseo'),
    'links'    => __('The Linking Assistant analyzes your content and suggests relevant internal links based on context and keyword relevance. You can preview suggestions, apply them safely with built-in guardrails, and limit how many links are added per page. This improves site structure, distributes link equity, and strengthens topical authority without risking over-optimization.', 'aegisseo'),
    'search'   => __('The Search Console tab connects AegisSEO directly to Google Search Console, allowing you to view performance metrics inside WordPress. You can see impressions, clicks, CTR, and position without switching tools. This integration keeps SEO decision-making close to your content and reduces reliance on external dashboards.', 'aegisseo'),
    'evidence' => __('The Evidence tab proves whether your SEO changes actually worked. It combines SEO events (such as title changes or schema updates) with Search Console data to show before-and-after performance, annotated timelines, and query-level improvements. This turns SEO from guesswork into evidence-based optimization, helping you understand what changed, why it changed, and what to do next.', 'aegisseo'),
    'local'    => __('Local SEO manages location-based optimization for businesses serving specific areas. It allows you to configure LocalBusiness schema, locations, and address data so search engines clearly understand your physical presence. This improves local visibility, map eligibility, and trust for geographically focused searches.', 'aegisseo'),
    'roles'    => __('The Role Manager lets you control which WordPress user roles can access AegisSEO features. This ensures sensitive SEO settings and automation tools are only available to authorized users. The benefit is operational safety, accountability, and better collaboration across teams.', 'aegisseo'),
    'tools'    => __('The Tools tab provides advanced utilities such as database cleanup, export/import, maintenance actions, and diagnostic helpers. These tools support long-term SEO hygiene and troubleshooting without requiring external plugins or manual database work. It’s designed for administrators who want control without complexity.', 'aegisseo'),
    'license'  => __('The License tab manages your AegisSEO licensing and feature access. You can activate or verify your license, view plan status, and unlock PRO features such as advanced automation, evidence reporting, and bulk actions. This tab ensures your installation stays compliant, up-to-date, and fully enabled based on your subscription.', 'aegisseo'),
);
?>
<div class="wrap aegisseo-wrap">
    <div class="aegisseo-header-row">
        <h1>AegisSEO</h1>
		<?php echo esc_html__('AegisSEO is a comprehensive, evidence-driven SEO platform built specifically for WordPress to help site owners improve visibility, rankings, and search performance with clarity and confidence. It centralizes essential SEO functions titles and meta management, structured data (schema), sitemaps, social metadata, internal linking guidance, local SEO, and search console insights into a single, clean interface designed to reduce guesswork and configuration errors. By combining smart defaults, automation, and actionable insights, AegisSEO helps you establish a strong SEO foundation quickly, continuously identify opportunities and issues, and apply fixes that actually move the needle. Its evidence-based approach connects SEO changes to real outcomes, making it easier to understand what’s working and why. Whether you’re launching a new site or optimizing an established one, AegisSEO empowers you to work smarter not harder by prioritizing impact, maintaining consistency at scale, and turning SEO from a confusing checklist into a strategic advantage for your WordPress site.', 'aegisseo'); ?>
        <div class="aegisseo-header-cta">
            <a class="aegisseo-cta-link" href="https://aegisify.com" target="_blank" rel="noopener noreferrer">
                <img class="aegisseo-cta-logo" src="<?php echo esc_url( AEGISSEO_URL . 'assets/images/logo_shield.png' ); ?>" alt="AegisShield" />
                <span class="aegisseo-cta-text"><?php echo esc_html__( 'Download AegisShield', 'aegisseo' ); ?></span>
            </a>
        </div>
    </div>

    <h2 class="nav-tab-wrapper">
        <?php foreach ($tabs as $key => $label): ?>
            <a href="<?php echo esc_url(aegisseo_tab_url($key)); ?>"
               class="nav-tab <?php echo ($tab === $key) ? 'nav-tab-active' : ''; ?>">
                <?php echo esc_html($label); ?>
            </a>
        <?php endforeach; ?>
    </h2>

    <div class="aegisseo-card">
        <?php
        if (isset($tab_summaries[$tab]) && !empty($tab_summaries[$tab])) {
            echo '<p class="aegisseo-tab-summary">' . esc_html($tab_summaries[$tab]) . '</p>';
        }

        switch ($tab) {
            case 'ops':
                $file = AEGISSEO_DIR . 'views/admin/ops-center-page.php';
                if (file_exists($file)) { require $file; } else { echo '<div class="notice notice-error"><p>' . esc_html__('Missing view: views/admin/ops-center-page.php', 'aegisseo') . '</p></div>'; }
                break;
            case 'issues':
                $file = AEGISSEO_DIR . 'views/admin/issues-page.php';
                if (file_exists($file)) { require $file; } else { echo '<div class="notice notice-error"><p>' . esc_html__('Missing view: views/admin/issues-page.php', 'aegisseo') . '</p></div>'; }
                break;

            case 'setup':
                require AEGISSEO_DIR . 'views/admin/wizard-page.php';
                break;

            case 'score':
                require AEGISSEO_DIR . 'views/admin/score-page.php';
                break;

            case 'links':
                require AEGISSEO_DIR . 'views/admin/links-page.php';
                break;

            case 'evidence':
                require AEGISSEO_DIR . 'views/admin/evidence-page.php';
                break;

                        case 'bulk':
                require AEGISSEO_DIR . 'views/admin/bulk-page.php';
                break;

            case 'migration':
                require AEGISSEO_DIR . 'views/admin/migration-page.php';
                break;

			case 'license':
                require AEGISSEO_DIR . 'views/admin/license-page.php';
                break;

            case 'search':
                $file = AEGISSEO_DIR . 'views/admin/search-console-page.php';
                if (file_exists($file)) { require $file; } else { echo '<div class="notice notice-error"><p>' . esc_html__('Missing admin view: views/admin/search-console-page.php', 'aegisseo') . '</p></div>'; }
                break;

            case 'local':
                $file = AEGISSEO_DIR . 'views/admin/local-seo-page.php';
                if (file_exists($file)) { require $file; } else { echo '<div class="notice notice-error"><p>' . esc_html__('Missing admin view: views/admin/local-seo-page.php', 'aegisseo') . '</p></div>'; }
                break;

            case 'roles':
                $file = AEGISSEO_DIR . 'views/admin/roles-page.php';
                if (file_exists($file)) { require $file; } else { echo '<div class="notice notice-error"><p>' . esc_html__('Missing admin view: views/admin/roles-page.php', 'aegisseo') . '</p></div>'; }
                break;

            case 'monitor':
                $file = AEGISSEO_DIR . 'views/admin/tab-404.php';
                if (file_exists($file)) {
                    require $file;
                } else {
                    echo '<div class="notice notice-error"><p>' . esc_html__('Missing admin view: views/admin/tab-404.php', 'aegisseo') . '</p></div>';
                }
                break;
            case 'redirects':
                $file = AEGISSEO_DIR . 'views/admin/tab-redirects.php';
                if (file_exists($file)) {
                    require $file;
                } else {
                    echo '<div class="notice notice-error"><p>' . esc_html__('Missing admin view: views/admin/tab-redirects.php', 'aegisseo') . '</p></div>';
                }
                break;
            case 'advanced':
                $file = AEGISSEO_DIR . 'views/admin/tab-advanced.php';
                if (file_exists($file)) {
                    require $file;
                } else {
                    echo '<div class="notice notice-error"><p>' . esc_html__('Missing admin view: views/admin/tab-advanced.php', 'aegisseo') . '</p></div>';
                }
                break;

			case 'sitemap':
				?>
				<style>
					.aegisseo-sitemap-grid{display:flex;gap:16px;align-items:flex-start;box-sizing:border-box;padding-right:20px}
					.aegisseo-sitemap-grid > form{
						display:flex;
						gap:16px;
						align-items:flex-start;
						width:100%;
					}
					.aegisseo-sitemap-left{flex:0 0 30%;max-width:30%}
					.aegisseo-sitemap-right{flex:0 0 70%;max-width:70%}
					@media (max-width: 1100px){
						.aegisseo-sitemap-grid{flex-direction:column}
						.aegisseo-sitemap-left,.aegisseo-sitemap-right{flex:0 0 auto;max-width:100%}
					}
					.aegisseo-sitemap-panel{background:#fff;border:1px solid #dcdcde;border-radius:10px;padding:14px}
					.aegisseo-sitemap-panel h2{margin:0 0 10px 0}
					.aegisseo-sitemap-mini{font-size:12px;color:#646970}
					.aegisseo-sitemap-table{width:100%;border-collapse:collapse}
					.aegisseo-sitemap-table th,.aegisseo-sitemap-table td{border-bottom:1px solid #f0f0f1;padding:8px;vertical-align:top;text-align:left}
					.aegisseo-pill{display:inline-block;padding:2px 8px;border-radius:999px;background:#f6f7f7;border:1px solid #dcdcde;font-size:12px}
					.aegisseo-ok{background:#edfaef;border-color:#68de7c}
					.aegisseo-bad{background:#fff2f0;border-color:#ffb3ad}
					.aegisseo-mono{font-family:ui-monospace,SFMono-Regular,Menlo,Monaco,Consolas,"Liberation Mono","Courier New",monospace;font-size:12px}
					.aegisseo-ul{margin:8px 0 0 18px}

					.aegisseo-inline-row{display:flex;gap:10px;align-items:center;flex-wrap:wrap;margin-top:8px}
					.aegisseo-box{background:#fff;border:1px solid #dcdcde;border-radius:10px;padding:12px;margin-top:12px;margin-bottom:12px}
					.aegisseo-box h3{margin:0 0 8px 0}
					.aegisseo-help{font-size:12px;color:#646970;margin:6px 0 0 0}
					.aegisseo-chip{display:inline-block;background:#f6f7f7;border:1px solid #dcdcde;border-radius:999px;padding:2px 8px;font-size:12px;margin:4px 6px 0 0}
					.aegisseo-chip button{margin-left:6px}
				</style>

				<div class="aegisseo-sitemap-grid">
					<form method="post" action="options.php">
						<div class="aegisseo-sitemap-left">
							<?php
								settings_fields('aegisseo_settings_group');
								do_settings_sections('aegisseo_' . $tab);

								$opts = get_option('aegisseo_settings', array());
								$saved_plugins = array();
								if (!empty($opts['sitemap_plugins']) && is_array($opts['sitemap_plugins'])) {
									foreach ($opts['sitemap_plugins'] as $p) {
										$p = is_string($p) ? trim($p) : '';
										if ($p !== '') $saved_plugins[] = $p;
									}
									$saved_plugins = array_values(array_unique($saved_plugins));
								}

								$folder_ex = isset($opts['sitemap_folder_exclusions']) ? (string) $opts['sitemap_folder_exclusions'] : '';
							?>

						<script>
						document.addEventListener('DOMContentLoaded', function () {
							(function(){
								function chipExists(val){
									var chips = document.querySelectorAll('#aegisseo-plugin-chips .aegisseo-chip');
									for (var i=0;i<chips.length;i++){
										if (chips[i].getAttribute('data-plugin') === val) return true;
									}
									return false;
								}

								var addBtn = document.getElementById('aegisseo-add-plugin-btn');
								var picker = document.getElementById('aegisseo-plugin-picker');
								var chipsWrap = document.getElementById('aegisseo-plugin-chips');

								if (addBtn && picker && chipsWrap){
									addBtn.addEventListener('click', function(){
										var val = picker.value;
										if (!val) return;
										if (chipExists(val)) return;

										var span = document.createElement('span');
										span.className = 'aegisseo-chip';
										span.setAttribute('data-plugin', val);

										var txt = document.createTextNode(val + ' ');
										span.appendChild(txt);

										var rm = document.createElement('button');
										rm.type = 'button';
										rm.className = 'button-link-delete aegisseo-remove-plugin';
										rm.setAttribute('aria-label', 'Remove');
										rm.textContent = '×';
										span.appendChild(rm);

										var hidden = document.createElement('input');
										hidden.type = 'hidden';
										hidden.name = 'aegisseo_settings[sitemap_plugins][]';
										hidden.value = val;
										span.appendChild(hidden);

										chipsWrap.appendChild(span);
									});

									chipsWrap.addEventListener('click', function(e){
										if (e.target && e.target.classList.contains('aegisseo-remove-plugin')){
											var chip = e.target.closest('.aegisseo-chip');
											if (chip) chip.remove();
										}
									});
								}
								// Folder Exclusion UI 
								(function(){
									var input = document.getElementById('aegisseo-exclude-folder-input');
									var addBtn = document.getElementById('aegisseo-add-folder-exclusion-btn');
									var textarea = document.getElementById('aegisseo-folder-exclusions');
									var chips = document.getElementById('aegisseo-folder-exclusion-chips');

									if (!input || !addBtn || !textarea || !chips) return;

									function normalize(val){
										val = (val || '').trim();
										if (!val) return '';
										val = val.replace(/^https?:\/\/[^/]+/i, '');
										if (val[0] !== '/') val = '/' + val;
										val = val.replace(/\/+$/,''); // trim trailing slash
										return val;
									}

									function getLines(){
										var raw = textarea.value || '';
										return raw.split(/\r?\n/).map(function(x){ return x.trim(); }).filter(Boolean);
									}

									function setLines(lines){
										textarea.value = lines.join("\n");
										renderChips(lines);
									}

									function renderChips(lines){
										chips.innerHTML = '';
										lines.forEach(function(l){
											var n = normalize(l);
											if (!n) return;

											var span = document.createElement('span');
											span.className = 'aegisseo-chip';
											span.setAttribute('data-folder', n);
											span.textContent = n + ' ';

											var btn = document.createElement('button');
											btn.type = 'button';
											btn.className = 'button-link-delete';
											btn.textContent = '×';
											btn.setAttribute('aria-label', 'Remove');

											btn.addEventListener('click', function(){
												var current = getLines().map(normalize).filter(Boolean);
												current = current.filter(function(x){ return x !== n; });
												setLines(current);
											});

											span.appendChild(btn);
											chips.appendChild(span);
										});
									}

									renderChips(getLines().map(normalize).filter(Boolean));

									addBtn.addEventListener('click', function(){
										var val = normalize(input.value);
										if (!val) return;

										var current = getLines().map(normalize).filter(Boolean);
										if (current.indexOf(val) === -1){
											current.push(val);
											setLines(current);
										}
										input.value = '';
									});
								})();
							})();
						});
						</script>
						<?php submit_button(); ?>
					</div>

					<div class="aegisseo-sitemap-right">

						<div class="aegisseo-box">
							<h3><?php echo esc_html__('Plugins', 'aegisseo'); ?></h3>
							<p class="aegisseo-help"><?php echo esc_html__('Add a plugin to auto-include its known content types in the sitemap. WooCommerce is supported by default.', 'aegisseo'); ?></p>

							<?php
							if (!function_exists('get_plugins')) {
								require_once ABSPATH . 'wp-admin/includes/plugin.php';
							}
							$all_plugins = function_exists('get_plugins') ? get_plugins() : array();
							?>

							<div class="aegisseo-inline-row">
								<select id="aegisseo-plugin-picker">
									<option value=""><?php echo esc_html__('-- Select a plugin --', 'aegisseo'); ?></option>
									<?php foreach ($all_plugins as $file => $data): ?>
										<option value="<?php echo esc_attr($file); ?>">
											<?php echo esc_html($data['Name'] . ' (' . $file . ')'); ?>
										</option>
									<?php endforeach; ?>
								</select>

								<button type="button" class="button" id="aegisseo-add-plugin-btn">
									<?php echo esc_html__('Add Plugin', 'aegisseo'); ?>
								</button>
							</div>

							<div id="aegisseo-plugin-chips">
								<?php if (!empty($saved_plugins)): ?>
									<?php foreach ($saved_plugins as $p): ?>
										<span class="aegisseo-chip" data-plugin="<?php echo esc_attr($p); ?>">
											<?php echo esc_html($p); ?>
											<button type="button" class="button-link-delete aegisseo-remove-plugin" aria-label="<?php echo esc_attr__('Remove', 'aegisseo'); ?>">×</button>
											<input type="hidden" name="aegisseo_settings[sitemap_plugins][]" value="<?php echo esc_attr($p); ?>" />
										</span>
									<?php endforeach; ?>
								<?php endif; ?>
							</div>
						</div>

						<div class="aegisseo-box">
							<h3><?php echo esc_html__('Folder Exclusions', 'aegisseo'); ?></h3>
							<p class="aegisseo-help"><?php echo esc_html__('One per line. Any sitemap URL containing one of these path fragments will be excluded. Examples: /private/, /wp-content/uploads/tmp, /downloads/', 'aegisseo'); ?></p>
							<div class="aegisseo-inline-row" style="margin:10px 0;">
								<input type="text"
									id="aegisseo-exclude-folder-input"
									placeholder="<?php echo esc_attr__('/private/  (example)', 'aegisseo'); ?>"
									style="flex:1;min-width:260px;" />

								<button type="button" class="button" id="aegisseo-add-folder-exclusion-btn">
									<?php echo esc_html__('Exclude Folder', 'aegisseo'); ?>
								</button>
							</div>
							<p class="aegisseo-help" style="margin-top:0;">
								<?php echo esc_html__('Tip: Use a path fragment. Anything containing it will be excluded from ALL sitemap XML outputs.', 'aegisseo'); ?>
							</p>
							<textarea id="aegisseo-folder-exclusions"
								name="aegisseo_settings[sitemap_folder_exclusions]"
								rows="6"
								style="width:100%;"><?php echo esc_textarea($folder_ex); ?></textarea>

							<div id="aegisseo-folder-exclusion-chips" style="margin-top:10px;"></div>
						</div>

						<?php
						if (class_exists('\\AegisSEO\\SEO\\Sitemap') && method_exists('\\AegisSEO\\SEO\\Sitemap', 'render_sitemap_inventory_panel')) {
							\AegisSEO\SEO\Sitemap::render_sitemap_inventory_panel();
						}
						?>

					</div>
					</form>
				</div>
				<?php
				break;
            default:
                ?>
                <form method="post" action="options.php">
                    <?php
                    settings_fields('aegisseo_settings_group');
                    do_settings_sections('aegisseo_' . $tab);
                    submit_button();
                    ?>
                </form>
                <?php
                break;
        }
        ?>
    </div>

    <hr />
    <div class="aegisseo-footer">
        <p>
            <span><?php echo esc_html__('Powered by Aegisify', 'aegisseo'); ?></span>
            &nbsp;·&nbsp;
            <a href="https://aegisify.com" target="_blank" rel="noopener">aegisify.com</a>
        </p>
    </div>
</div>
