<?php
if (!defined('ABSPATH')) { exit; }

global $wpdb;

$t404 = $wpdb->prefix . 'aegisseo_404';

$search   = isset($_GET['s']) ? sanitize_text_field(wp_unslash($_GET['s'])) : '';
$min_hits = isset($_GET['min_hits']) ? absint($_GET['min_hits']) : 0;

$page     = isset($_GET['p']) ? max(1, absint($_GET['p'])) : 1;
$per_page = 25;
$offset   = ($page - 1) * $per_page;

$where  = "1=1";
$params = array();

if ($search !== '') {
    $where .= " AND url LIKE %s";
    $params[] = '%' . $wpdb->esc_like($search) . '%';
}
if ($min_hits > 0) {
    $where .= " AND hits >= %d";
    $params[] = $min_hits;
}

$sql_count = "SELECT COUNT(*) FROM {$t404} WHERE {$where}";
$total = $params ? (int) $wpdb->get_var($wpdb->prepare($sql_count, $params)) : (int) $wpdb->get_var($sql_count);

$sql_list = "SELECT * FROM {$t404} WHERE {$where} ORDER BY last_seen DESC LIMIT %d OFFSET %d";
$params_list = $params;
$params_list[] = $per_page;
$params_list[] = $offset;

$rows = $params ? $wpdb->get_results($wpdb->prepare($sql_list, $params_list), ARRAY_A) : $wpdb->get_results($wpdb->prepare($sql_list, $per_page, $offset), ARRAY_A);

$total_pages = max(1, (int) ceil($total / $per_page));

$base = remove_query_arg(array('p'));
?>
<div class="aegisseo-panel">
    <h3 style="margin-top:0;"><?php echo esc_html__('404 Monitor', 'aegisseo'); ?></h3>

    <form method="get" action="<?php echo esc_url(admin_url('admin.php')); ?>" style="margin: 0 0 14px 0;">
        <input type="hidden" name="page" value="aegisseo" />
        <input type="hidden" name="tab" value="404" />
        <input type="text" name="s" value="<?php echo esc_attr($search); ?>" placeholder="<?php echo esc_attr__('Search URL…', 'aegisseo'); ?>" style="min-width:280px;" />
        <input type="number" name="min_hits" value="<?php echo esc_attr($min_hits); ?>" placeholder="<?php echo esc_attr__('Min hits', 'aegisseo'); ?>" style="width:120px;" />
        <button class="button"><?php echo esc_html__('Filter', 'aegisseo'); ?></button>
        <a class="button" href="<?php echo esc_url(admin_url('admin.php?page=aegisseo&tab=404')); ?>"><?php echo esc_html__('Reset', 'aegisseo'); ?></a>
    </form>

    <div style="display:flex; gap:8px; flex-wrap:wrap; margin: 0 0 14px 0;">
        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
            <?php wp_nonce_field('aegisseo_404_export'); ?>
            <input type="hidden" name="action" value="aegisseo_404_export" />
            <button class="button"><?php echo esc_html__('Export CSV', 'aegisseo'); ?></button>
        </form>

        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" onsubmit="return confirm('<?php echo esc_js(__('Clear all 404 records?', 'aegisseo')); ?>');">
            <?php wp_nonce_field('aegisseo_404_clear'); ?>
            <input type="hidden" name="action" value="aegisseo_404_clear" />
            <button class="button button-secondary"><?php echo esc_html__('Clear', 'aegisseo'); ?></button>
        </form>

        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
            <?php wp_nonce_field('aegisseo_404_prune'); ?>
            <input type="hidden" name="action" value="aegisseo_404_prune" />
            <button class="button button-secondary"><?php echo esc_html__('Prune Now', 'aegisseo'); ?></button>
        </form>
    </div>

    <table class="widefat striped">
        <thead>
            <tr>
                <th style="width:38%;"><?php echo esc_html__('URL', 'aegisseo'); ?></th>
                <th style="width:8%;"><?php echo esc_html__('Hits', 'aegisseo'); ?></th>
                <th style="width:14%;"><?php echo esc_html__('First seen', 'aegisseo'); ?></th>
                <th style="width:14%;"><?php echo esc_html__('Last seen', 'aegisseo'); ?></th>
                <th style="width:18%;"><?php echo esc_html__('Referrer', 'aegisseo'); ?></th>
                <th style="width:8%;"><?php echo esc_html__('Actions', 'aegisseo'); ?></th>
            </tr>
        </thead>
        <tbody>
        <?php if (empty($rows)) : ?>
            <tr><td colspan="6"><?php echo esc_html__('No 404 records found.', 'aegisseo'); ?></td></tr>
        <?php else : ?>
            <?php foreach ($rows as $r) : ?>
                <?php
                    $url = isset($r['url']) ? (string) $r['url'] : '';
                    $hits = isset($r['hits']) ? (int) $r['hits'] : 0;
                    $first = isset($r['first_seen']) ? (string) $r['first_seen'] : '';
                    $last = isset($r['last_seen']) ? (string) $r['last_seen'] : '';
                    $ref = isset($r['referrer']) ? (string) $r['referrer'] : '';
                    $create_url = admin_url('admin.php?page=aegisseo&tab=redirects&from404=' . rawurlencode($url));
                ?>
                <tr>
                    <td>
                        <code><?php echo esc_html($url); ?></code>
                        <?php if (!empty($r['ip'])) : ?>
                            <div style="color:#666; font-size:12px;"><?php echo esc_html__('IP:', 'aegisseo'); ?> <?php echo esc_html((string)$r['ip']); ?></div>
                        <?php endif; ?>
                    </td>
                    <td><?php echo esc_html($hits); ?></td>
                    <td><?php echo esc_html($first); ?></td>
                    <td><?php echo esc_html($last); ?></td>
                    <td>
                        <?php if ($ref) : ?>
                            <span title="<?php echo esc_attr($ref); ?>"><?php echo esc_html(mb_strlen($ref) > 48 ? mb_substr($ref, 0, 48) . '…' : $ref); ?></span>
                        <?php else : ?>
                            <span style="color:#666;">—</span>
                        <?php endif; ?>
                    </td>
                    <td><a class="button button-small" href="<?php echo esc_url($create_url); ?>"><?php echo esc_html__('Redirect', 'aegisseo'); ?></a></td>
                </tr>
            <?php endforeach; ?>
        <?php endif; ?>
        </tbody>
    </table>

    <?php if ($total_pages > 1) : ?>
        <div style="margin-top: 12px;">
            <span class="description"><?php echo esc_html(sprintf(__('Page %d of %d', 'aegisseo'), $page, $total_pages)); ?></span>
            <div style="margin-top:6px;">
                <?php for ($i=1; $i<=$total_pages; $i++) : ?>
                    <?php
                        $u = add_query_arg('p', $i, $base);
                        $cls = ($i === $page) ? 'button button-primary button-small' : 'button button-small';
                    ?>
                    <a class="<?php echo esc_attr($cls); ?>" href="<?php echo esc_url($u); ?>"><?php echo esc_html($i); ?></a>
                <?php endfor; ?>
            </div>
        </div>
    <?php endif; ?>
</div>
