<?php
if (!defined('ABSPATH')) { exit; }

$opts = aegisseo()->options->get_all();
?>

<div class="aegisseo-card">
    <h2><?php echo esc_html__('Advanced (Technical SEO Tools)', 'aegisseo'); ?></h2>

    <?php if (isset($_GET['saved'])): ?>
        <div class="notice notice-success inline"><p><?php echo esc_html__('Advanced settings saved.', 'aegisseo'); ?></p></div>
    <?php endif; ?>
    <?php if (isset($_GET['htaccess_applied'])): ?>
        <div class="notice notice-success inline"><p><?php echo esc_html__('.htaccess rules applied.', 'aegisseo'); ?></p></div>
    <?php endif; ?>
    <?php if (isset($_GET['htaccess_restored'])): ?>
        <div class="notice notice-success inline"><p><?php echo esc_html__('.htaccess restored from latest backup.', 'aegisseo'); ?></p></div>
    <?php endif; ?>
    <?php if (isset($_GET['htaccess_error'])): ?>
        <div class="notice notice-error inline"><p><?php echo esc_html(urldecode($_GET['htaccess_error'])); ?></p></div>
    <?php endif; ?>

    <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
        <?php wp_nonce_field('aegisseo_save_advanced'); ?>
        <input type="hidden" name="action" value="aegisseo_save_advanced" />

        <h3><?php echo esc_html__('404 Monitor', 'aegisseo'); ?></h3>
        <p>
            <label><input type="checkbox" name="monitor_404_enabled" value="1" <?php checked((int)$opts['monitor_404_enabled'], 1); ?> /> <?php echo esc_html__('Enable 404 logging', 'aegisseo'); ?></label>
        </p>
        <p>
            <label><?php echo esc_html__('Retention (days)', 'aegisseo'); ?>:
                <input type="number" name="monitor_404_retention_days" value="<?php echo esc_attr((int)$opts['monitor_404_retention_days']); ?>" min="1" style="width:90px;" />
            </label>
            &nbsp;&nbsp;
            <label><?php echo esc_html__('Max rows', 'aegisseo'); ?>:
                <input type="number" name="monitor_404_max_rows" value="<?php echo esc_attr((int)$opts['monitor_404_max_rows']); ?>" min="100" style="width:100px;" />
            </label>
        </p>

        <hr />

        <h3><?php echo esc_html__('Redirects', 'aegisseo'); ?></h3>
        <p>
            <label><input type="checkbox" name="redirects_enabled" value="1" <?php checked((int)$opts['redirects_enabled'], 1); ?> /> <?php echo esc_html__('Enable Redirect Manager', 'aegisseo'); ?></label>
        </p>

        <hr />

        <h3><?php echo esc_html__('Breadcrumbs', 'aegisseo'); ?></h3>
        <p>
            <label><input type="checkbox" name="breadcrumbs_enabled" value="1" <?php checked((int)$opts['breadcrumbs_enabled'], 1); ?> /> <?php echo esc_html__('Enable Breadcrumbs', 'aegisseo'); ?></label>
        </p>
        <p class="description">
            <?php echo esc_html__('Use shortcode: [aegisseo_breadcrumbs] — or in PHP: echo aegisseo()->breadcrumbs->render();', 'aegisseo'); ?>
        </p>
        <p>
            <label><?php echo esc_html__('Separator', 'aegisseo'); ?>:
                <input type="text" name="breadcrumbs_sep" value="<?php echo esc_attr(isset($opts['breadcrumbs_sep']) ? $opts['breadcrumbs_sep'] : '›'); ?>" style="width:80px;" />
            </label>
        </p>

        <hr />

        <h3><?php echo esc_html__('robots.txt Editor', 'aegisseo'); ?></h3>
        <p>
            <label><input type="checkbox" name="robots_custom_enabled" value="1" <?php checked((int)$opts['robots_custom_enabled'], 1); ?> /> <?php echo esc_html__('Enable custom robots rules', 'aegisseo'); ?></label>
        </p>
        <p>
            <textarea name="robots_custom_rules" rows="8" style="width:100%; max-width:900px;"><?php echo esc_textarea((string)$opts['robots_custom_rules']); ?></textarea>
        </p>
        <p class="description"><?php echo esc_html__('These rules will be appended to the generated robots.txt output.', 'aegisseo'); ?></p>

        <hr />

        <h3><?php echo esc_html__('.htaccess Helper (Safe Mode)', 'aegisseo'); ?></h3>
        <p class="description">
            <?php echo esc_html__('Careful: This writes a small, isolated block to .htaccess between AegisSEO markers, and creates a timestamped backup before any changes.', 'aegisseo'); ?>
        </p>
        <p>
            <label><input type="checkbox" name="htaccess_helper_enabled" value="1" <?php checked((int)$opts['htaccess_helper_enabled'], 1); ?> /> <?php echo esc_html__('Enable .htaccess helper', 'aegisseo'); ?></label>
        </p>

        <p>
            <label><input type="checkbox" name="htaccess_force_https" value="1" <?php checked((int)$opts['htaccess_force_https'], 1); ?> /> <?php echo esc_html__('Force HTTPS (301)', 'aegisseo'); ?></label>
        </p>

        <p>
            <label><?php echo esc_html__('Preferred domain', 'aegisseo'); ?>:
                <select name="htaccess_force_www">
                    <?php
                        $cur = (int)$opts['htaccess_force_www'];
                        $val = ($cur===1) ? 'www' : (($cur===-1) ? 'nonwww' : 'no');
                    ?>
                    <option value="no" <?php selected($val, 'no'); ?>><?php echo esc_html__('No change', 'aegisseo'); ?></option>
                    <option value="www" <?php selected($val, 'www'); ?>><?php echo esc_html__('Force www', 'aegisseo'); ?></option>
                    <option value="nonwww" <?php selected($val, 'nonwww'); ?>><?php echo esc_html__('Force non-www', 'aegisseo'); ?></option>
                </select>
            </label>
        </p>

        <p>
            <label><input type="checkbox" name="htaccess_trailing_slash" value="1" <?php checked((int)$opts['htaccess_trailing_slash'], 1); ?> /> <?php echo esc_html__('Force trailing slash (301)', 'aegisseo'); ?></label>
        </p>

        <p>
            <button class="button button-primary"><?php echo esc_html__('Save Advanced Settings', 'aegisseo'); ?></button>
        </p>
    </form>

    <div class="aegisseo-card" style="padding: 0; border: 0; margin-top: 18px;">
        <h3><?php echo esc_html__('Preview: .htaccess Rules AegisSEO Would Apply', 'aegisseo'); ?></h3>
        <pre style="background:#fff; border:1px solid #ddd; padding:10px; max-width:900px; overflow:auto;"><?php echo esc_html(aegisseo()->htaccess->generate_rules()); ?></pre>

        <div style="display:flex; gap:10px;">
            <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" onsubmit="return confirm('<?php echo esc_js(__('Apply these rules to .htaccess? A backup will be created automatically.', 'aegisseo')); ?>');">
                <?php wp_nonce_field('aegisseo_htaccess_apply'); ?>
                <input type="hidden" name="action" value="aegisseo_htaccess_apply" />
                <button class="button button-secondary"><?php echo esc_html__('Apply to .htaccess', 'aegisseo'); ?></button>
            </form>

            <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" onsubmit="return confirm('<?php echo esc_js(__('Restore .htaccess from the latest AegisSEO backup?', 'aegisseo')); ?>');">
                <?php wp_nonce_field('aegisseo_htaccess_restore'); ?>
                <input type="hidden" name="action" value="aegisseo_htaccess_restore" />
                <button class="button button-secondary"><?php echo esc_html__('Restore Latest Backup', 'aegisseo'); ?></button>
            </form>
        </div>
    </div>
</div>
