<?php
namespace AegisSEO;

if (!defined('ABSPATH')) { exit; }

final class Plugin {

    private static $instance = null;
    public $admin;
    public $frontend;
    public $sitemap;
    public $monitor404;
    public $redirects;
    public $breadcrumbs;
    public $robots;
    public $htaccess;
    public $meta;
    public $schema;
    public $score;
    public $linking;
    public $gsc;
    public $local;
    public $options;
    public $license;
    public $events;
    public $gsc_snapshots;
	public $alerts;  
    public $autopilot;
    public $security_seo;

    public static function instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {}

    public function boot() {
        $this->includes();
        $this->options  = new Utils\Options();
        $this->license  = new Utils\License();
        $this->license->hook_update_check();
        $this->events   = new SEO\Events();
        $this->security_seo = new SEO\Security_SEO($this->options, $this->events);

        $dbv = get_option('aegisseo_db_version', '');
        if ($dbv !== SEO\Installer::DB_VERSION) {
            SEO\Installer::install();
        }

        $this->meta     = new SEO\Meta();
        $this->schema   = new SEO\Schema($this->options);
        $this->score = new SEO\Score();
        $this->linking = new SEO\Linking();
        $this->gsc = new SEO\GSC($this->options);
        $this->gsc_snapshots = new SEO\GSC_Snapshots($this->options, $this->gsc, $this->events);
		$this->alerts = new \AegisSEO\SEO\Alerts($this->options);
        $this->autopilot = new SEO\Autopilot($this->options);
        $this->local = new SEO\Local($this->options);
        $this->frontend = new SEO\Frontend($this->options, $this->schema);
        $this->sitemap  = new SEO\Sitemap($this->options);

        $this->monitor404 = new SEO\Monitor_404($this->options);
        $this->redirects   = new SEO\Redirects($this->options);
        $this->breadcrumbs = new SEO\Breadcrumbs($this->options, $this->schema);
        $this->robots      = new SEO\Robots($this->options);
        $this->htaccess    = new SEO\Htaccess_Helper($this->options);


        if (is_admin()) {
            $this->admin = new Admin\Admin($this->options, $this->score);
        }

        register_activation_hook(AEGISSEO_FILE, array($this, 'activate'));
        register_deactivation_hook(AEGISSEO_FILE, array($this, 'deactivate'));
    }

    private function includes() {
        require_once AEGISSEO_DIR . 'includes/utils/class-aegisseo-options.php';
        require_once AEGISSEO_DIR . 'includes/utils/class-aegisseo-license.php';
        require_once AEGISSEO_DIR . 'includes/utils/class-aegisseo-sanitize.php';

        require_once AEGISSEO_DIR . 'includes/seo/class-aegisseo-variables.php';
        require_once AEGISSEO_DIR . 'includes/seo/class-aegisseo-meta.php';
        require_once AEGISSEO_DIR . 'includes/seo/class-aegisseo-schema.php';
        require_once AEGISSEO_DIR . 'includes/seo/class-aegisseo-frontend.php';
        require_once AEGISSEO_DIR . 'includes/seo/class-aegisseo-sitemap.php';
        require_once AEGISSEO_DIR . 'includes/seo/class-aegisseo-local.php';
        require_once AEGISSEO_DIR . 'includes/seo/class-aegisseo-gsc.php';
        require_once AEGISSEO_DIR . 'includes/seo/class-aegisseo-gsc-snapshots.php';
        require_once AEGISSEO_DIR . 'includes/seo/class-aegisseo-autopilot.php';
        require_once AEGISSEO_DIR . 'includes/seo/class-aegisseo-security-seo.php';
        require_once AEGISSEO_DIR . 'includes/seo/class-aegisseo-linking.php';
        require_once AEGISSEO_DIR . 'includes/seo/class-aegisseo-score.php';
        require_once AEGISSEO_DIR . 'includes/seo/class-aegisseo-events.php';
		require_once AEGISSEO_DIR . 'includes/seo/class-aegisseo-alerts.php';
        require_once AEGISSEO_DIR . 'includes/seo/class-aegisseo-installer.php';
        require_once AEGISSEO_DIR . 'includes/seo/class-aegisseo-404-monitor.php';
        require_once AEGISSEO_DIR . 'includes/seo/class-aegisseo-redirects.php';
        require_once AEGISSEO_DIR . 'includes/seo/class-aegisseo-breadcrumbs.php';
        require_once AEGISSEO_DIR . 'includes/seo/class-aegisseo-robots.php';
        require_once AEGISSEO_DIR . 'includes/seo/class-aegisseo-htaccess-helper.php';
        require_once AEGISSEO_DIR . 'includes/admin/class-aegisseo-admin.php';
        require_once AEGISSEO_DIR . 'includes/admin/class-aegisseo-admin-menu.php';
        require_once AEGISSEO_DIR . 'includes/admin/class-aegisseo-admin-ops.php';
        require_once AEGISSEO_DIR . 'includes/admin/class-aegisseo-admin-settings.php';
        require_once AEGISSEO_DIR . 'includes/admin/class-aegisseo-admin-wizard.php';
        require_once AEGISSEO_DIR . 'includes/admin/class-aegisseo-admin-metabox.php';
        require_once AEGISSEO_DIR . 'includes/admin/class-aegisseo-admin-tools.php';
        require_once AEGISSEO_DIR . 'includes/admin/class-aegisseo-admin-ajax.php';
        require_once AEGISSEO_DIR . 'includes/admin/class-aegisseo-admin-bulk.php';
        require_once AEGISSEO_DIR . 'includes/admin/class-aegisseo-admin-migration.php';
        require_once AEGISSEO_DIR . 'includes/admin/class-aegisseo-admin-issues.php';
        require_once AEGISSEO_DIR . 'includes/admin/class-aegisseo-admin-technical.php';
    }

    public function activate() {

        $opts = new Utils\Options();
        $opts->ensure_defaults();

        \AegisSEO\SEO\Installer::install();

        if (function_exists('aegisseo') && isset(aegisseo()->license) && aegisseo()->license) {
            aegisseo()->license->maybe_send_free_register(AEGISSEO_VERSION);
        }

        set_transient('aegisseo_do_wizard', '1', 60);

        if (!wp_next_scheduled('aegisseo_daily_maintenance')) {
            wp_schedule_event(time() + 300, 'daily', 'aegisseo_daily_maintenance');
        }

        if (!wp_next_scheduled('aegisseo_gsc_snapshot_runner')) {
            wp_schedule_event(time() + 600, 'daily', 'aegisseo_gsc_snapshot_runner');
        }
		
		if (!wp_next_scheduled('aegisseo_alerts_runner')) {
			wp_schedule_event(time() + 900, 'daily', 'aegisseo_alerts_runner');
		}
        flush_rewrite_rules();
    }

    public function deactivate() {
        set_transient('aegisseo_do_wizard', '1', 60);
        wp_clear_scheduled_hook('aegisseo_daily_maintenance');
        wp_clear_scheduled_hook('aegisseo_gsc_snapshot_runner');
        flush_rewrite_rules();
		wp_clear_scheduled_hook('aegisseo_alerts_runner');
    }
}