<?php
if (!defined('ABSPATH')) { exit; }
if (!current_user_can('edit_posts')) { echo '<p>' . esc_html__('Forbidden', 'aegisseo') . '</p>'; return; }

$smart_opt_key = 'aegisseo_smart_links';
$smart_opts = get_option($smart_opt_key, array('enabled' => 0, 'map' => array()));
if (!is_array($smart_opts)) { $smart_opts = array('enabled' => 0, 'map' => array()); }
if (!isset($smart_opts['enabled'])) { $smart_opts['enabled'] = 0; }
if (!isset($smart_opts['map']) || !is_array($smart_opts['map'])) { $smart_opts['map'] = array(); }

// Handle Smart Links save
if (!empty($_POST['aegisseo_smart_links_save'])) {
    check_admin_referer('aegisseo_smart_links_save');

    $enabled = !empty($_POST['smart_links_enabled']) ? 1 : 0;

    $keywords = isset($_POST['smart_keyword']) && is_array($_POST['smart_keyword']) ? $_POST['smart_keyword'] : array();
    $urls     = isset($_POST['smart_url']) && is_array($_POST['smart_url']) ? $_POST['smart_url'] : array();

    $map = array();
    $count = max(count($keywords), count($urls));

    for ($i = 0; $i < $count; $i++) {
        $kw  = isset($keywords[$i]) ? sanitize_text_field($keywords[$i]) : '';
        $url = isset($urls[$i]) ? esc_url_raw(trim($urls[$i])) : '';

        $kw = trim($kw);

        // enforce: one word only (no whitespace)
        if ($kw === '' || preg_match('/\s/', $kw)) { continue; }
        if ($url === '') { continue; }

        // avoid duplicates (case-insensitive)
        $map[strtolower($kw)] = array(
            'keyword' => $kw,
            'url'     => $url,
        );
    }

    $smart_opts = array(
        'enabled' => $enabled,
        'map'     => array_values($map),
    );

    update_option($smart_opt_key, $smart_opts, false);

    echo '<div class="notice notice-success"><p>' . esc_html__('Smart Links saved.', 'aegisseo') . '</p></div>';
}

$post_id = isset($_GET['post_id']) ? (int) $_GET['post_id'] : 0;

echo '<h2>' . esc_html__('Internal Linking Assistant', 'aegisseo') . '</h2>';
echo '<p class="description">' . esc_html__('Suggestions are based on the post title + categories/tags keywords.', 'aegisseo') . '</p>';
echo '<hr style="margin:18px 0;" />';
echo '<h2 style="margin:0 0 6px 0;">' . esc_html__('Smart Links (Keyword → URL)', 'aegisseo') . '</h2>';
echo '<p class="description" style="margin:0 0 12px 0;">' . esc_html__('Create one-word keywords that automatically link across your entire site content. Example: AegisWAF → https://aegisify.com/aegiswaf/', 'aegisseo') . '</p>';

echo '<form method="post" action="">';
wp_nonce_field('aegisseo_smart_links_save');
echo '<input type="hidden" name="aegisseo_smart_links_save" value="1" />';

echo '<label style="display:inline-flex; align-items:center; gap:8px; margin: 0 0 10px 0;">';
echo '<input type="checkbox" name="smart_links_enabled" value="1" ' . checked(!empty($smart_opts['enabled']), true, false) . ' />';
echo '<strong>' . esc_html__('Enable Smart Links site-wide', 'aegisseo') . '</strong>';
echo '</label>';

echo '<table class="widefat striped" style="max-width:1100px;">';
echo '<thead><tr>';
echo '<th style="width:240px;">' . esc_html__('Keyword (one word)', 'aegisseo') . '</th>';
echo '<th>' . esc_html__('Destination URL', 'aegisseo') . '</th>';
echo '</tr></thead><tbody>';

$rows = !empty($smart_opts['map']) ? $smart_opts['map'] : array();
if (count($rows) < 6) {
    for ($i = count($rows); $i < 6; $i++) { $rows[] = array('keyword'=>'', 'url'=>''); }
}

foreach ($rows as $row) {
    $kw  = isset($row['keyword']) ? $row['keyword'] : '';
    $url = isset($row['url']) ? $row['url'] : '';
    echo '<tr>';
    echo '<td><input class="regular-text" type="text" name="smart_keyword[]" value="' . esc_attr($kw) . '" placeholder="AegisSEO" /></td>';
    echo '<td><input class="large-text" type="url" name="smart_url[]" value="' . esc_attr($url) . '" placeholder="https://aegisify.com/aegisseo/" /></td>';
    echo '</tr>';
}

echo '</tbody></table>';

echo '<p class="description" style="margin-top:10px;">' . esc_html__('Rules: one keyword = one URL. Keywords are case-insensitive. Existing links are not modified.', 'aegisseo') . '</p>';

submit_button(__('Save Smart Links', 'aegisseo'), 'primary', 'submit', false);
echo '</form>';

echo '<hr style="margin:18px 0;" />';

$posts = get_posts(array('post_type'=>'post','numberposts'=>50,'post_status'=>array('publish','draft')));
echo '<form method="get" action="">';
echo '<input type="hidden" name="page" value="aegisseo" />';
echo '<input type="hidden" name="tab" value="links" />';
echo '<select name="post_id">';
echo '<option value="0">' . esc_html__('-- Select a post --', 'aegisseo') . '</option>';
foreach ($posts as $p) {
    echo '<option value="' . esc_attr($p->ID) . '" ' . selected($post_id, $p->ID, false) . '>' . esc_html(get_the_title($p->ID)) . '</option>';
}
echo '</select> ';
submit_button(__('Suggest', 'aegisseo'), 'secondary', '', false);
echo '</form>';
if ($post_id) {
    $suggestions = aegisseo()->linking->suggest_links($post_id, 10);
    if (empty($suggestions)) echo '<p>' . esc_html__('No suggestions found yet.', 'aegisseo') . '</p>';
    else {
        echo '<ul>';
        foreach ($suggestions as $s) echo '<li><a href="' . esc_url($s['url']) . '" target="_blank" rel="noopener">' . esc_html($s['title']) . '</a></li>';
        echo '</ul>';
    }
}
