<?php
if (!defined('ABSPATH')) { exit; }

$aegisseo_has_pro = false;
if (function_exists('aegisseo') && isset(aegisseo()->license) && aegisseo()->license) {
    $aegisseo_has_pro = (bool) aegisseo()->license->is_pro();
}
if (!$aegisseo_has_pro && class_exists('AegisSEO\\Utils\\License')) {
    \AegisSEO\Utils\License::render_pro_banner(
        __('Upgrade to PRO', 'aegisseo'),
        __('PRO feature: SEO Ops Center, Issues & Fixex, Evidence and Migration Wizard with advanced autopilot detection, guided fixes, and bulk remediation actions are available in AegisSEO PRO.', 'aegisseo')
    );
    echo '<p class="description" style="margin-top:10px;">' . esc_html__('Activate a PRO license to unlock Issues & Fixes.', 'aegisseo') . '</p>';
    return;
}
?>

<div id="aegisseo-ops-center">

    <style>
        /* In-tab alert panels (NOT WordPress admin notices) */
        .aegisseo-alert{
            border:1px solid #dcdcde;
            background:#fff;
            border-left-width:5px;
            padding:10px 12px;
            margin:10px 0 12px 0;
            border-radius:2px;
        }
        .aegisseo-alert p{ margin:0; }
        .aegisseo-alert-info{ border-left-color:#2271b1; }
        .aegisseo-alert-warn{ border-left-color:#dba617; }
        .aegisseo-alert-error{ border-left-color:#d63638; }
        .aegisseo-alert-success{ border-left-color:#00a32a; }
    </style>

    <h2 style="margin-top:0;">SEO Ops Center</h2>

    <?php
    // Always build the payload FIRST (do NOT gate this behind notes)
    $ops = null;

    if (function_exists('aegisseo') && isset(aegisseo()->admin)) {
        $ops = new \AegisSEO\Admin\Admin_Ops(aegisseo()->options);
    } else {
        $ops = new \AegisSEO\Admin\Admin_Ops(new \AegisSEO\Utils\Options());
    }

    // Safe defaults so the page never fatals
    $data = array(
        'notes'    => array(),
        'overview' => array(
            '28' => array('clicks'=>0,'impressions'=>0,'ctr'=>0,'position'=>0),
        ),
    );

    // Pull live payload (but only if it returns a valid array)
    if ($ops && method_exists($ops, 'get_dashboard_payload')) {
        $payload = $ops->get_dashboard_payload();
        if (is_array($payload)) {
            $data = array_replace_recursive($data, $payload);
        }
    }

    // Define helper safely (prevents redeclare fatal if this template is included twice)
    if (!function_exists('aegisseo_num')) {
        function aegisseo_num($n) {
            if ($n === null || $n === '') return '0';
            if (is_numeric($n)) {
                if ((float)$n >= 1000) return number_format_i18n((float)$n, 0);
                return number_format_i18n((float)$n, 2);
            }
            return esc_html((string)$n);
        }
    }

    $overview28 = $data['overview']['28'] ?? array('clicks'=>0,'impressions'=>0,'ctr'=>0,'position'=>0);
    ?>

	<?php if (!empty($data['notes'])): ?>
		<div class="aegisseo-alert aegisseo-alert-info">
			<p><?php echo esc_html(implode(' ', (array) $data['notes'])); ?></p>
		</div>
	<?php endif; ?>

    <div class="aegisseo-grid" style="display:grid; grid-template-columns:repeat(4,1fr); gap:12px; margin:12px 0;">
        <div class="aegisseo-card" style="padding:14px;">
            <div style="font-size:12px; opacity:.8;">Clicks (28d)</div>
            <div style="font-size:22px; font-weight:700; margin-top:6px;"><?php echo esc_html(aegisseo_num($overview28['clicks'] ?? 0)); ?></div>
        </div>
        <div class="aegisseo-card" style="padding:14px;">
            <div style="font-size:12px; opacity:.8;">Impressions (28d)</div>
            <div style="font-size:22px; font-weight:700; margin-top:6px;"><?php echo esc_html(aegisseo_num($overview28['impressions'] ?? 0)); ?></div>
        </div>
        <div class="aegisseo-card" style="padding:14px;">
            <div style="font-size:12px; opacity:.8;">CTR (28d)</div>
            <div style="font-size:22px; font-weight:700; margin-top:6px;"><?php echo esc_html(aegisseo_num($overview28['ctr'] ?? 0)); ?>%</div>
        </div>
        <div class="aegisseo-card" style="padding:14px;">
            <div style="font-size:12px; opacity:.8;">Avg Position (28d)</div>
            <div style="font-size:22px; font-weight:700; margin-top:6px;"><?php echo esc_html(aegisseo_num($overview28['position'] ?? 0)); ?></div>
        </div>
    </div>

    <div class="aegisseo-card" style="padding:14px; margin:12px 0;">
        <div style="display:flex; align-items:center; justify-content:space-between; gap:12px;">
            <h3 style="margin:0;">Performance (GSC)</h3>
            <div>
                <label for="aegisseo_ops_window" style="margin-right:6px; font-weight:600;">Window</label>
                <select id="aegisseo_ops_window">
                    <option value="7">Last 7d vs prev 7d</option>
                    <option value="28" selected>Last 28d vs prev 28d</option>
                    <option value="90">Last 90d vs prev 90d</option>
                </select>
            </div>
        </div>
        <p style="margin:8px 0 0; opacity:.8;">Winners and losers are ranked by change in clicks for the selected window.</p>

        <div style="margin-top:12px;">
            <canvas id="aegisseo_ops_chart" height="90"></canvas>
        </div>

        <div style="display:grid; grid-template-columns:1fr 1fr; gap:12px; margin-top:12px;">
            <div>
                <h4 style="margin:0 0 8px;">Top Winners</h4>
                <table class="widefat striped" id="aegisseo_ops_winners">
                    <thead><tr><th>Page</th><th>Δ Clicks</th><th>Clicks</th><th>Impr</th></tr></thead>
                    <tbody></tbody>
                </table>
            </div>
            <div>
                <h4 style="margin:0 0 8px;">Top Losers</h4>
                <table class="widefat striped" id="aegisseo_ops_losers">
                    <thead><tr><th>Page</th><th>Δ Clicks</th><th>Clicks</th><th>Impr</th></tr></thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>

    <div style="display:grid; grid-template-columns:1.2fr .8fr; gap:12px;">
        <div class="aegisseo-card" style="padding:14px;">
            <h3 style="margin-top:0;">Query Clusters & Content Gaps</h3>
            <?php if (empty($data['gsc_connected'])): ?>
                <div class="aegisseo-alert aegisseo-alert-warn">
					<p>Connect Search Console in the <strong>Search Console</strong> tab to unlock query clusters and content gaps.</p>
				</div>
            <?php else: ?>
                <div style="display:grid; grid-template-columns:1fr 1fr; gap:12px;">
                    <div>
                        <h4 style="margin:0 0 8px;">Top Query Clusters (28d)</h4>
                        <table class="widefat striped" id="aegisseo_ops_clusters">
                            <thead><tr><th>Cluster</th><th>Impr</th><th>CTR</th></tr></thead>
                            <tbody>
                            <?php foreach ((array)($data['clusters'] ?? array()) as $c): ?>
                                <tr>
                                    <td><strong><?php echo esc_html($c['topic'] ?? ''); ?></strong><br><span style="opacity:.75; font-size:12px;"><?php echo esc_html(implode(', ', (array)($c['queries'] ?? array()))); ?></span></td>
                                    <td><?php echo esc_html(aegisseo_num($c['impressions'] ?? 0)); ?></td>
                                    <td><?php echo esc_html(aegisseo_num($c['ctr'] ?? 0)); ?>%</td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <div>
                        <h4 style="margin:0 0 8px;">Content Gaps (high impr, low CTR)</h4>
                        <table class="widefat striped" id="aegisseo_ops_gaps">
                            <thead><tr><th>Query</th><th>Impr</th><th>CTR</th><th>Hint</th></tr></thead>
                            <tbody>
                            <?php foreach ((array)($data['content_gaps'] ?? array()) as $g): ?>
                                <tr>
                                    <td><?php echo esc_html($g['query'] ?? ''); ?></td>
                                    <td><?php echo esc_html(aegisseo_num($g['impressions'] ?? 0)); ?></td>
                                    <td><?php echo esc_html(aegisseo_num($g['ctr'] ?? 0)); ?>%</td>
                                    <td><?php echo esc_html($g['hint'] ?? ''); ?></td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                        <p style="margin:8px 0 0; opacity:.8;">Action: create/expand a page that answers the query, and improve title/meta to raise CTR.</p>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <div class="aegisseo-card" style="padding:14px;">
            <h3 style="margin-top:0;">Core Web Vitals Guidance</h3>
            <?php if (empty($data['cwv_warnings'])): ?>
                <div class="aegisseo-alert aegisseo-alert-success">
					<p>No CWV guidance items detected from WordPress signals.</p>
				</div>
            <?php else: ?>
                <?php foreach ((array)$data['cwv_warnings'] as $w): ?>
					<?php
						$cls = 'aegisseo-alert-info';
						if (($w['level'] ?? '') === 'warning') $cls = 'aegisseo-alert-warn';
						if (($w['level'] ?? '') === 'error') $cls = 'aegisseo-alert-error';
					?>
					<div class="aegisseo-alert <?php echo esc_attr($cls); ?>" style="margin:10px 0 0;">
                        <p><strong><?php echo esc_html($w['title'] ?? ''); ?></strong><br><?php echo esc_html($w['detail'] ?? ''); ?></p>
                    </div>
                <?php endforeach; ?>
                <p style="margin:10px 0 0; opacity:.8;">AegisSEO does not run external speed tests. Use Search Console CWV report (or Site Kit) to validate improvements.</p>
            <?php endif; ?>
        </div>
    </div>

    <script>
        window.AegisSEOOpsData = <?php echo wp_json_encode($data); ?>;
    </script>
	<hr/>
	<h2><?php echo esc_html__('Ops Center Quick Actions', 'aegisseo'); ?></h2>

	<?php
	$plugin = \AegisSEO\Plugin::instance();

	// Pending redirects (disabled = 0 means “not approved / not live”)
	$pending_redirects = array();
	if (isset($plugin->redirects) && $plugin->redirects) {
		$pending_redirects = $plugin->redirects->list(array('enabled' => 0, 'limit' => 10));
	}

	// Posts missing schema type (simple “approve schema” flow)
	$schema_missing = get_posts(array(
		'post_type' => 'any',
		'post_status' => 'publish',
		'posts_per_page' => 10,
		'meta_query' => array(
			array(
				'key' => '_aegisseo_schema_type',
				'compare' => 'NOT EXISTS',
			),
		),
	));
	?>

	<div class="aegisseo-box">
	  <h3><?php echo esc_html__('Approve Pending Redirects', 'aegisseo'); ?></h3>

	  <?php if (empty($pending_redirects)) : ?>
		<p class="aegisseo-help"><?php echo esc_html__('No pending redirects found.', 'aegisseo'); ?></p>
	  <?php else : ?>
		<table class="widefat striped">
		  <thead>
			<tr>
			  <th><?php echo esc_html__('From', 'aegisseo'); ?></th>
			  <th><?php echo esc_html__('To', 'aegisseo'); ?></th>
			  <th><?php echo esc_html__('Action', 'aegisseo'); ?></th>
			</tr>
		  </thead>
		  <tbody>
		  <?php foreach ($pending_redirects as $r) : ?>
			<tr>
			  <td class="aegisseo-mono"><?php echo esc_html($r['source'] ?? ''); ?></td>
			  <td class="aegisseo-mono"><?php echo esc_html($r['target'] ?? ''); ?></td>
			  <td>
				<form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
				  <?php wp_nonce_field('aegisseo_redirect_approve'); ?>
				  <input type="hidden" name="action" value="aegisseo_redirect_approve" />
				  <input type="hidden" name="id" value="<?php echo esc_attr((int)($r['id'] ?? 0)); ?>" />
				  <?php submit_button(__('Approve', 'aegisseo'), 'secondary', 'submit', false); ?>
				</form>
			  </td>
			</tr>
		  <?php endforeach; ?>
		  </tbody>
		</table>
	  <?php endif; ?>
	</div>

	<div class="aegisseo-box">
	  <h3><?php echo esc_html__('Approve Schema (Missing Schema Type)', 'aegisseo'); ?></h3>

	  <?php if (empty($schema_missing)) : ?>
		<p class="aegisseo-help"><?php echo esc_html__('No posts missing schema type found.', 'aegisseo'); ?></p>
	  <?php else : ?>
		<table class="widefat striped">
		  <thead>
			<tr>
			  <th><?php echo esc_html__('Post', 'aegisseo'); ?></th>
			  <th><?php echo esc_html__('Schema Type', 'aegisseo'); ?></th>
			  <th><?php echo esc_html__('Action', 'aegisseo'); ?></th>
			</tr>
		  </thead>
		  <tbody>
		  <?php foreach ($schema_missing as $p) : ?>
			<tr>
			  <td>
				<a href="<?php echo esc_url(get_edit_post_link($p->ID)); ?>">
				  <?php echo esc_html(get_the_title($p->ID)); ?>
				</a>
			  </td>
			  <td>
				<form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
				  <?php wp_nonce_field('aegisseo_schema_approve'); ?>
				  <input type="hidden" name="action" value="aegisseo_schema_approve" />
				  <input type="hidden" name="post_id" value="<?php echo esc_attr((int)$p->ID); ?>" />
				  <select name="schema_type">
					<option value="WebPage">WebPage</option>
					<option value="Article">Article</option>
				  </select>
			  </td>
			  <td>
				  <?php submit_button(__('Approve', 'aegisseo'), 'secondary', 'submit', false); ?>
				</form>
			  </td>
			</tr>
		  <?php endforeach; ?>
		  </tbody>
		</table>
	  <?php endif; ?>
	</div>

	<div class="aegisseo-box">
	  <h3><?php echo esc_html__('Internal Linking Actions', 'aegisseo'); ?></h3>
	  <p class="aegisseo-help">
		<?php echo esc_html__('Use the Issues tab to preview and apply internal linking suggestions (with rollback support once you apply the edits above).', 'aegisseo'); ?>
	  </p>
	  <a class="button button-secondary" href="<?php echo esc_url(admin_url('admin.php?page=aegisseo&tab=issues')); ?>">
		<?php echo esc_html__('Open Internal Linking Suggestions', 'aegisseo'); ?>
	  </a>
	</div>
</div>
