<?php
if (!defined('ABSPATH')) { exit; }
if (!current_user_can('manage_options')) {
    echo '<p>' . esc_html__('Forbidden', 'aegisseo') . '</p>';
    return;
}

$opts = function_exists('aegisseo') ? aegisseo()->options->get_all() : array();
$allowed = $opts['allowed_roles'] ?? array('administrator'=>1);
$roles = wp_roles()->roles;
?>
<h2><?php echo esc_html__('Role Manager', 'aegisseo'); ?></h2>
<p class="description"><?php echo esc_html__('Choose which roles can access AegisSEO settings and SEO tools.', 'aegisseo'); ?></p>

<form method="post" action="options.php">
    <?php settings_fields('aegisseo_settings_group'); ?>
    <table class="form-table" role="presentation">
        <?php foreach ($roles as $key => $role): ?>
            <tr>
                <th scope="row"><?php echo esc_html($role['name']); ?></th>
                <td>
                    <label>
                        <input type="checkbox" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[allowed_roles][<?php echo esc_attr($key); ?>]" value="1"
                            <?php checked(1, (int)($allowed[$key] ?? 0)); ?> />
                        <?php echo esc_html__('Allow', 'aegisseo'); ?>
                    </label>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>
    <?php submit_button(__('Save Role Settings', 'aegisseo')); ?>
</form>
