<?php
if (!defined('ABSPATH')) { exit; }
if (!current_user_can('manage_options')) {
    echo '<p>' . esc_html__('Forbidden', 'aegisseo') . '</p>';
    return;
}

$opts = function_exists('aegisseo') ? aegisseo()->options->get_all() : array();

echo '<h2>' . esc_html__('Google Search Console (Basic Stats)', 'aegisseo') . '</h2>';
echo '<p class="description">' . esc_html__('Optional: connect via Google OAuth (Client ID/Secret) to fetch last 28 days summary.', 'aegisseo') . '</p>';
?>
<form method="post" action="options.php">
    <?php settings_fields('aegisseo_settings_group'); ?>
    <table class="form-table" role="presentation">
        <tr>
            <th scope="row"><?php echo esc_html__('Client ID', 'aegisseo'); ?></th>
            <td><input type="text" class="regular-text" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[gsc_client_id]" value="<?php echo esc_attr($opts['gsc_client_id'] ?? ''); ?>" /></td>
        </tr>
        <tr>
            <th scope="row"><?php echo esc_html__('Client Secret', 'aegisseo'); ?></th>
            <td><input type="text" class="regular-text" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[gsc_client_secret]" value="<?php echo esc_attr($opts['gsc_client_secret'] ?? ''); ?>" /></td>
        </tr>
        <tr>
            <th scope="row"><?php echo esc_html__('Property URL', 'aegisseo'); ?></th>
            <td><input type="text" class="regular-text" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[gsc_property]" value="<?php echo esc_attr($opts['gsc_property'] ?? ''); ?>" placeholder="https://example.com/" /></td>
        </tr>
    </table>
    <?php submit_button(__('Save', 'aegisseo')); ?>
</form>
<?php
if (!empty($opts['gsc_client_id'])) {
    $redirect = admin_url('admin.php?page=aegisseo&tab=search');
    $auth_url = 'https://accounts.google.com/o/oauth2/v2/auth?response_type=code'
        . '&client_id=' . urlencode($opts['gsc_client_id'])
        . '&redirect_uri=' . urlencode($redirect)
        . '&scope=' . urlencode('https://www.googleapis.com/auth/webmasters.readonly')
        . '&access_type=offline&prompt=consent';
    echo '<p><a class="button button-primary" href="' . esc_url($auth_url) . '">' . esc_html__('Connect Google Account', 'aegisseo') . '</a></p>';
}

if (!empty($opts['gsc_refresh_token']) && !empty($opts['gsc_property']) && function_exists('aegisseo')) {
    $stats = aegisseo()->gsc->fetch_summary($opts['gsc_property']);
    if (is_wp_error($stats)) {
        echo '<div class="notice notice-error"><p>' . esc_html($stats->get_error_message()) . '</p></div>';
    } else {
        echo '<h3>' . esc_html__('Last 28 days', 'aegisseo') . '</h3>';
        echo '<table class="widefat striped"><tbody>';
        echo '<tr><th>' . esc_html__('Clicks', 'aegisseo') . '</th><td>' . esc_html($stats['clicks']) . '</td></tr>';
        echo '<tr><th>' . esc_html__('Impressions', 'aegisseo') . '</th><td>' . esc_html($stats['impressions']) . '</td></tr>';
        echo '<tr><th>' . esc_html__('CTR', 'aegisseo') . '</th><td>' . esc_html($stats['ctr']) . '%</td></tr>';
        echo '<tr><th>' . esc_html__('Avg Position', 'aegisseo') . '</th><td>' . esc_html($stats['position']) . '</td></tr>';
        echo '</tbody></table>';
    }
}
