<?php
if (!defined('ABSPATH')) { exit; }

$opts = aegisseo()->options->get_all();

$edit_id = isset($_GET['edit']) ? absint($_GET['edit']) : 0;
$from404 = isset($_GET['from404']) ? sanitize_text_field(wp_unslash($_GET['from404'])) : '';

$editing = null;
if ($edit_id > 0) {
    $editing = aegisseo()->redirects->get($edit_id);
}

$source_val = '';
$target_val = '';
$match_type_val = 'exact';
$status_val = 301;
$enabled_val = 1;

if ($editing) {
    $source_val = $editing['source'];
    $target_val = $editing['target'];
    $match_type_val = $editing['match_type'];
    $status_val = (int)$editing['status_code'];
    $enabled_val = (int)$editing['enabled'];
} elseif ($from404 !== '') {
    $source_val = $from404;
}

$list = aegisseo()->redirects->list(array('limit' => 100));
?>

<div class="aegisseo-card">
    <h2><?php echo esc_html__('Redirect Manager', 'aegisseo'); ?></h2>
    <p class="description">
        <?php echo esc_html__('Create 301/302/307/410/451 redirects. Supports exact and regex matching. You can also create a redirect directly from a 404 row.', 'aegisseo'); ?>
    </p>

    <?php if (isset($_GET['saved'])): ?>
        <div class="notice notice-success inline"><p><?php echo esc_html__('Redirect saved.', 'aegisseo'); ?></p></div>
    <?php endif; ?>
    <?php if (isset($_GET['deleted'])): ?>
        <div class="notice notice-success inline"><p><?php echo esc_html__('Redirect deleted.', 'aegisseo'); ?></p></div>
    <?php endif; ?>
    <?php if (isset($_GET['error'])): ?>
        <div class="notice notice-error inline"><p><?php echo esc_html(urldecode($_GET['error'])); ?></p></div>
    <?php endif; ?>

    <h3 style="margin-top: 18px;"><?php echo $editing ? esc_html__('Edit Redirect', 'aegisseo') : esc_html__('Add Redirect', 'aegisseo'); ?></h3>

    <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" class="aegisseo-form">
        <?php wp_nonce_field('aegisseo_redirect_save'); ?>
        <input type="hidden" name="action" value="aegisseo_redirect_save" />
        <input type="hidden" name="id" value="<?php echo esc_attr($edit_id); ?>" />

        <table class="form-table" role="presentation">
            <tr>
                <th scope="row"><label for="aegisseo_source"><?php echo esc_html__('Source', 'aegisseo'); ?></label></th>
                <td>
                    <input id="aegisseo_source" type="text" name="source" class="regular-text" value="<?php echo esc_attr($source_val); ?>" placeholder="/old-page/" />
                    <p class="description"><?php echo esc_html__('Exact: enter a path like /old-page/. Regex: enter a full pattern with delimiters, e.g. #^/old/(.*)$#', 'aegisseo'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="aegisseo_target"><?php echo esc_html__('Target', 'aegisseo'); ?></label></th>
                <td>
                    <input id="aegisseo_target" type="text" name="target" class="regular-text" value="<?php echo esc_attr($target_val); ?>" placeholder="/new-page/" />
                    <p class="description"><?php echo esc_html__('For regex redirects, you may use backrefs like $1 in the target.', 'aegisseo'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row"><?php echo esc_html__('Match Type', 'aegisseo'); ?></th>
                <td>
                    <label><input type="radio" name="match_type" value="exact" <?php checked($match_type_val, 'exact'); ?> /> <?php echo esc_html__('Exact', 'aegisseo'); ?></label>
                    &nbsp;&nbsp;
                    <label><input type="radio" name="match_type" value="regex" <?php checked($match_type_val, 'regex'); ?> /> <?php echo esc_html__('Regex (Advanced)', 'aegisseo'); ?></label>
                </td>
            </tr>
            <tr>
                <th scope="row"><?php echo esc_html__('Redirect Type', 'aegisseo'); ?></th>
                <td>
                    <select name="status_code">
                        <?php foreach (array(301,302,307,410,451) as $sc): ?>
                            <option value="<?php echo esc_attr($sc); ?>" <?php selected($status_val, $sc); ?>><?php echo esc_html($sc); ?></option>
                        <?php endforeach; ?>
                    </select>
                    <p class="description"><?php echo esc_html__('301=Permanent, 302/307=Temporary, 410=Gone, 451=Unavailable for Legal Reasons', 'aegisseo'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row"><?php echo esc_html__('Enabled', 'aegisseo'); ?></th>
                <td>
                    <label><input type="checkbox" name="enabled" value="1" <?php checked($enabled_val, 1); ?> /> <?php echo esc_html__('Active', 'aegisseo'); ?></label>
                </td>
            </tr>
        </table>

        <p>
            <button class="button button-primary"><?php echo esc_html__('Save Redirect', 'aegisseo'); ?></button>
            <?php if ($editing): ?>
                <a class="button button-secondary" href="<?php echo esc_url(admin_url('admin.php?page=aegisseo&tab=redirects')); ?>"><?php echo esc_html__('Cancel', 'aegisseo'); ?></a>
            <?php endif; ?>
        </p>
    </form>

    <h3 style="margin-top: 24px;"><?php echo esc_html__('Existing Redirects', 'aegisseo'); ?></h3>

    <table class="widefat striped">
        <thead>
            <tr>
                <th><?php echo esc_html__('Source', 'aegisseo'); ?></th>
                <th><?php echo esc_html__('Target', 'aegisseo'); ?></th>
                <th style="width:90px;"><?php echo esc_html__('Type', 'aegisseo'); ?></th>
                <th style="width:70px;"><?php echo esc_html__('Status', 'aegisseo'); ?></th>
                <th style="width:80px;"><?php echo esc_html__('Enabled', 'aegisseo'); ?></th>
                <th style="width:140px;"><?php echo esc_html__('Actions', 'aegisseo'); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($list)): ?>
                <tr><td colspan="6"><?php echo esc_html__('No redirects yet.', 'aegisseo'); ?></td></tr>
            <?php else: ?>
                <?php foreach ($list as $r): ?>
                    <tr>
                        <td><code><?php echo esc_html($r['source']); ?></code>
                            <?php if (!empty($r['is_suggestion']) && (int)$r['is_suggestion'] === 1): ?>
                                <span class="aegisseo-badge" style="margin-left:6px; padding:2px 6px; border-radius:10px; background:#f6f7f7; border:1px solid #dcdcde; font-size:11px;">
                                    <?php echo esc_html__('Suggestion', 'aegisseo'); ?>: <?php echo esc_html(!empty($r['suggestion_status']) ? $r['suggestion_status'] : ''); ?>
                                </span>
                            <?php endif; ?>
                        </td>
                        <td><code><?php echo esc_html($r['target']); ?></code></td>
                        <td><?php echo esc_html($r['match_type']); ?></td>
                        <td><?php echo esc_html((int)$r['status_code']); ?></td>
                        <td><?php echo ((int)$r['enabled']===1) ? esc_html__('Yes','aegisseo') : esc_html__('No','aegisseo'); ?></td>
                        <td>
                            <a class="button button-small" href="<?php echo esc_url(admin_url('admin.php?page=aegisseo&tab=redirects&edit='.(int)$r['id'])); ?>"><?php echo esc_html__('Edit', 'aegisseo'); ?></a>
                            <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="display:inline;" onsubmit="return confirm('<?php echo esc_js(__('Delete this redirect?', 'aegisseo')); ?>');">
                                <?php wp_nonce_field('aegisseo_redirect_delete'); ?>
                                <input type="hidden" name="action" value="aegisseo_redirect_delete" />
                                <input type="hidden" name="id" value="<?php echo esc_attr((int)$r['id']); ?>" />
                                <button class="button button-small button-secondary" type="submit"><?php echo esc_html__('Delete', 'aegisseo'); ?></button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>
