(function($){
  function escHtml(s){
    return String(s)
      .replace(/&/g,'&amp;')
      .replace(/</g,'&lt;')
      .replace(/>/g,'&gt;')
      .replace(/"/g,'&quot;')
      .replace(/'/g,'&#039;');
  }

  function renderTable($tbody, rows){
    $tbody.empty();
    if (!rows || !rows.length){
      $tbody.append('<tr><td colspan="4" style="opacity:.75;">No data available.</td></tr>');
      return;
    }
    rows.forEach(function(r){
      var page = r.page || '';
      var url = page ? '<a href="' + escHtml(page) + '" target="_blank" rel="noopener">' + escHtml(page) + '</a>' : '';
      var dc = (r.delta_clicks !== undefined) ? r.delta_clicks : 0;
      var clicks = (r.clicks !== undefined) ? r.clicks : 0;
      var impr = (r.impressions !== undefined) ? r.impressions : 0;
      var row = '<tr>'+
        '<td style="word-break:break-word;">' + url + '</td>'+
        '<td><strong>' + escHtml(dc) + '</strong></td>'+
        '<td>' + escHtml(clicks) + '</td>'+
        '<td>' + escHtml(impr) + '</td>'+
      '</tr>';
      $tbody.append(row);
    });
  }

  function updateWindow(win){
    var data = window.AegisSEOOpsData || {};
    var wl = (data.winners_losers && data.winners_losers[win]) ? data.winners_losers[win] : null;
    var winners = wl ? (wl.winners || []) : [];
    var losers = wl ? (wl.losers || []) : [];

    renderTable($('#aegisseo_ops_winners tbody'), winners);
    renderTable($('#aegisseo_ops_losers tbody'), losers);
  }

  $(function(){
    if (!$('#aegisseo-ops-center').length) return;
    var $sel = $('#aegisseo_ops_window');
    updateWindow($sel.val() || '28');

    try {
      if (window.Chart && $('#aegisseo_ops_chart').length) {
        var d = (window.AegisSEOOpsData && window.AegisSEOOpsData.timeseries_28) ? window.AegisSEOOpsData.timeseries_28 : [];
        var labels = d.map(function(r){ return r.date; });
        var clicks = d.map(function(r){ return r.clicks; });
        var impr = d.map(function(r){ return r.impressions; });

        var ctx = document.getElementById('aegisseo_ops_chart').getContext('2d');
        new Chart(ctx, {
          type: 'line',
          data: {
            labels: labels,
            datasets: [
              { label: 'Clicks', data: clicks, tension: 0.25 },
              { label: 'Impressions', data: impr, tension: 0.25 }
            ]
          },
          options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
              legend: { display: true }
            },
            scales: {
              x: { ticks: { maxTicksLimit: 8 } }
            }
          }
        });
      }
    } catch(e) {}
    $sel.on('change', function(){
      updateWindow($(this).val());
    });
  });
})(jQuery);
