<?php
namespace AegisSEO\Admin;

if (!defined('ABSPATH')) { exit; }

class Admin_Technical {

    public function __construct() {
        add_action('admin_post_aegisseo_404_export', array($this, 'export_404'));
        add_action('admin_post_aegisseo_404_clear', array($this, 'clear_404'));
        add_action('admin_post_aegisseo_404_prune', array($this, 'prune_404'));

        add_action('admin_post_aegisseo_redirect_save', array($this, 'save_redirect'));
        add_action('admin_post_aegisseo_redirect_delete', array($this, 'delete_redirect'));

        add_action('admin_post_aegisseo_save_advanced', array($this, 'save_advanced'));

        add_action('admin_post_aegisseo_htaccess_apply', array($this, 'apply_htaccess'));
        add_action('admin_post_aegisseo_htaccess_restore', array($this, 'restore_htaccess'));
    }

    public function export_404() {
        if (!current_user_can('manage_options')) { wp_die('Forbidden'); }
        check_admin_referer('aegisseo_404_export');

        aegisseo()->monitor404->export_csv();
    }

    public function clear_404() {
        if (!current_user_can('manage_options')) { wp_die('Forbidden'); }
        check_admin_referer('aegisseo_404_clear');

        aegisseo()->monitor404->clear_all();

        wp_safe_redirect(admin_url('admin.php?page=aegisseo&tab=404&cleared=1'));
        exit;
    }

    public function prune_404() {
        if (!current_user_can('manage_options')) { wp_die('Forbidden'); }
        check_admin_referer('aegisseo_404_prune');

        $deleted = (int) aegisseo()->monitor404->prune();
        wp_safe_redirect(admin_url('admin.php?page=aegisseo&tab=404&pruned=' . $deleted));
        exit;
    }

    public function save_redirect() {
        if (!current_user_can('manage_options')) { wp_die('Forbidden'); }
        check_admin_referer('aegisseo_redirect_save');

        $data = array(
            'id' => isset($_POST['id']) ? absint($_POST['id']) : 0,
            'source' => isset($_POST['source']) ? wp_unslash($_POST['source']) : '',
            'target' => isset($_POST['target']) ? wp_unslash($_POST['target']) : '',
            'match_type' => isset($_POST['match_type']) ? sanitize_key($_POST['match_type']) : 'exact',
            'status_code' => isset($_POST['status_code']) ? absint($_POST['status_code']) : 301,
            'enabled' => isset($_POST['enabled']) ? 1 : 0,
        );

        $res = aegisseo()->redirects->upsert($data);

        if (is_wp_error($res)) {
            $msg = rawurlencode($res->get_error_message());
            wp_safe_redirect(admin_url('admin.php?page=aegisseo&tab=redirects&error=' . $msg));
            exit;
        }

        wp_safe_redirect(admin_url('admin.php?page=aegisseo&tab=redirects&saved=1'));
        exit;
    }

    public function delete_redirect() {
        if (!current_user_can('manage_options')) { wp_die('Forbidden'); }
        check_admin_referer('aegisseo_redirect_delete');

        $id = isset($_POST['id']) ? absint($_POST['id']) : 0;
        if ($id > 0) {
            aegisseo()->redirects->delete($id);
        }

        wp_safe_redirect(admin_url('admin.php?page=aegisseo&tab=redirects&deleted=1'));
        exit;
    }

    public function save_advanced() {
        if (!current_user_can('manage_options')) { wp_die('Forbidden'); }
        check_admin_referer('aegisseo_save_advanced');

        $opts = aegisseo()->options->get_all();

        $opts['monitor_404_enabled'] = isset($_POST['monitor_404_enabled']) ? 1 : 0;
        $opts['monitor_404_retention_days'] = isset($_POST['monitor_404_retention_days']) ? absint($_POST['monitor_404_retention_days']) : 30;
        $opts['monitor_404_max_rows'] = isset($_POST['monitor_404_max_rows']) ? absint($_POST['monitor_404_max_rows']) : 5000;

        $opts['redirects_enabled'] = isset($_POST['redirects_enabled']) ? 1 : 0;

        $opts['breadcrumbs_enabled'] = isset($_POST['breadcrumbs_enabled']) ? 1 : 0;
        $opts['breadcrumbs_sep'] = isset($_POST['breadcrumbs_sep']) ? sanitize_text_field(wp_unslash($_POST['breadcrumbs_sep'])) : '›';

        $opts['robots_custom_enabled'] = isset($_POST['robots_custom_enabled']) ? 1 : 0;
        $opts['robots_custom_rules'] = isset($_POST['robots_custom_rules']) ? wp_kses_post(wp_unslash($_POST['robots_custom_rules'])) : '';

        $opts['htaccess_helper_enabled'] = isset($_POST['htaccess_helper_enabled']) ? 1 : 0;
        $opts['htaccess_force_https'] = isset($_POST['htaccess_force_https']) ? 1 : 0;

        $force_www = 0;
        if (isset($_POST['htaccess_force_www']) && $_POST['htaccess_force_www'] === 'www') { $force_www = 1; }
        if (isset($_POST['htaccess_force_www']) && $_POST['htaccess_force_www'] === 'nonwww') { $force_www = -1; }
        $opts['htaccess_force_www'] = $force_www;

        $opts['htaccess_trailing_slash'] = isset($_POST['htaccess_trailing_slash']) ? 1 : 0;

        update_option(\AegisSEO\Utils\Options::OPTION_KEY, $opts, false);

        wp_safe_redirect(admin_url('admin.php?page=aegisseo&tab=advanced&saved=1'));
        exit;
    }

    public function apply_htaccess() {
        if (!current_user_can('manage_options')) { wp_die('Forbidden'); }
        check_admin_referer('aegisseo_htaccess_apply');

        $res = aegisseo()->htaccess->apply();
        if (is_wp_error($res)) {
            wp_safe_redirect(admin_url('admin.php?page=aegisseo&tab=advanced&htaccess_error=' . rawurlencode($res->get_error_message())));
            exit;
        }

        wp_safe_redirect(admin_url('admin.php?page=aegisseo&tab=advanced&htaccess_applied=1'));
        exit;
    }

    public function restore_htaccess() {
        if (!current_user_can('manage_options')) { wp_die('Forbidden'); }
        check_admin_referer('aegisseo_htaccess_restore');

        $res = aegisseo()->htaccess->restore_latest_backup();
        if (is_wp_error($res)) {
            wp_safe_redirect(admin_url('admin.php?page=aegisseo&tab=advanced&htaccess_error=' . rawurlencode($res->get_error_message())));
            exit;
        }

        wp_safe_redirect(admin_url('admin.php?page=aegisseo&tab=advanced&htaccess_restored=1'));
        exit;
    }
}
