<?php
namespace AegisSEO\SEO;

use AegisSEO\Utils\Sanitize;

if (!defined('ABSPATH')) { exit; }

class Meta {

    public function __construct() {
        add_action('init', array($this, 'register_meta'));
    }

    public function register_meta() {
        $post_types = get_post_types(array('public' => true), 'names');
        foreach ($post_types as $pt) {
            $this->register_for_type($pt);
        }
    }

    private function register_for_type($post_type) {
        // Core SEO fields
        register_post_meta($post_type, '_aegisseo_title', array(
            'type'              => 'string',
            'single'            => true,
            'show_in_rest'      => true,
            'sanitize_callback' => function($value) { return Sanitize::text($value, 300); },
            'auth_callback'     => function() { return current_user_can('edit_posts'); },
        ));
        register_post_meta($post_type, '_aegisseo_description', array(
            'type'              => 'string',
            'single'            => true,
            'show_in_rest'      => true,
            'sanitize_callback' => function($value) { return Sanitize::text($value, 1000); },
            'auth_callback'     => function() { return current_user_can('edit_posts'); },
        ));
        register_post_meta($post_type, '_aegisseo_canonical', array(
            'type'              => 'string',
            'single'            => true,
            'show_in_rest'      => true,
            'sanitize_callback' => function($value) { return Sanitize::url($value, 500); },
            'auth_callback'     => function() { return current_user_can('edit_posts'); },
        ));
        register_post_meta($post_type, '_aegisseo_noindex', array(
            'type'              => 'integer',
            'single'            => true,
            'show_in_rest'      => true,
            'sanitize_callback' => function($value) { return (int) (!empty($value)); },
            'auth_callback'     => function() { return current_user_can('edit_posts'); },
        ));
        register_post_meta($post_type, '_aegisseo_nofollow', array(
            'type'              => 'integer',
            'single'            => true,
            'show_in_rest'      => true,
            'sanitize_callback' => function($value) { return (int) (!empty($value)); },
            'auth_callback'     => function() { return current_user_can('edit_posts'); },
        ));

        register_post_meta($post_type, '_aegisseo_og_title', array(
            'type'              => 'string',
            'single'            => true,
            'show_in_rest'      => true,
            'sanitize_callback' => function($value) { return Sanitize::text($value, 300); },
            'auth_callback'     => function() { return current_user_can('edit_posts'); },
        ));
        register_post_meta($post_type, '_aegisseo_og_description', array(
            'type'              => 'string',
            'single'            => true,
            'show_in_rest'      => true,
            'sanitize_callback' => function($value) { return Sanitize::text($value, 1000); },
            'auth_callback'     => function() { return current_user_can('edit_posts'); },
        ));
        register_post_meta($post_type, '_aegisseo_og_image', array(
            'type'              => 'string',
            'single'            => true,
            'show_in_rest'      => true,
            'sanitize_callback' => function($value) { return Sanitize::url($value, 500); },
            'auth_callback'     => function() { return current_user_can('edit_posts'); },
        ));
        register_post_meta($post_type, '_aegisseo_twitter_title', array(
            'type'              => 'string',
            'single'            => true,
            'show_in_rest'      => true,
            'sanitize_callback' => function($value) { return Sanitize::text($value, 300); },
            'auth_callback'     => function() { return current_user_can('edit_posts'); },
        ));
        register_post_meta($post_type, '_aegisseo_twitter_description', array(
            'type'              => 'string',
            'single'            => true,
            'show_in_rest'      => true,
            'sanitize_callback' => function($value) { return Sanitize::text($value, 1000); },
            'auth_callback'     => function() { return current_user_can('edit_posts'); },
        ));
        register_post_meta($post_type, '_aegisseo_twitter_image', array(
            'type'              => 'string',
            'single'            => true,
            'show_in_rest'      => true,
            'sanitize_callback' => function($value) { return Sanitize::url($value, 500); },
            'auth_callback'     => function() { return current_user_can('edit_posts'); },
        ));
    }
}
