<?php
if (!defined('ABSPATH')) { exit; }

if (!current_user_can('manage_options')) { return; }

$notice = array('type' => '', 'message' => '');

$license_key   = '';
$license_email = '';
$status        = array();
$free_optin  = (int) get_option('aegisseo_free_reg_optin', 0);
$free_status = (string) get_option('aegisseo_free_reg_status', 'unregistered');

function aegisseo_clm_post(string $endpoint, array $body): array {
    $args = array(
        'timeout' => 20,
        'headers' => array('Content-Type' => 'application/json'),
        'body'    => wp_json_encode($body),
    );

    $resp = wp_remote_post($endpoint, $args);

    if (is_wp_error($resp)) {
        return array('success' => false, 'message' => $resp->get_error_message());
    }

    $code = (int) wp_remote_retrieve_response_code($resp);
    $raw  = (string) wp_remote_retrieve_body($resp);
    $data = json_decode($raw, true);

    if (!is_array($data)) {
        return array(
            'success' => false,
            'message' => 'Invalid response from license server.',
            'http_code' => $code,
            'raw' => $raw,
        );
    }

    if (!isset($data['success'])) {
        $data['success'] = ($code >= 200 && $code < 300);
    }

    return $data;
}

// ------------------------------------------------------------
// PRO Licensing actions (Activate / Deactivate / Check Status)
// ------------------------------------------------------------
if (
    $_SERVER['REQUEST_METHOD'] === 'POST'
    && isset($_POST['aegisseo_license_action'])
    && (
        isset($_POST['aegisseo_activate_license'])
        || isset($_POST['aegisseo_deactivate_license'])
        || isset($_POST['aegisseo_check_license'])
    )
) {
    check_admin_referer('aegisseo_license_action');

    $posted_key   = isset($_POST['license_key']) ? sanitize_text_field(wp_unslash($_POST['license_key'])) : '';
    $posted_email = isset($_POST['license_email']) ? sanitize_email(wp_unslash($_POST['license_email'])) : '';

    // Always persist the latest user-entered values.
    if (function_exists('aegisseo') && isset(aegisseo()->license) && aegisseo()->license) {
        if (method_exists(aegisseo()->license, 'set_key')) {
            aegisseo()->license->set_key($posted_key);
        } else {
            update_option('aegisseo_license_key', trim($posted_key), false);
        }
        if (method_exists(aegisseo()->license, 'set_email')) {
            aegisseo()->license->set_email($posted_email);
        } else {
            update_option('aegisseo_license_email', trim($posted_email), false);
        }
    } else {
        update_option('aegisseo_license_key', trim($posted_key), false);
        update_option('aegisseo_license_email', trim($posted_email), false);
    }

    $site_url = home_url();
    $domain   = wp_parse_url($site_url, PHP_URL_HOST);

    // If PRO is being managed, ensure Free-register never "wins".
    delete_transient('aegisseo_clm_free_reg_sent');

    // Activate
    if (isset($_POST['aegisseo_activate_license'])) {
        if ($posted_key === '' || $posted_email === '') {
            $notice['type']    = 'error';
            $notice['message'] = __('Please enter both License Key and License Email.', 'aegisseo');
        } else {
            $payload = array(
                'slug'        => defined('AEGISSEO_SLUG') ? AEGISSEO_SLUG : 'aegisseo',
                'product'     => defined('AEGISSEO_SLUG') ? AEGISSEO_SLUG : 'aegisseo',
                'version'     => defined('AEGISSEO_VERSION') ? AEGISSEO_VERSION : '',
                'domain'      => (string) $domain,
                'site_url'    => (string) $site_url,
                'license_key' => (string) $posted_key,
                'email'       => (string) $posted_email,
                'wp_version'  => (string) get_bloginfo('version'),
                'php_version' => (string) PHP_VERSION,
            );

            $resp = aegisseo_clm_post(defined('AEGISSEO_CLM_ACTIVATE_ENDPOINT') ? AEGISSEO_CLM_ACTIVATE_ENDPOINT : '', $payload);

            if (!empty($resp['success'])) {
                // A successful PRO activation should supersede any Free-install registration.
                update_option('aegisseo_free_reg_optin', 0);
                update_option('aegisseo_free_reg_status', 'unregistered');

                if (function_exists('aegisseo') && isset(aegisseo()->license) && aegisseo()->license && method_exists(aegisseo()->license, 'check_now')) {
                    $status = (array) aegisseo()->license->check_now(defined('AEGISSEO_VERSION') ? AEGISSEO_VERSION : '');
                }
                $notice['type']    = 'success';
                $notice['message'] = __('License activated successfully.', 'aegisseo');
            } else {
                $notice['type']    = 'error';
                $notice['message'] = !empty($resp['message']) ? (string) $resp['message'] : __('License activation failed.', 'aegisseo');
            }
        }
    }

    // Deactivate
    if (isset($_POST['aegisseo_deactivate_license'])) {
        $payload = array(
            'slug'        => defined('AEGISSEO_SLUG') ? AEGISSEO_SLUG : 'aegisseo',
            'product'     => defined('AEGISSEO_SLUG') ? AEGISSEO_SLUG : 'aegisseo',
            'version'     => defined('AEGISSEO_VERSION') ? AEGISSEO_VERSION : '',
            'domain'      => (string) $domain,
            'site_url'    => (string) $site_url,
            'license_key' => (string) $posted_key,
            'email'       => (string) $posted_email,
        );

        $resp = aegisseo_clm_post(defined('AEGISSEO_CLM_DEACTIVATE_ENDPOINT') ? AEGISSEO_CLM_DEACTIVATE_ENDPOINT : '', $payload);

        // Even if remote deactivation fails, locally clear cached status so UI doesn't lie.
        update_option('aegisseo_license_key', '', false);
        update_option('aegisseo_license_email', '', false);
        delete_transient('aegisseo_license_status');

        $notice['type']    = !empty($resp['success']) ? 'success' : 'warning';
        $notice['message'] = !empty($resp['success']) ? __('License deactivated.', 'aegisseo') : __('Deactivated locally. Remote deactivation may have failed.', 'aegisseo');
    }

    // Check Status
    if (isset($_POST['aegisseo_check_license'])) {
        if (function_exists('aegisseo') && isset(aegisseo()->license) && aegisseo()->license && method_exists(aegisseo()->license, 'check_now')) {
            $status = (array) aegisseo()->license->check_now(defined('AEGISSEO_VERSION') ? AEGISSEO_VERSION : '');
        }
        $notice['type']    = 'success';
        $notice['message'] = __('License status refreshed.', 'aegisseo');
    }

    // Refresh local state variables for immediate render
    $free_optin  = (int) get_option('aegisseo_free_reg_optin', 0);
    $free_status = (string) get_option('aegisseo_free_reg_status', 'unregistered');
}

if (function_exists('aegisseo') && isset(aegisseo()->license) && aegisseo()->license) {
    if (method_exists(aegisseo()->license, 'get_key')) {
        $license_key = (string) aegisseo()->license->get_key();
    } else {
        $license_key = (string) get_option('aegisseo_license_key', '');
    }

    if (method_exists(aegisseo()->license, 'get_email')) {
        $license_email = (string) aegisseo()->license->get_email();
    } else {
        $license_email = (string) get_option('aegisseo_license_email', '');
    }

    if (method_exists(aegisseo()->license, 'get_cached_status')) {
        $status = (array) aegisseo()->license->get_cached_status();
    }
} else {
    $license_key   = (string) get_option('aegisseo_license_key', '');
    $license_email = (string) get_option('aegisseo_license_email', '');
    $status        = (array) get_option('aegisseo_license_status_cache', array());
}

if (isset($_POST['aegisseo_register_free_install'])) {

    // Free-register is ONLY for FREE installs. Never run it if a license key is present or PRO is active.
    $has_key = (string) get_option('aegisseo_license_key', '') !== '';
    $has_pro = (function_exists('aegisseo') && isset(aegisseo()->license) && aegisseo()->license && method_exists(aegisseo()->license, 'is_pro'))
        ? (bool) aegisseo()->license->is_pro()
        : false;

    if ($has_key || $has_pro) {
        $notice['type']    = 'warning';
        $notice['message'] = __('Free-install registration is for FREE installs only. It is disabled when a PRO license is configured.', 'aegisseo');
    } else {

    $consent = isset($_POST['aegisseo_free_reg_consent']) && $_POST['aegisseo_free_reg_consent'] === '1';

    if (!$consent) {
        $notice['type']    = 'error';
        $notice['message'] = __('Please confirm consent before registering this installation.', 'aegisseo');
    } else {

        // Persist consent so checkbox remains checked after submit/refresh
        update_option('aegisseo_free_reg_optin', 1);

        // Call CLM and only mark as registered if we got a real success
        $ok = false;

        if (function_exists('aegisseo_clm_register_free_install')) {
            // We will update this function in AegisSEO/aegisseo.php to return array status
            $resp = aegisseo_clm_register_free_install(true);

            if (is_array($resp) && !empty($resp['success'])) {
                $ok = true;
            }
        }

        if ($ok) {
            update_option('aegisseo_free_reg_status', 'registered');
            $notice['type']    = 'success';
            $notice['message'] = __('Registered successfully with Aegisify.', 'aegisseo');
        } else {
            update_option('aegisseo_free_reg_status', 'error');
            $notice['type']    = 'error';
            $notice['message'] = __('Registration failed. Please try again. Check debug log / aegisseo.log for details.', 'aegisseo');
        }

        // Refresh local state variables for immediate render
        $free_optin  = (int) get_option('aegisseo_free_reg_optin', 0);
        $free_status = (string) get_option('aegisseo_free_reg_status', 'unregistered');
    }

    }
}

if (isset($_POST['aegisseo_unregister_free_install'])) {

    update_option('aegisseo_free_reg_optin', 0);
    update_option('aegisseo_free_reg_status', 'unregistered');

    $notice['type']    = 'success';
    $notice['message'] = __('Free-install registration set to Unregistered.', 'aegisseo');

    $free_optin  = (int) get_option('aegisseo_free_reg_optin', 0);
    $free_status = (string) get_option('aegisseo_free_reg_status', 'unregistered');
}


$is_pro = false;
if (function_exists('aegisseo') && isset(aegisseo()->license) && aegisseo()->license && method_exists(aegisseo()->license, 'is_pro')) {
    $is_pro = (bool) aegisseo()->license->is_pro();
} elseif (!empty($status['is_pro'])) {
    $is_pro = true;
}

?>
<div class="aegisseo-card">
    <h2><?php echo esc_html__('License', 'aegisseo'); ?></h2>

    <?php if (!empty($notice['message'])): ?>
        <div class="notice notice-<?php echo esc_attr($notice['type']); ?> is-dismissible">
            <p><?php echo esc_html($notice['message']); ?></p>
        </div>
    <?php endif; ?>

    <div style="margin:10px 0 14px;color:#50575e;font-size:13px;">
        <?php echo esc_html__('Enter your license key and the email used at checkout. Activate to unlock PRO features and updates.', 'aegisseo'); ?>
    </div>

    <form method="post">
        <?php wp_nonce_field('aegisseo_license_action'); ?>
        <input type="hidden" name="aegisseo_license_action" value="1" />

        <table class="form-table" role="presentation">
            <tbody>
                <tr>
                    <th scope="row">
                        <label for="aegisseo_license_key"><?php echo esc_html__('License Key', 'aegisseo'); ?></label>
                    </th>
                    <td>
                        <input type="text"
                               id="aegisseo_license_key"
                               name="license_key"
                               class="regular-text"
                               style="width:420px;"
                               value="<?php echo esc_attr($license_key); ?>"
                               autocomplete="off" />
                    </td>
                </tr>

                <tr>
                    <th scope="row">
                        <label for="aegisseo_license_email"><?php echo esc_html__('License Email', 'aegisseo'); ?></label>
                    </th>
                    <td>
                        <input type="email"
                               id="aegisseo_license_email"
                               name="license_email"
                               class="regular-text"
                               style="width:420px;"
                               value="<?php echo esc_attr($license_email); ?>"
                               autocomplete="email" />
                    </td>
                </tr>
            </tbody>
        </table>

		<p>
			<button type="submit" class="button button-primary" name="aegisseo_activate_license" value="1">
				<?php echo esc_html__('Activate License', 'aegisseo'); ?>
			</button>

			<?php
			$confirm = esc_js(__('Deactivate this license on this site?', 'aegisseo'));
			?>
			<button type="submit"
					class="button"
					name="aegisseo_deactivate_license"
					value="1"
					onclick="return confirm('<?php echo $confirm; ?>');">
				<?php echo esc_html__('Deactivate', 'aegisseo'); ?>
			</button>

			<button type="submit" class="button button-secondary" name="aegisseo_check_license" value="1">
				<?php echo esc_html__('Check Status', 'aegisseo'); ?>
			</button>
		</p>

		<hr style="margin:18px 0;" />

		<h3 style="margin:0 0 6px 0;"><?php echo esc_html__('Optional: Register this free installation', 'aegisseo'); ?></h3>

		<p class="description" style="margin:0 0 10px 0;">
			<?php
			echo esc_html__(
				'This is optional and if you want update checks and license-related features through Aegisify, you can register this free installation.  This will send your site domain, site URL, and the WordPress admin email to Aegisify. Your information will never leave our database nor be sold to any 3rd party.',
				'aegisseo'
			);
			?>
		</p>
		<label style="display:block; margin:0 0 10px 0;">
			<input type="checkbox"
				   name="aegisseo_free_reg_consent"
				   value="1"
				   <?php echo ($free_optin === 1) ? 'checked="checked"' : ''; ?> />
			<?php echo esc_html__('I consent to send the data described above to Aegisify.', 'aegisseo'); ?>
		</label>

		<p style="margin:0 0 10px 0;">
			<strong><?php echo esc_html__('Registration Status:', 'aegisseo'); ?></strong>
			<?php if ($free_status === 'registered'): ?>
				<span style="color:#0a7b34; font-weight:600;"><?php echo esc_html__('Registered', 'aegisseo'); ?></span>
			<?php elseif ($free_status === 'error'): ?>
				<span style="color:#b32d2e; font-weight:600;"><?php echo esc_html__('Error', 'aegisseo'); ?></span>
			<?php else: ?>
				<span style="color:#555; font-weight:600;"><?php echo esc_html__('Unregistered', 'aegisseo'); ?></span>
			<?php endif; ?>
		</p>

		<p style="margin:0;">
			<?php if ($free_status !== 'registered'): ?>
				<button type="submit" class="button" name="aegisseo_register_free_install" value="1">
					<?php echo esc_html__('Register Free Installation', 'aegisseo'); ?>
				</button>
			<?php else: ?>
				<button type="submit" class="button" name="aegisseo_unregister_free_install" value="1">
					<?php echo esc_html__('Unregister Free Installation', 'aegisseo'); ?>
				</button>
			<?php endif; ?>
		</p>
    </form>
<hr />
<h4>
    <?php echo esc_html__( 'Create an account on', 'aegisseo' ); ?>
    <a href="<?php echo esc_url( 'https://aegisify.com/register/' ); ?>" target="_blank" rel="noopener noreferrer">
        <?php echo esc_html( 'https://aegisify.com/register/' ); ?>
    </a>
    <?php echo esc_html__( 'and help support Aegisify by buying a license today!', 'aegisseo' ); ?>
</h4>
<hr />

    <h3><?php echo esc_html__('Status', 'aegisseo'); ?></h3>
    <table class="widefat striped">
        <tbody>
            <tr>
                <th><?php echo esc_html__('Tier', 'aegisseo'); ?></th>
                <td><?php echo esc_html($is_pro ? 'PRO' : 'FREE'); ?></td>
            </tr>
            <tr>
                <th><?php echo esc_html__('License Status', 'aegisseo'); ?></th>
                <td><?php echo esc_html((string)($status['status'] ?? '—')); ?></td>
            </tr>
            <tr>
                <th><?php echo esc_html__('Plan', 'aegisseo'); ?></th>
                <td><?php echo esc_html((string)($status['plan'] ?? '—')); ?></td>
            </tr>
            <tr>
                <th><?php echo esc_html__('Expires', 'aegisseo'); ?></th>
                <td><?php echo esc_html((string)($status['expires'] ?? '—')); ?></td>
            </tr>
            <tr>
                <th><?php echo esc_html__('Last Checked', 'aegisseo'); ?></th>
                <td>
                    <?php
                    $checked_at = isset($status['checked_at']) ? (int) $status['checked_at'] : 0;
                    echo esc_html($checked_at ? date_i18n(get_option('date_format') . ' ' . get_option('time_format'), $checked_at) : '—');
                    ?>
                </td>
            </tr>
        </tbody>
    </table>
    </table>

    <hr style="margin:22px 0;" />

    <h2 style="margin:0 0 6px 0;"><?php echo esc_html__('Free vs Pro Comparison Matrix', 'aegisseo'); ?></h2>
    <p class="description" style="margin:0 0 14px 0;">
        <?php echo esc_html__('This matrix reflects the features currently implemented in AegisSEO. PRO-locked tabs require an active PRO license to access.', 'aegisseo'); ?>
    </p>

    <style>
        .aegisseo-matrix-table th, .aegisseo-matrix-table td { vertical-align: top; }
        .aegisseo-matrix-section th { background:#f6f7f7; font-weight:700; }
        .aegisseo-matrix-yes { color:#1d2327; }
        .aegisseo-matrix-no { color:#a7aaad; }
    </style>

    <?php
    $aegisseo_matrix = array(
        array(
            'tab'      => __('Setup Wizard', 'aegisseo'),
            'access'   => array('free' => true, 'pro' => true),
            'features' => array(
                __('Site identity (Organization / Person)', 'aegisseo'),
                __('Organization name / Person name', 'aegisseo'),
                __('Logo attachment selection', 'aegisseo'),
                __('Social profile URLs', 'aegisseo'),
                __('Starter title & meta templates (Home / Posts / Pages)', 'aegisseo'),
                __('Sitemap & social defaults (fast, safe baseline configuration)', 'aegisseo'),
            ),
        ),
        array(
            'tab'      => __('Global SEO', 'aegisseo'),
            'access'   => array('free' => true, 'pro' => true),
            'features' => array(
                __('Title separator', 'aegisseo'),
                __('Title templates: Home / Post / Page / Archive', 'aegisseo'),
                __('Meta description templates: Home / Post / Page', 'aegisseo'),
                __('Global robots defaults (index / follow)', 'aegisseo'),
            ),
        ),
        array(
            'tab'      => __('Social', 'aegisseo'),
            'access'   => array('free' => true, 'pro' => true),
            'features' => array(
                __('Open Graph meta tags (enable/disable)', 'aegisseo'),
                __('Twitter Cards (enable/disable)', 'aegisseo'),
                __('Twitter card type + site/creator handles', 'aegisseo'),
                __('Facebook App ID + Admins', 'aegisseo'),
                __('Default social image fallback', 'aegisseo'),
                __('Social profile URLs field', 'aegisseo'),
                __('Optional article meta for posts', 'aegisseo'),
            ),
        ),
        array(
            'tab'      => __('Schema', 'aegisseo'),
            'access'   => array('free' => true, 'pro' => true),
            'features' => array(
                __('Post Type → Schema default mapping', 'aegisseo'),
                __('Publisher type (Organization / Person)', 'aegisseo'),
                __('Organization name / Person name', 'aegisseo'),
                __('Logo attachment ID', 'aegisseo'),
                __('Per-post schema type + JSON data via metabox', 'aegisseo'),
            ),
        ),
        array(
            'tab'      => __('Sitemap', 'aegisseo'),
            'access'   => array('free' => true, 'pro' => true),
            'features' => array(
                __('XML sitemap generator (index + child maps)', 'aegisseo'),
                __('Sitemap URL helper + index toggle', 'aegisseo'),
                __('Max URLs per child sitemap + paging', 'aegisseo'),
                __('Image inclusion (include images / attached images)', 'aegisseo'),
                __('Optional Video sitemap toggle', 'aegisseo'),
                __('Optional News sitemap toggle', 'aegisseo'),
                __('Optional HTML sitemap toggle', 'aegisseo'),
                __('Last ping status + ping search engines on publish', 'aegisseo'),
                __('Include post types + include taxonomies', 'aegisseo'),
                __('Add sitemap to robots.txt (toggle)', 'aegisseo'),
            ),
        ),
        array(
            'tab'      => __('Aegis Score', 'aegisseo'),
            'access'   => array('free' => true, 'pro' => true),
            'features' => array(
                __('On-page checklist scoring per post (0–100)', 'aegisseo'),
                __('Per-check pass/fail with details', 'aegisseo'),
                __('Uses Focus Phrase field when enabled', 'aegisseo'),
            ),
        ),
        array(
            'tab'      => __('Linking Assistant', 'aegisseo'),
            'access'   => array('free' => true, 'pro' => true),
            'features' => array(
                __('Internal link suggestions for a selected post', 'aegisseo'),
                __('Suggestions based on post title + categories/tags keywords', 'aegisseo'),
            ),
        ),
        array(
            'tab'      => __('Search Console', 'aegisseo'),
            'access'   => array('free' => true, 'pro' => true),
            'features' => array(
                __('OAuth Client ID/Secret settings', 'aegisseo'),
                __('Property URL selection', 'aegisseo'),
                __('Connect flow (stores refresh token)', 'aegisseo'),
                __('Basic stats fetch (last ~28 days summary)', 'aegisseo'),
            ),
        ),
        array(
            'tab'      => __('Local SEO', 'aegisseo'),
            'access'   => array('free' => true, 'pro' => true),
            'features' => array(
                __('LocalBusiness schema toggle', 'aegisseo'),
                __('Business details (type, name, phone, email)', 'aegisseo'),
                __('Address fields + geo coordinates', 'aegisseo'),
                __('Locations post type support', 'aegisseo'),
            ),
        ),
        array(
            'tab'      => __('Role Manager', 'aegisseo'),
            'access'   => array('free' => true, 'pro' => true),
            'features' => array(
                __('Allowlist which WP roles can access AegisSEO pages/tools', 'aegisseo'),
            ),
        ),
        array(
            'tab'      => __('Tools', 'aegisseo'),
            'access'   => array('free' => true, 'pro' => true),
            'features' => array(
                __('Safe Defaults toggle', 'aegisseo'),
                __('Focus Phrase field toggle', 'aegisseo'),
            ),
        ),
        array(
            'tab'      => __('Bulk SEO Manager', 'aegisseo'),
            'access'   => array('free' => true, 'pro' => true),
            'features' => array(
                __('Bulk list + inline edit: SEO Title, Meta Description, Canonical, Noindex, Nofollow', 'aegisseo'),
                __('Filters: thin content (<300 words), no title/description, noindex enabled, duplicate SEO title (site-wide)', 'aegisseo'),
                __('Pagination (25/50/100 per page)', 'aegisseo'),
                __('CSV export + CSV import', 'aegisseo'),
            ),
        ),
        array(
            'tab'      => __('404 Monitor', 'aegisseo'),
            'access'   => array('free' => true, 'pro' => true),
            'features' => array(
                __('Logs 404 URLs (hits, last seen, referrers/user agent where available)', 'aegisseo'),
                __('Filter/search + minimum hits threshold', 'aegisseo'),
                __('Export CSV + prune/clear log tools', 'aegisseo'),
                __('Create a redirect directly from a 404 row', 'aegisseo'),
            ),
        ),
        array(
            'tab'      => __('Redirect Manager', 'aegisseo'),
            'access'   => array('free' => true, 'pro' => true),
            'features' => array(
                __('Create/edit/delete redirects', 'aegisseo'),
                __('Match types: exact + regex', 'aegisseo'),
                __('HTTP codes: 301/302/307/410/451', 'aegisseo'),
                __('Prefill a redirect source from a 404 log row', 'aegisseo'),
            ),
        ),
        array(
            'tab'      => __('Advanced', 'aegisseo'),
            'access'   => array('free' => true, 'pro' => true),
            'features' => array(
                __('Enable/disable 404 Monitor + retention/max rows', 'aegisseo'),
                __('Enable/disable Redirects module', 'aegisseo'),
                __('Breadcrumbs toggle + separator', 'aegisseo'),
                __('robots.txt editor (custom rules)', 'aegisseo'),
                __('Safe-mode .htaccess helper (preview/apply/restore)', 'aegisseo'),
                __('Optional: force HTTPS / force WWW / trailing slash', 'aegisseo'),
            ),
        ),
        array(
            'tab'      => __('License', 'aegisseo'),
            'access'   => array('free' => true, 'pro' => true),
            'features' => array(
                __('Activate / Deactivate / Check Status', 'aegisseo'),
                __('Shows cached license status details (plan, expiry, limits, last check)', 'aegisseo'),
            ),
        ),

        // PRO-locked tabs
        array(
            'tab'      => __('Migration Wizard', 'aegisseo'),
            'access'   => array('free' => false, 'pro' => true),
            'features' => array(
                __('Import SEO title + meta description + canonical', 'aegisseo'),
                __('Import robots flags (noindex / nofollow)', 'aegisseo'),
                __('Import Open Graph & Twitter meta overrides (title/desc/image) from supported plugins', 'aegisseo'),
                __('Import redirects from the Redirection plugin', 'aegisseo'),
            ),
        ),
        array(
            'tab'      => __('SEO Ops Center', 'aegisseo'),
            'access'   => array('free' => false, 'pro' => true),
            'features' => array(
                __('GSC performance dashboard (clicks, impressions, CTR)', 'aegisseo'),
                __('Winners / Losers reporting', 'aegisseo'),
                __('Top queries + pages insights', 'aegisseo'),
                __('Query clusters + content gap detection', 'aegisseo'),
                __('Core Web Vitals guidance (CWV warnings)', 'aegisseo'),
                __('Security summary panel', 'aegisseo'),
            ),
        ),
        array(
            'tab'      => __('Issues & Fixes', 'aegisseo'),
            'access'   => array('free' => false, 'pro' => true),
            'features' => array(
                __('Content/metadata issue detection (e.g., missing meta description override, thin content)', 'aegisseo'),
                __('Schema validation issues surfaced per post', 'aegisseo'),
                __('One-click fix packs (duplicate titles, missing OG image, orphan pages)', 'aegisseo'),
                __('Generate meta descriptions (bulk)', 'aegisseo'),
                __('Schema suggestion approval + apply', 'aegisseo'),
                __('Autopilot: redirect suggestions (approve/dismiss)', 'aegisseo'),
                __('Audit trail + rollback for SEO field changes', 'aegisseo'),
            ),
        ),
        array(
            'tab'      => __('Evidence', 'aegisseo'),
            'access'   => array('free' => false, 'pro' => true),
            'features' => array(
                __('Evidence timeline per URL', 'aegisseo'),
                __('GSC deltas / before-after reporting (when connected)', 'aegisseo'),
                __('Annotations & “why” explanations', 'aegisseo'),
            ),
        ),
    );
    ?>

    <table class="widefat striped aegisseo-matrix-table" style="max-width:1100px;">
        <thead>
            <tr>
                <th style="width:220px;"><?php echo esc_html__('Tab', 'aegisseo'); ?></th>
                <th><?php echo esc_html__('Features', 'aegisseo'); ?></th>
                <th style="width:90px;text-align:center;"><?php echo esc_html__('Free', 'aegisseo'); ?></th>
                <th style="width:90px;text-align:center;"><?php echo esc_html__('Pro', 'aegisseo'); ?></th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($aegisseo_matrix as $section): ?>
            <tr class="aegisseo-matrix-section">
                <th><?php echo esc_html($section['tab']); ?></th>
                <td>
                    <ul style="margin:0; padding-left:18px;">
                        <?php foreach ((array) $section['features'] as $f): ?>
                            <li><?php echo esc_html($f); ?></li>
                        <?php endforeach; ?>
                    </ul>
                </td>
                <td style="text-align:center;">
                    <?php if (!empty($section['access']['free'])): ?>
                        <span class="dashicons dashicons-yes aegisseo-matrix-yes" aria-hidden="true"></span>
                        <span class="screen-reader-text"><?php echo esc_html__('Included', 'aegisseo'); ?></span>
                    <?php else: ?>
                        <span class="dashicons dashicons-no-alt aegisseo-matrix-no" aria-hidden="true"></span>
                        <span class="screen-reader-text"><?php echo esc_html__('Not included', 'aegisseo'); ?></span>
                    <?php endif; ?>
                </td>
                <td style="text-align:center;">
                    <?php if (!empty($section['access']['pro'])): ?>
                        <span class="dashicons dashicons-yes aegisseo-matrix-yes" aria-hidden="true"></span>
                        <span class="screen-reader-text"><?php echo esc_html__('Included', 'aegisseo'); ?></span>
                    <?php else: ?>
                        <span class="dashicons dashicons-no-alt aegisseo-matrix-no" aria-hidden="true"></span>
                        <span class="screen-reader-text"><?php echo esc_html__('Not included', 'aegisseo'); ?></span>
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>

</div>


