<?php
namespace AegisBackup\Admin\Panels\DB_Tools;

use AegisBackup\AB_Plugin;

defined( 'ABSPATH' ) || exit;

class AB_DBTools_Tab_Table_Backups {

    protected $plugin;

    public function __construct( AB_Plugin $plugin ) {
        $this->plugin = $plugin;
    }

    public function render() {
        $uid = function_exists( 'get_current_user_id' ) ? (int) get_current_user_id() : 0;
        $state_key  = 'aegisbackup_tb_state_' . $uid;
        $notice_key = 'aegisbackup_tb_notice_' . $uid;
        $state  = ( $uid > 0 ) ? get_transient( $state_key ) : false;
        $notice = ( $uid > 0 ) ? get_transient( $notice_key ) : false;

        if ( $uid > 0 ) {
            delete_transient( $notice_key );
        }

        $state = is_array( $state ) ? $state : array();
        $selected_db   = isset( $state['db'] ) ? (string) $state['db'] : '';
        $selected_name = isset( $state['name'] ) ? (string) $state['name'] : '';
        $selected_freq = isset( $state['plan_freq'] ) ? (string) $state['plan_freq'] : 'daily';
        $selected_time = isset( $state['plan_time'] ) ? (string) $state['plan_time'] : '02:00';
        $selected_weekdays = ( isset( $state['plan_weekdays'] ) && is_array( $state['plan_weekdays'] ) ) ? $state['plan_weekdays'] : array();
        $selected_monthday = isset( $state['plan_monthday'] ) ? (int) $state['plan_monthday'] : 0;
        $selected_tables = ( isset( $state['tables'] ) && is_array( $state['tables'] ) ) ? $state['tables'] : array();
        $selected_cols_map = ( isset( $state['columns_map'] ) && is_array( $state['columns_map'] ) ) ? $state['columns_map'] : array();
        $show_cols_table = isset( $state['show_cols_table'] ) ? (string) $state['show_cols_table'] : '';

        $mgr = isset( $this->plugin->table_backup ) ? $this->plugin->table_backup : null;
        $dbs = ( $mgr && is_object( $mgr ) && method_exists( $mgr, 'list_databases' ) ) ? (array) $mgr->list_databases() : array();

        $default_db = ! empty( $dbs ) ? (string) $dbs[0] : '';
        if ( '' === $selected_db ) {
            $selected_db = $default_db;
        }

        $tables = ( $mgr && is_object( $mgr ) && method_exists( $mgr, 'list_tables' ) ) ? (array) $mgr->list_tables( $selected_db ) : array();
        $all_tables_selected = ( ! empty( $tables ) && empty( array_diff( $tables, $selected_tables ) ) );

        $is_pro = false;
        if ( isset( $this->plugin ) && isset( $this->plugin->license ) && is_object( $this->plugin->license ) && method_exists( $this->plugin->license, 'is_pro_active' ) ) {
            $is_pro = (bool) $this->plugin->license->is_pro_active();
        }
        $license_url = admin_url( 'admin.php?page=aegisbackup-license' );
        ?>
        <div style="margin-top:12px;">
            <p class="description">
                <?php esc_html_e( 'Create targeted backups for selected tables (and optional column subsets). Each backup is stored as a zip with SQL exports and can be restored later.', 'aegisbackup' ); ?>
            </p>

            <div class="ab-card" style="margin-top:10px;">
                <h3 style="margin-top:0;"><?php esc_html_e( 'Schedule Table Backups', 'aegisbackup' ); ?></h3>

                <form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" id="ab_tb_schedule_form">
                    <input type="hidden" name="action" value="aegisbackup_tablebacks_save_plan_post" />
                    <?php wp_nonce_field( 'aegisbackup_tablebacks_save_plan', 'aegisbackup_nonce' ); ?>
                    <input type="hidden" id="ab_tb_mode" value="post" />

                    <table class="form-table" role="presentation">
                        <tbody>
                            <tr>
                                <th scope="row"><?php esc_html_e( 'Plan Name', 'aegisbackup' ); ?></th>
                                <td>
                                    <input type="text" id="ab_tb_plan_name" name="ab_tb_plan_name" class="regular-text" placeholder="e.g. Nightly Orders Backup" value="<?php echo esc_attr( $selected_name ); ?>" />
                                </td>
                            </tr>
                            <tr>
                                <th scope="row"><?php esc_html_e( 'Frequency', 'aegisbackup' ); ?></th>
                                <td>
                                    <select id="ab_tb_plan_freq" name="ab_tb_plan_freq">
                                        <option value="daily" <?php selected( $selected_freq, 'daily' ); ?>><?php esc_html_e( 'Daily', 'aegisbackup' ); ?></option>
                                        <option value="weekly" <?php selected( $selected_freq, 'weekly' ); ?>><?php esc_html_e( 'Weekly', 'aegisbackup' ); ?></option>
                                        <option value="monthly" <?php selected( $selected_freq, 'monthly' ); ?>><?php esc_html_e( 'Monthly', 'aegisbackup' ); ?></option>
                                    </select>

                                    <span id="ab_tb_plan_weekly" style="<?php echo ( 'weekly' === $selected_freq ) ? '' : 'display:none;'; ?> margin-left:10px;">
                                        <?php
                                        $wd = array(
                                            'mon' => __( 'Mon', 'aegisbackup' ),
                                            'tue' => __( 'Tue', 'aegisbackup' ),
                                            'wed' => __( 'Wed', 'aegisbackup' ),
                                            'thu' => __( 'Thu', 'aegisbackup' ),
                                            'fri' => __( 'Fri', 'aegisbackup' ),
                                            'sat' => __( 'Sat', 'aegisbackup' ),
                                            'sun' => __( 'Sun', 'aegisbackup' ),
                                        );
                                        foreach ( $wd as $k => $lbl ) :
                                            ?>
                                            <label style="margin-right:8px;"><input type="checkbox" name="ab_tb_plan_weekdays[]" value="<?php echo esc_attr( $k ); ?>" <?php checked( in_array( $k, $selected_weekdays, true ) ); ?> /> <?php echo esc_html( $lbl ); ?></label>
                                            <?php
                                        endforeach;
                                        ?>
                                    </span>

                                    <span id="ab_tb_plan_monthly" style="<?php echo ( 'monthly' === $selected_freq ) ? '' : 'display:none;'; ?> margin-left:10px;">
                                        <label>
                                            <?php esc_html_e( 'Day', 'aegisbackup' ); ?>
                                            <select name="ab_tb_plan_monthday" id="ab_tb_plan_monthday" style="margin-left:6px;">
                                                <option value="0"><?php esc_html_e( '—', 'aegisbackup' ); ?></option>
                                                <?php for ( $i = 1; $i <= 31; $i++ ) : ?>
                                                    <option value="<?php echo (int) $i; ?>" <?php selected( $selected_monthday, (int) $i ); ?>><?php echo (int) $i; ?></option>
                                                <?php endfor; ?>
                                            </select>
                                        </label>
                                    </span>

                                    <input type="time" id="ab_tb_plan_time" name="ab_tb_plan_time" value="<?php echo esc_attr( $selected_time ); ?>" style="margin-left:10px;" />
                                </td>
                            </tr>
                            <tr>
                                <th scope="row"><?php esc_html_e( 'Database', 'aegisbackup' ); ?></th>
                                <td>
                                    <select id="ab_tb_plan_db" name="ab_tb_plan_db" style="min-width:420px;">
                                        <?php if ( ! empty( $dbs ) ) : ?>
                                            <?php foreach ( $dbs as $d ) : $d = (string) $d; ?>
                                                <option value="<?php echo esc_attr( $d ); ?>" <?php selected( $selected_db, $d ); ?>><?php echo esc_html( $d ); ?></option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                    <p class="description"><?php esc_html_e( 'If your host allows multiple databases, you can select which one to read tables from.', 'aegisbackup' ); ?></p>
                                </td>
                            </tr>
                            <tr>
                                <th scope="row"><?php esc_html_e( 'Select Tables', 'aegisbackup' ); ?></th>
                                <td>
                                    <p style="margin:0 0 6px 0;">
                                        <label>
                                            <input type="checkbox" id="ab_tb_select_all" value="1" <?php checked( $all_tables_selected ); ?> />
                                            <?php esc_html_e( 'Select all tables', 'aegisbackup' ); ?>
                                        </label>
                                    </p>
                                    <div id="ab_tb_tables" style="max-height:260px; overflow:auto; border:1px solid #dcdcde; background:#fff; padding:10px;">
                                        <?php if ( empty( $tables ) ) : ?>
                                            <em><?php esc_html_e( 'No tables found.', 'aegisbackup' ); ?></em>
                                        <?php else : ?>
                                            <?php foreach ( $tables as $t ) : $t = (string) $t; ?>
                                                <?php
                                                $is_checked = in_array( $t, $selected_tables, true );
                                                $cols_for_table = isset( $selected_cols_map[ $t ] ) && is_array( $selected_cols_map[ $t ] ) ? $selected_cols_map[ $t ] : array();
                                                $show_cols = ( $show_cols_table === $t );
                                                $cols = array();
                                                if ( $show_cols && $mgr && is_object( $mgr ) && method_exists( $mgr, 'list_columns' ) ) {
                                                    $cols = (array) $mgr->list_columns( $selected_db, $t );
                                                }
                                                ?>
                                                <div class="ab-tb-table" style="margin:0 0 8px 0; padding:6px 8px; border:1px solid #eee;">
                                                    <label style="font-weight:600;">
                                                        <input type="checkbox" class="ab_tb_table" name="ab_tb_plan_tables[]" value="<?php echo esc_attr( $t ); ?>" <?php checked( $is_checked ); ?> />
                                                        <?php echo esc_html( $t ); ?>
                                                    </label>
                                                    <button type="button" class="button button-small ab_tb_cols_btn" data-table="<?php echo esc_attr( $t ); ?>" style="margin-left:10px;">
                                                        <?php esc_html_e( 'Columns', 'aegisbackup' ); ?>
                                                    </button>

                                                    <div class="ab_tb_cols" data-table="<?php echo esc_attr( $t ); ?>" style="<?php echo $show_cols ? '' : 'display:none;'; ?> margin-top:6px; padding:6px; background:#fafafa; border:1px dashed #ddd;">
                                                        <?php if ( $show_cols ) : ?>
                                                            <?php if ( empty( $cols ) ) : ?>
                                                                <em><?php esc_html_e( 'No columns found.', 'aegisbackup' ); ?></em>
                                                            <?php else : ?>
                                                                <div style="margin:0 0 6px 0;"><strong><?php esc_html_e( 'Columns', 'aegisbackup' ); ?></strong> <?php esc_html_e( '(optional subset)', 'aegisbackup' ); ?></div>
                                                                <?php foreach ( $cols as $c ) : ?>
                                                                    <?php $cname = isset( $c['name'] ) ? (string) $c['name'] : ''; if ( '' === $cname ) { continue; } ?>
                                                                    <label style="display:inline-block; margin:0 12px 6px 0;">
                                                                        <input type="checkbox" class="ab_tb_col" name="ab_tb_columns[<?php echo esc_attr( $t ); ?>][]" value="<?php echo esc_attr( $cname ); ?>" <?php checked( in_array( $cname, $cols_for_table, true ) ); ?> />
                                                                        <?php echo esc_html( $cname ); ?>
                                                                    </label>
                                                                <?php endforeach; ?>
                                                                <div class="description" style="margin-top:6px;">
                                                                    <?php esc_html_e( 'Selecting columns limits only the INSERT data export. The full table schema is always exported.', 'aegisbackup' ); ?>
                                                                </div>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </div>
                                    <p class="description">
                                        <?php esc_html_e( 'Tip: after selecting a table, you can optionally choose which columns to include in the data export. If no columns are selected, all columns are exported.', 'aegisbackup' ); ?>
                                    </p>
                                </td>
                            </tr>
                        </tbody>
                    </table>

                    <p>
                        <button type="submit" class="button button-primary" id="ab_tb_plan_save" name="ab_tb_submit" value="save" <?php disabled( ! $is_pro ); ?>><?php esc_html_e( 'Save Schedule', 'aegisbackup' ); ?></button>
                        <button type="submit" class="button" id="ab_tb_plan_run_now" name="ab_tb_submit" value="run_now"><?php esc_html_e( 'Run Now', 'aegisbackup' ); ?></button>
                        <?php if ( ! $is_pro ) : ?>
                            <span style="margin-left:10px; color:#b32d2e; font-weight:600;">
                                <?php esc_html_e( 'Scheduling is a PRO feature.', 'aegisbackup' ); ?>
                            </span>
                            <a href="<?php echo esc_url( $license_url ); ?>" class="button" style="margin-left:8px;">
                                <?php esc_html_e( 'Upgrade', 'aegisbackup' ); ?>
                            </a>
                        <?php endif; ?>
                    </p>

                    <pre class="aegisbackup-log" id="ab_tb_log"><?php echo $notice ? esc_html( (string) $notice ) : ''; ?></pre>
                </form>

                <form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" id="ab_tb_cols_form" style="display:none;">
                    <input type="hidden" name="action" value="aegisbackup_tablebacks_post" />
                    <?php wp_nonce_field( 'aegisbackup_tablebacks_post', 'aegisbackup_nonce' ); ?>
                    <input type="hidden" name="ab_tb_db" id="ab_tb_cols_db" value="" />
                    <input type="hidden" name="ab_tb_name" id="ab_tb_cols_name" value="" />
                    <input type="hidden" name="ab_tb_show_columns" id="ab_tb_cols_table" value="" />
                    <div id="ab_tb_cols_payload"></div>
                </form>

                <?php

                ?>
                <script>
                (function(){
                  function q(sel, root){ return (root||document).querySelector(sel); }
                  function qa(sel, root){ return Array.prototype.slice.call((root||document).querySelectorAll(sel)); }
                  function on(el, ev, fn){ if(el){ el.addEventListener(ev, fn, false); } }

                  function syncSelectAll(){
                    var all = qa('#ab_tb_tables .ab_tb_table');
                    var selAll = q('#ab_tb_select_all');
                    if(!selAll || !all.length){ return; }
                    var checked = all.filter(function(x){ return x.checked; }).length;
                    selAll.checked = (checked === all.length);
                  }

                  function toggleAllTables(onState){
                    qa('#ab_tb_tables .ab_tb_table').forEach(function(cb){ cb.checked = !!onState; });
                    syncSelectAll();
                  }

                  function syncFreqUI(){
                    var freq = (q('#ab_tb_plan_freq') && q('#ab_tb_plan_freq').value) ? q('#ab_tb_plan_freq').value : 'daily';
                    var w = q('#ab_tb_plan_weekly');
                    var m = q('#ab_tb_plan_monthly');
                    if(w){ w.style.display = (freq === 'weekly') ? '' : 'none'; }
                    if(m){ m.style.display = (freq === 'monthly') ? '' : 'none'; }
                  }

                  function submitColumnsPost(table){
                    var f = q('#ab_tb_cols_form');
                    if(!f){ return; }
                    var dbSel = q('#ab_tb_plan_db') || q('#ab_tb_db');
                    var nameInp = q('#ab_tb_plan_name') || q('#ab_tb_name');
                    var db = dbSel ? (dbSel.value || '') : '';
                    var nm = nameInp ? (nameInp.value || '') : '';

                    var hDb = q('#ab_tb_cols_db');
                    var hNm = q('#ab_tb_cols_name');
                    var hTbl = q('#ab_tb_cols_table');
                    if(hDb){ hDb.value = db; }
                    if(hNm){ hNm.value = nm; }
                    if(hTbl){ hTbl.value = table || ''; }

                    var payload = q('#ab_tb_cols_payload');
                    if(payload){ payload.innerHTML = ''; }

                    qa('#ab_tb_tables .ab_tb_table:checked').forEach(function(cb){
                      if(!payload){ return; }
                      var v = cb.value || '';
                      var i1 = document.createElement('input');
                      i1.type='hidden'; i1.name='ab_tb_tables[]'; i1.value=v;
                      payload.appendChild(i1);
                      var i2 = document.createElement('input');
                      i2.type='hidden'; i2.name='ab_tb_plan_tables[]'; i2.value=v;
                      payload.appendChild(i2);
                    });

                    qa('#ab_tb_tables .ab_tb_col:checked').forEach(function(cb){
                      if(!payload){ return; }
                      var wrap = cb.closest('.ab-tb-table');
                      var btn = wrap ? wrap.querySelector('.ab_tb_cols_btn') : null;
                      var t = btn ? (btn.getAttribute('data-table') || '') : '';
                      if(!t){ return; }
                      var i = document.createElement('input');
                      i.type='hidden';
                      i.name='ab_tb_columns['+t+'][]';
                      i.value=cb.value || '';
                      payload.appendChild(i);
                    });

                    f.submit();
                  }

                  on(document, 'DOMContentLoaded', function(){
                    syncFreqUI();

                    syncSelectAll();

                    on(q('#ab_tb_select_all'), 'change', function(e){
                      toggleAllTables(e && e.target ? e.target.checked : false);
                    });

                    qa('#ab_tb_tables .ab_tb_table').forEach(function(cb){
                      on(cb, 'change', syncSelectAll);
                    });

                    on(q('#ab_tb_plan_freq'), 'change', syncFreqUI);

                    qa('.ab_tb_cols_btn').forEach(function(btn){
                      on(btn, 'click', function(ev){
                        if(ev){ ev.preventDefault(); }
                        submitColumnsPost(btn.getAttribute('data-table') || '');
                      });
                    });
                  });
                })();
                </script>
            </div>

            <div class="ab-card" style="margin-top:12px;">
                <h3 style="margin-top:0;"><?php esc_html_e( 'Existing Table Backups', 'aegisbackup' ); ?></h3>
                <?php
                $backups = ( $mgr && is_object( $mgr ) && method_exists( $mgr, 'list_backups_sorted' ) ) ? (array) $mgr->list_backups_sorted() : array();
                $b_per_page = 5;
                $b_page = isset( $_GET['ab_tb_backups_page'] ) ? max( 1, absint( $_GET['ab_tb_backups_page'] ) ) : 1;
                $b_total = count( $backups );
                $b_total_pages = ( $b_per_page > 0 ) ? (int) ceil( $b_total / $b_per_page ) : 1;
                if ( $b_page > $b_total_pages && $b_total_pages > 0 ) {
                    $b_page = $b_total_pages;
                }
                $b_offset = ( $b_page - 1 ) * $b_per_page;
                $backups_page = array_slice( $backups, $b_offset, $b_per_page );

                if ( empty( $backups ) ) :
                    ?>
                    <em><?php esc_html_e( 'No table backups yet.', 'aegisbackup' ); ?></em>
                    <?php
                else :
                    ?>
                    <table class="widefat striped">
                        <thead>
                            <tr>
                                <th><?php esc_html_e( 'Name', 'aegisbackup' ); ?></th>
                                <th><?php esc_html_e( 'Created', 'aegisbackup' ); ?></th>
                                <th><?php esc_html_e( 'Database', 'aegisbackup' ); ?></th>
                                <th><?php esc_html_e( 'Tables', 'aegisbackup' ); ?></th>
                                <th><?php esc_html_e( 'Size', 'aegisbackup' ); ?></th>
                                <th><?php esc_html_e( 'Actions', 'aegisbackup' ); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ( $backups_page as $b ) :
                                $bid = isset( $b['id'] ) ? (string) $b['id'] : '';
                                $bname = isset( $b['name'] ) ? (string) $b['name'] : '';
                                $created = isset( $b['created'] ) ? (int) $b['created'] : 0;
                                $bdb = isset( $b['db'] ) ? (string) $b['db'] : '';
                                $btables = isset( $b['tables'] ) && is_array( $b['tables'] ) ? implode( ', ', array_map( 'strval', $b['tables'] ) ) : '';
                                $size_h = ( $mgr && method_exists( $mgr, 'human_bytes' ) ) ? $mgr->human_bytes( (int) ( $b['size'] ?? 0 ) ) : '';
                                $dl = ( $mgr && method_exists( $mgr, 'get_download_url' ) ) ? (string) $mgr->get_download_url( $bid ) : '';
                                $del = wp_nonce_url( add_query_arg( array( 'action' => 'aegisbackup_tablebacks_backup_delete', 'id' => $bid ), admin_url( 'admin-post.php' ) ), 'aegisbackup_tablebacks_backup_delete' );
                                ?>
                                <tr>
                                    <td><strong><?php echo esc_html( $bname ); ?></strong><br><code><?php echo esc_html( $bid ); ?></code></td>
                                    <td><?php echo $created ? esc_html( date_i18n( 'Y-m-d H:i', $created ) ) : ''; ?></td>
                                    <td><?php echo esc_html( $bdb ); ?></td>
                                    <td style="max-width:360px;"><?php echo esc_html( $btables ); ?></td>
                                    <td><?php echo esc_html( $size_h ); ?></td>
                                    <td>
                                        <?php if ( '' !== $dl ) : ?>
                                            <a class="button button-small" href="<?php echo esc_url( $dl ); ?>"><?php esc_html_e( 'Download', 'aegisbackup' ); ?></a>
                                        <?php endif; ?>
                                        <a class="button button-small" href="<?php echo esc_url( $del ); ?>" onclick="return confirm('Delete this table backup?');"><?php esc_html_e( 'Delete', 'aegisbackup' ); ?></a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>

                    <?php if ( $b_total_pages > 1 ) : ?>
                        <?php $b_base_url = remove_query_arg( array( 'ab_tb_backups_page' ) ); ?>
                        <div class="tablenav">
                            <div class="tablenav-pages">
                                <span class="displaying-num"><?php echo esc_html( sprintf( _n( '%s backup', '%s backups', $b_total, 'aegisbackup' ), number_format_i18n( $b_total ) ) ); ?></span>
                                <span class="pagination-links">
                                    <?php
                                    $b_prev = max( 1, $b_page - 1 );
                                    $b_next = min( $b_total_pages, $b_page + 1 );
                                    $b_first_url = esc_url( add_query_arg( 'ab_tb_backups_page', 1, $b_base_url ) );
                                    $b_prev_url  = esc_url( add_query_arg( 'ab_tb_backups_page', $b_prev, $b_base_url ) );
                                    $b_next_url  = esc_url( add_query_arg( 'ab_tb_backups_page', $b_next, $b_base_url ) );
                                    $b_last_url  = esc_url( add_query_arg( 'ab_tb_backups_page', $b_total_pages, $b_base_url ) );
                                    ?>
                                    <a class="first-page button" href="<?php echo $b_first_url; ?>" <?php disabled( $b_page <= 1 ); ?>>&laquo;</a>
                                    <a class="prev-page button" href="<?php echo $b_prev_url; ?>" <?php disabled( $b_page <= 1 ); ?>>&lsaquo;</a>
                                    <span class="paging-input">
                                        <span class="tablenav-paging-text"><?php echo esc_html( sprintf( __( '%1$d of %2$d', 'aegisbackup' ), (int) $b_page, (int) $b_total_pages ) ); ?></span>
                                    </span>
                                    <a class="next-page button" href="<?php echo $b_next_url; ?>" <?php disabled( $b_page >= $b_total_pages ); ?>>&rsaquo;</a>
                                    <a class="last-page button" href="<?php echo $b_last_url; ?>" <?php disabled( $b_page >= $b_total_pages ); ?>>&raquo;</a>
                                </span>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            </div>

            <div class="ab-card" style="margin-top:12px;">
                <h3 style="margin-top:0;"><?php esc_html_e( 'Schedule Backup List', 'aegisbackup' ); ?></h3>
                <?php
                $plans = ( $mgr && is_object( $mgr ) && method_exists( $mgr, 'list_plans_sorted' ) ) ? (array) $mgr->list_plans_sorted() : array();
                $per_page = 5;
                $page = isset( $_GET['ab_tb_plans_page'] ) ? max( 1, absint( $_GET['ab_tb_plans_page'] ) ) : 1;
                $total = count( $plans );
                $total_pages = ( $per_page > 0 ) ? (int) ceil( $total / $per_page ) : 1;
                if ( $page > $total_pages && $total_pages > 0 ) {
                    $page = $total_pages;
                }
                $offset = ( $page - 1 ) * $per_page;
                $plans_page = array_slice( $plans, $offset, $per_page );
                if ( empty( $plans ) ) :
                    ?>
                    <em><?php esc_html_e( 'No schedules yet.', 'aegisbackup' ); ?></em>
                    <?php
                else :
                    ?>
                    <table class="widefat striped">
                        <thead>
                            <tr>
                                <th><?php esc_html_e( 'Plan Name', 'aegisbackup' ); ?></th>
                                <th><?php esc_html_e( 'Frequency', 'aegisbackup' ); ?></th>
                                <th><?php esc_html_e( 'Run At', 'aegisbackup' ); ?></th>
                                <th><?php esc_html_e( 'Database', 'aegisbackup' ); ?></th>
                                <th><?php esc_html_e( 'Tables', 'aegisbackup' ); ?></th>
                                <th><?php esc_html_e( 'Actions', 'aegisbackup' ); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ( $plans_page as $p ) :
                                $pid = isset( $p['id'] ) ? (string) $p['id'] : '';
                                $pname = isset( $p['name'] ) ? (string) $p['name'] : '';
                                $pf = isset( $p['frequency'] ) ? (string) $p['frequency'] : '';
                                $pt = isset( $p['time'] ) ? (string) $p['time'] : '';
                                $pdb = isset( $p['db'] ) ? (string) $p['db'] : '';
                                $ptables = isset( $p['tables'] ) && is_array( $p['tables'] ) ? implode( ', ', array_map( 'strval', $p['tables'] ) ) : '';
                                $run = wp_nonce_url( add_query_arg( array( 'action' => 'aegisbackup_tablebacks_plan_run_now', 'id' => $pid ), admin_url( 'admin-post.php' ) ), 'aegisbackup_tablebacks_plan_run_now' );
                                $dl = wp_nonce_url( add_query_arg( array( 'action' => 'aegisbackup_tablebacks_plan_download', 'id' => $pid ), admin_url( 'admin-post.php' ) ), 'aegisbackup_tablebacks_plan_download' );
                                $del = wp_nonce_url( add_query_arg( array( 'action' => 'aegisbackup_tablebacks_plan_delete', 'id' => $pid ), admin_url( 'admin-post.php' ) ), 'aegisbackup_tablebacks_plan_delete' );
                                ?>
                                <tr>
                                    <td><strong><?php echo esc_html( $pname ); ?></strong><br><code><?php echo esc_html( $pid ); ?></code></td>
                                    <td><?php echo esc_html( $pf ); ?></td>
                                    <td><?php echo esc_html( $pt ); ?></td>
                                    <td><?php echo esc_html( $pdb ); ?></td>
                                    <td style="max-width:360px;"><?php echo esc_html( $ptables ); ?></td>
                                    <td>
                                        <a class="button button-small" href="<?php echo esc_url( $run ); ?>" onclick="return confirm('Run this schedule now?');"><?php esc_html_e( 'Run Now', 'aegisbackup' ); ?></a>
                                        <a class="button button-small" href="<?php echo esc_url( $dl ); ?>"><?php esc_html_e( 'Download', 'aegisbackup' ); ?></a>
                                        <a class="button button-small" href="<?php echo esc_url( $del ); ?>" onclick="return confirm('Delete this schedule?');"><?php esc_html_e( 'Delete', 'aegisbackup' ); ?></a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>

                    <?php if ( $total_pages > 1 ) : ?>
                        <?php
                        $base_url = remove_query_arg( array( 'ab_tb_plans_page' ) );
                        ?>
                        <div class="tablenav">
                            <div class="tablenav-pages">
                                <span class="displaying-num"><?php echo esc_html( sprintf( _n( '%s schedule', '%s schedules', $total, 'aegisbackup' ), number_format_i18n( $total ) ) ); ?></span>
                                <span class="pagination-links">
                                    <?php
                                    $prev = max( 1, $page - 1 );
                                    $next = min( $total_pages, $page + 1 );
                                    $first_url = esc_url( add_query_arg( 'ab_tb_plans_page', 1, $base_url ) );
                                    $prev_url  = esc_url( add_query_arg( 'ab_tb_plans_page', $prev, $base_url ) );
                                    $next_url  = esc_url( add_query_arg( 'ab_tb_plans_page', $next, $base_url ) );
                                    $last_url  = esc_url( add_query_arg( 'ab_tb_plans_page', $total_pages, $base_url ) );
                                    ?>
                                    <a class="first-page button" href="<?php echo $first_url; ?>" <?php disabled( $page <= 1 ); ?>>&laquo;</a>
                                    <a class="prev-page button" href="<?php echo $prev_url; ?>" <?php disabled( $page <= 1 ); ?>>&lsaquo;</a>
                                    <span class="paging-input">
                                        <span class="tablenav-paging-text"><?php echo esc_html( sprintf( __( '%1$d of %2$d', 'aegisbackup' ), (int) $page, (int) $total_pages ) ); ?></span>
                                    </span>
                                    <a class="next-page button" href="<?php echo $next_url; ?>" <?php disabled( $page >= $total_pages ); ?>>&rsaquo;</a>
                                    <a class="last-page button" href="<?php echo $last_url; ?>" <?php disabled( $page >= $total_pages ); ?>>&raquo;</a>
                                </span>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="aegisbackup-card" style="margin-top:16px;">
            <h2><?php esc_html_e( 'Local Backup Retention', 'aegisbackup' ); ?></h2>
            <p class="description"><?php esc_html_e( 'Automatically manage local table backups after a number of days.', 'aegisbackup' ); ?></p>

            <?php
            $ret = get_option( 'aegisbackup_local_retention', array() );
            $days = isset( $ret['db_table']['days'] ) ? absint( $ret['db_table']['days'] ) : 30;
            $act  = isset( $ret['db_table']['action'] ) ? sanitize_key( $ret['db_table']['action'] ) : 'purge';
            if ( $days < 1 ) { $days = 1; }
            if ( $days > 90 ) { $days = 90; }
            ?>
            <form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
                <?php wp_nonce_field( 'aegisbackup_save_settings', 'aegisbackup_settings_nonce' ); ?>
                <input type="hidden" name="action" value="aegisbackup_save_settings" />
                <input type="hidden" name="settings_section" value="retention" />
                <input type="hidden" name="retention_context" value="db_table" />
                <input type="hidden" name="retention_redirect" value="<?php echo esc_url( admin_url( 'admin.php?page=aegisbackup&tab=db&dbtab=table_backups' ) ); ?>" />

                <table class="form-table" role="presentation">
                    <tr>
                        <th scope="row"><?php esc_html_e( 'Days', 'aegisbackup' ); ?></th>
                        <td>
                            <select name="retention_days">
                                <?php for ( $i = 1; $i <= 90; $i++ ) : ?>
                                    <option value="<?php echo esc_attr( $i ); ?>" <?php selected( $days, $i ); ?>><?php echo esc_html( $i ); ?></option>
                                <?php endfor; ?>
                            </select>
                            <p class="description"><?php esc_html_e( 'Keep local table backups for this many days.', 'aegisbackup' ); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><?php esc_html_e( 'Action', 'aegisbackup' ); ?></th>
                        <td>
                            <select name="retention_action">
                                <option value="purge" <?php selected( 'purge', $act ); ?>><?php esc_html_e( 'Delete / Purge', 'aegisbackup' ); ?></option>
                                <option value="offsite" <?php selected( 'offsite', $act ); ?>><?php esc_html_e( 'Move to Offsite Remote Storage', 'aegisbackup' ); ?></option>
                            </select>
                            <p class="description"><?php esc_html_e( 'If “Move to Offsite” is selected, AegisBackup will attempt an offsite upload (if enabled) before deleting local copies.', 'aegisbackup' ); ?></p>
                        </td>
                    </tr>
                </table>

                <p class="submit">
                    <button type="submit" class="button button-primary"><?php esc_html_e( 'Save Retention', 'aegisbackup' ); ?></button>
                </p>
            </form>
        </div>

        <?php
    }
}
