<?php
namespace AegisBackup;

defined( 'ABSPATH' ) || exit;

require_once AEGISBACKUP_DIR . 'includes/backup/class-ab-backup-manager.php';
require_once AEGISBACKUP_DIR . 'includes/backup/class-ab-file-backup-manager.php';
require_once AEGISBACKUP_DIR . 'includes/backup/class-ab-wp-backup-manager.php';
require_once AEGISBACKUP_DIR . 'includes/backup/class-ab-table-backup-manager.php';
require_once AEGISBACKUP_DIR . 'includes/modules/class-ab-module-db-tools.php';
require_once AEGISBACKUP_DIR . 'includes/modules/class-ab-module-settings.php';
require_once AEGISBACKUP_DIR . 'includes/modules/class-ab-module-preupdate.php';
require_once AEGISBACKUP_DIR . 'includes/restore/class-ab-restore-manager.php';
require_once AEGISBACKUP_DIR . 'includes/push/class-ab-push-manager.php';
require_once AEGISBACKUP_DIR . 'includes/admin/class-ab-admin.php';
require_once AEGISBACKUP_DIR . 'includes/utils/class-ab-license.php';

class AB_Plugin {
    private static $instance;
    public $backup;
	public $file_backup;
    public $wp_backup;
	public $license;
    public $table_backup;
    public $db_tools;
    public $settings;
	public $preupdate;
    public $restore;
    public $push;
    public $admin;
    public static function instance() {
        if ( null === self::$instance ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function init() {
        $this->backup  = new \AegisBackup\Backup\AB_Backup_Manager();
		$this->file_backup = new \AegisBackup\Backup\AB_File_Backup_Manager();
        $this->wp_backup   = new \AegisBackup\Backup\AB_WP_Backup_Manager( $this->backup );
        $this->table_backup = new \AegisBackup\Backup\AB_Table_Backup_Manager();
        $this->db_tools = new \AegisBackup\Modules\AB_Module_DB_Tools();
		$this->settings = new \AegisBackup\Modules\AB_Module_Settings();
		$this->preupdate = new \AegisBackup\Modules\AB_Module_PreUpdate( $this );
        $this->restore = new \AegisBackup\Restore\AB_Restore_Manager();
        $this->push = new \AegisBackup\Push\AB_Push_Manager();
		$this->license = new \AegisBackup\Utils\License();

        if ( is_admin() ) {
            $this->admin = new \AegisBackup\Admin\AB_Admin( $this );
            $this->admin->init();
        }

        add_action( 'rest_api_init', array( $this, 'register_rest_routes' ) );
		add_action( 'init', array( $this, 'register_connect_endpoint' ) );
		add_filter( 'query_vars', array( $this, 'register_connect_query_var' ) );
		add_action( 'template_redirect', array( $this, 'maybe_render_connect_endpoint' ) );
		add_action( \AegisBackup\Backup\AB_File_Backup_Manager::CRON_HOOK, array( $this->file_backup, 'cron_run_plan' ), 10, 1 );
        add_action( \AegisBackup\Backup\AB_Table_Backup_Manager::CRON_HOOK, array( $this->table_backup, 'cron_run_plan' ), 10, 1 );
    }

	public function register_connect_endpoint() {
		add_rewrite_rule( '^aegisbackup_connect/?$', 'index.php?aegisbackup_connect=1', 'top' );
	}

	public function register_connect_query_var( $vars ) {
		$vars[] = 'aegisbackup_connect';
		return $vars;
	}

	public function maybe_render_connect_endpoint() {
		$flag = get_query_var( 'aegisbackup_connect', '' );
		if ( empty( $flag ) ) {
			return;
		}

		if ( ! headers_sent() ) {
			header( 'Content-Type: application/json; charset=utf-8' );
			status_header( 200 );
		}

		$payload = array(
			'success'   => true,
			'plugin'    => 'aegisbackup',
			'version'   => defined( 'AEGISBACKUP_VERSION' ) ? AEGISBACKUP_VERSION : '',
			'home_url'  => home_url(),
			'ssl'       => is_ssl() ? 1 : 0,
			'rest_base' => home_url( '/wp-json/aegisbackup/v1/' ),
			'ping'      => home_url( '/wp-json/aegisbackup/v1/ping' ),
		);

		echo wp_json_encode( $payload );
		exit;
	}

    public function register_rest_routes() {
        require_once AEGISBACKUP_DIR . 'includes/admin/class-ab-rest-api.php';
        ( new \AegisBackup\Admin\AB_REST_API( $this ) )->register_routes();
    }

    public function db_tools() {
        return $this->db_tools instanceof \AegisBackup\Modules\AB_Module_DB_Tools ? $this->db_tools : null;
    }
}
