(function(){
  function copyText(text){
    if (!text) return;
    if (navigator.clipboard && navigator.clipboard.writeText) {
      navigator.clipboard.writeText(text).catch(function(){});
      return;
    }
    try {
      var ta = document.createElement('textarea');
      ta.value = text;
      ta.setAttribute('readonly','readonly');
      ta.style.position = 'absolute';
      ta.style.left = '-9999px';
      document.body.appendChild(ta);
      ta.select();
      document.execCommand('copy');
      document.body.removeChild(ta);
    } catch(e){}
  }

  document.addEventListener('click', function(e){
    var el = e.target;
    if (!el) return;

    var btn = el.closest ? el.closest('.aegislink-share-btn') : null;
    if (!btn) return;

    var url = btn.getAttribute('data-aegislink-share-url') || btn.getAttribute('href') || '';
    if (!url) return;

    if (navigator.share) {
      e.preventDefault();
      navigator.share({ url: url }).catch(function(){});
      return;
    }

    e.preventDefault();
    copyText(url);
    var old = btn.textContent;
    btn.textContent = 'Copied!';
    setTimeout(function(){ btn.textContent = old; }, 1200);
  }, true);
})();