<?php
if (!defined('ABSPATH')) { exit; }
(function () {

$license = aegislink()->license;

if (!current_user_can('read')) {
    echo '<p>' . esc_html__('Forbidden', 'aegislink') . '</p>';
    return;
}

$is_embedded = (isset($_GET['page']) && sanitize_key((string) $_GET['page']) === 'aegislink' && isset($_GET['tab']) && sanitize_key((string) $_GET['tab']) === 'tools'); // phpcs:ignore WordPress.Security.NonceVerification.Recommended
$tab_key = $is_embedded ? 'tools_tab' : 'tab';
$tab = isset($_GET[$tab_key]) ? sanitize_key((string) $_GET[$tab_key]) : 'license'; // phpcs:ignore WordPress.Security.NonceVerification.Recommended
if (!in_array($tab, array('license','health'), true)) { $tab = 'license'; }

if ($tab === 'license') {
    $base_url = $is_embedded ? admin_url('admin.php?page=aegislink&tab=tools') : admin_url('admin.php?page=aegislink-license');
    $base_url = add_query_arg(array($tab_key => 'license'), $base_url);

    if (!empty($_POST['aegislink_license_action'])) {
        check_admin_referer('aegislink_license_action');

        $key   = isset($_POST['license_key']) ? sanitize_text_field(wp_unslash((string) $_POST['license_key'])) : '';
        $email = isset($_POST['license_email']) ? sanitize_email(wp_unslash((string) $_POST['license_email'])) : '';

        $license->set_key($key);
        update_option('aegislink_license_email', $email, false);

        $msg = 'saved';

        if (isset($_POST['aegislink_activate_license'])) {
            $resp = $license->activate_now(AEGISLINK_VERSION);
            $msg  = !empty($resp['success']) ? 'activated' : 'activate_failed';
        } elseif (isset($_POST['aegislink_deactivate_license'])) {
            $resp = $license->deactivate_now(AEGISLINK_VERSION);
            $msg  = !empty($resp['success']) ? 'deactivated' : 'deactivate_failed';
        } elseif (isset($_POST['aegislink_check_license'])) {
            $license->check_now(AEGISLINK_VERSION);
            $msg = 'checked';
        }

        // Do NOT redirect/exit after POST (prevents blank screen). Just show message and continue rendering.
        $_GET['aegislink_msg'] = $msg; // phpcs:ignore WordPress.Security.NonceVerification.Recommended
    }

    if (!empty($_POST['aegislink_license_save'])) { {
        check_admin_referer('aegislink_license_save');

        $key = isset($_POST['license_key']) ? sanitize_text_field(wp_unslash($_POST['license_key'])) : '';
        $email = isset($_POST['license_email']) ? sanitize_email(wp_unslash($_POST['license_email'])) : '';

        $license->set_key($key);
        update_option('aegislink_license_email', $email, false);

        $license->check_now(AEGISLINK_VERSION);

        echo '<div class="notice notice-success"><p>' . esc_html__('License saved.', 'aegislink') . '</p></div>';
    }

    if (!empty($_POST['aegislink_license_refresh'])) {
        $aegislink_nonce = isset($_POST['_wpnonce']) ? sanitize_text_field(wp_unslash((string) $_POST['_wpnonce'])) : '';
        if ($aegislink_nonce === '' || !wp_verify_nonce($aegislink_nonce, 'aegislink_license_refresh')) {
            wp_die(esc_html__('Security check failed.', 'aegislink'));
        }

        check_admin_referer('aegislink_license_refresh');
        $license->check_now(AEGISLINK_VERSION);
        echo '<div class="notice notice-success"><p>' . esc_html__('License status refreshed.', 'aegislink') . '</p></div>';
    }
}

$status = method_exists($license, 'get_status') ? $license->get_status() : (method_exists($license, 'get_cached_status') ? $license->get_cached_status() : array());

echo '<div class="wrap">';
echo '<h1>' . esc_html__('AegisLink', 'aegislink') . '</h1>';

$base_url = $is_embedded ? admin_url('admin.php?page=aegislink&tab=tools') : admin_url('admin.php?page=aegislink-license');
echo '<h2 class="nav-tab-wrapper">';
echo '<a href="' . esc_url(add_query_arg(array($tab_key=>'license'), $base_url)) . '" class="nav-tab ' . ($tab==='license' ? 'nav-tab-active' : '') . '">' . esc_html__('License', 'aegislink') . '</a>';echo '<a href="' . esc_url(add_query_arg(array($tab_key=>'health'), $base_url)) . '" class="nav-tab ' . ($tab === 'health' ? 'nav-tab-active' : '') . '">' . esc_html__('Health Checks', 'aegislink') . '</a>';
echo '</h2>';

$suite_pro = (function_exists('aegisify_is_pro') && aegisify_is_pro(true));

$is_pro    = $suite_pro || !empty($status['is_pro']);
$plan      = isset($status['plan']) ? (string) $status['plan'] : '';
$expires   = isset($status['expires']) ? (string) $status['expires'] : '';
$lic_state = isset($status['status']) ? (string) $status['status'] : '';
$is_active = $suite_pro || $is_pro || ($lic_state === 'active');

if ($suite_pro) {
    if ($plan === '') { $plan = 'Aegisify Suite'; }

    if ($expires === '' && class_exists('Aegisify_Core') && method_exists('Aegisify_Core', 'instance')) {
        $core = \Aegisify_Core::instance();
        if (is_object($core) && method_exists($core, 'license')) {
            $st2 = $core->license()->get_status();
            if (is_array($st2) && !empty($st2['expires'])) {
                $expires = (string) $st2['expires'];
            }
        }
    }
}

echo '<h2 style="margin-top:18px;">' . esc_html__('License Status', 'aegislink') . '</h2>';

echo '<table class="widefat striped" style="max-width:600px;margin-bottom:20px;">';
echo '<tbody>';

echo '<tr><th scope="row">' . esc_html__('Status', 'aegislink') . '</th><td>';
if ($is_active) {
    if ($suite_pro && empty($status['is_pro'])) {
        echo '<span style="color:#46b450;font-weight:600;">' . esc_html__('Active (Aegisify Suite)', 'aegislink') . '</span>';
    } else {
        $aegislink_active_label = $is_pro ? __('Active (Pro enabled)', 'aegislink') : __('Active', 'aegislink');
        echo '<span style="color:#46b450;font-weight:600;">' . esc_html($aegislink_active_label) . '</span>';
    }
} else {
    echo '<span style="color:#dc3232;font-weight:600;">' . esc_html__('Inactive', 'aegislink') . '</span>';
}
echo '</td></tr>';

echo '<tr><th scope="row">' . esc_html__('Plan', 'aegislink') . '</th><td>' . esc_html($plan !== '' ? $plan : '-') . '</td></tr>';
echo '<tr><th scope="row">' . esc_html__('Expires At', 'aegislink') . '</th><td>' . esc_html($expires !== '' ? $expires : '-') . '</td></tr>';

echo '</tbody></table>';

if ($tab === 'health') {

    // Actions
    if (!empty($_POST['aegislink_health_run'])) {
        check_admin_referer('aegislink_health_run');
        $plugin = function_exists('aegislink') ? aegislink() : null;
            if ($plugin && isset($plugin->shortlinks) && is_object($plugin->shortlinks) && method_exists($plugin->shortlinks, 'run_health_check')) {
            $plugin->shortlinks->run_health_check();
            echo '<div class="notice notice-success"><p>' . esc_html__('Health check executed.', 'aegislink') . '</p></div>';
        }
    }

    if (!empty($_POST['aegislink_health_reschedule'])) {
        check_admin_referer('aegislink_health_reschedule');
        if (class_exists('AegisLink\\Shortlinks\\Shortlinks')) {
            \AegisLink\Shortlinks\Shortlinks::unschedule_health_check();
            \AegisLink\Shortlinks\Shortlinks::maybe_schedule_health_check();
            echo '<div class="notice notice-success"><p>' . esc_html__('Daily schedule refreshed.', 'aegislink') . '</p></div>';
        }
    }

    if (!empty($_POST['aegislink_health_disable'])) {
        check_admin_referer('aegislink_health_disable');
        if (class_exists('AegisLink\\Shortlinks\\Shortlinks')) {
            \AegisLink\Shortlinks\Shortlinks::unschedule_health_check();
            echo '<div class="notice notice-warning"><p>' . esc_html__('Daily schedule disabled.', 'aegislink') . '</p></div>';
        }
    }

    $hook = 'aegislink_shortlinks_health_check';
    $next = function_exists('wp_next_scheduled') ? wp_next_scheduled($hook) : 0;

    $last_run_gmt = (string) get_option('aegislink_health_last_run_gmt', '');
    $last_checked = (int) get_option('aegislink_health_last_run_checked', 0);
    $last_ok = (int) get_option('aegislink_health_last_run_ok', 0);
    $last_broken = (int) get_option('aegislink_health_last_run_broken', 0);

    $batch = (int) apply_filters('aegislink_shortlinks_health_batch', 25);
    if ($batch < 1) { $batch = 25; }

    echo '<div class="postbox" style="max-width:1100px; padding:14px; margin-top:14px;">';
    echo '<h2 style="margin:0 0 10px 0;">' . esc_html__('Health Checks (Short Links)', 'aegislink') . '</h2>';

    echo '<p class="description" style="margin:0 0 10px 0;">' . esc_html__('Health checks run daily and scan a small batch each run to keep shared hosting safe.', 'aegislink') . '</p>';

    echo '<table class="widefat striped" style="max-width:900px;">';
    echo '<tbody>';
    echo '<tr><td style="width:220px;"><strong>' . esc_html__('Batch size per run', 'aegislink') . '</strong></td><td>' . esc_html($batch) . '</td></tr>';
    /* translators: %s: next scheduled run date/time. */
    echo '<tr><td><strong>' . esc_html__('Schedule', 'aegislink') . '</strong></td><td>' . ($next ? esc_html(sprintf(__('Next run: %s', 'aegislink'), wp_date('Y-m-d H:i:s', $next))) : esc_html__('Disabled', 'aegislink')) . '</td></tr>';
    echo '<tr><td><strong>' . esc_html__('Last run (GMT)', 'aegislink') . '</strong></td><td>' . ($last_run_gmt !== '' ? esc_html($last_run_gmt) : esc_html__('—', 'aegislink')) . '</td></tr>';
    /* translators: 1: checked count, 2: healthy count, 3: broken count. */
    echo '<tr><td><strong>' . esc_html__('Last run summary', 'aegislink') . '</strong></td><td>' . esc_html(sprintf(__('Checked: %1$d | Healthy: %2$d | Broken: %3$d', 'aegislink'), $last_checked, $last_ok, $last_broken)) . '</td></tr>';
    echo '</tbody>';
    echo '</table>';

    echo '<div style="margin-top:12px; display:flex; gap:10px; align-items:center; flex-wrap:wrap;">';

    echo '<form method="post" style="margin:0;">';
    wp_nonce_field('aegislink_health_run');
    echo '<input type="hidden" name="aegislink_health_run" value="1" />';
    echo '<button type="submit" class="button button-primary">' . esc_html__('Run Now', 'aegislink') . '</button>';
    echo '</form>';

    echo '<form method="post" style="margin:0;">';
    wp_nonce_field('aegislink_health_reschedule');
    echo '<input type="hidden" name="aegislink_health_reschedule" value="1" />';
    echo '<button type="submit" class="button">' . esc_html__('Reschedule Daily', 'aegislink') . '</button>';
    echo '</form>';

    echo '<form method="post" style="margin:0;">';
    wp_nonce_field('aegislink_health_disable');
    echo '<input type="hidden" name="aegislink_health_disable" value="1" />';
    echo '<button type="submit" class="button">' . esc_html__('Disable Schedule', 'aegislink') . '</button>';
    echo '</form>';

    echo '</div>';

    echo '<hr style="margin:14px 0;" />';
    echo '<p class="description" style="margin:0;">' . esc_html__('Tip: Broken links are marked in External Linking → Manage. You can edit targets, delete dead links, or re-run checks after updates.', 'aegislink') . '</p>';

    echo '</div>';

} else {

if (isset($_GET['aegislink_msg'])) {
    $m = sanitize_key((string) $_GET['aegislink_msg']);
    $map = array(
        'saved' => array('success', __('License saved.', 'aegislink')),
        'activated' => array('success', __('License activated.', 'aegislink')),
        'activate_failed' => array('error', __('Activation failed. Check /includes/log/aegislink.log', 'aegislink')),
        'deactivated' => array('success', __('License deactivated.', 'aegislink')),
        'deactivate_failed' => array('error', __('Deactivation failed. Check /includes/log/aegislink.log', 'aegislink')),
        'checked' => array('success', __('License status refreshed.', 'aegislink')),
    );

    if (isset($map[$m])) {
        echo '<div class="notice notice-' . esc_attr($map[$m][0]) . '"><p>' . esc_html($map[$m][1]) . '</p></div>';
    }
}

echo '<div style="margin:10px 0 14px;color:#50575e;font-size:13px;">'
    . esc_html__('Enter your license key and the email used at checkout. Activate to unlock PRO features and updates.', 'aegislink')
    . '</div>';


echo '<form method="post">';
wp_nonce_field('aegislink_license_action');
echo '<input type="hidden" name="aegislink_license_action" value="1" />';

echo '<table class="form-table" role="presentation"><tbody>';

echo '<tr><th scope="row"><label for="license_key">' . esc_html__('License Key', 'aegislink') . '</label></th>';
echo '<td><input type="text" id="license_key" name="license_key" class="regular-text" style="width:420px;" value="' . esc_attr($license->get_key()) . '" autocomplete="off" /></td></tr>';

echo '<tr><th scope="row"><label for="license_email">' . esc_html__('License Email', 'aegislink') . '</label></th>';
echo '<td><input type="email" id="license_email" name="license_email" class="regular-text" style="width:420px;" value="' . esc_attr(get_option('aegislink_license_email', '')) . '" autocomplete="email" /></td></tr>';

echo '</tbody></table>';

$aegislink_confirm = __('Deactivate this license on this site?', 'aegislink');

echo '<p>';
echo '<button type="submit" class="button button-primary" name="aegislink_activate_license" value="1">' . esc_html__('Activate License', 'aegislink') . '</button> ';
echo '<button type="submit" class="button" name="aegislink_deactivate_license" value="1" onclick="return confirm(\'' . esc_js($aegislink_confirm) . '\');">' . esc_html__('Deactivate', 'aegislink') . '</button> ';
echo '<button type="submit" class="button button-secondary" name="aegislink_check_license" value="1">' . esc_html__('Check Status', 'aegislink') . '</button>';
echo '</p>';

echo '<hr style="margin:18px 0;" />';

echo '</form>';

echo '<hr />';
echo '<h4>'
    . esc_html__('Create an account on', 'aegislink') . ' '
    . '<a href="' . esc_url('https://aegisify.com/register/') . '" target="_blank" rel="noopener noreferrer">https://aegisify.com/register/</a> '
    . esc_html__('and help support Aegisify by buying a license today!', 'aegislink')
    . '</h4>';
echo '<hr />';

foreach ($fields as $k => $v) {
    echo '<tr><td><strong>' . esc_html($k) . '</strong></td><td>' . esc_html($v) . '</td></tr>';
}
echo '</tbody></table>';

echo '<hr style="margin:22px 0;" />';
echo '<h2>' . esc_html__('Need a license?', 'aegislink') . '</h2>';
/* translators: %s: Aegisify registration URL. */
echo '<p>' . wp_kses_post(sprintf(__('Create an account at %s and buy a license to unlock PRO features.', 'aegislink'),
    '<a href="https://aegisify.com/register/" target="_blank" rel="noopener noreferrer">https://aegisify.com/register/</a>'
)) . '</p>';
}
echo '</div>';
}})();
