<?php
if (!defined('ABSPATH')) { exit; }

if (!current_user_can('edit_posts')) {
    echo '<p>' . esc_html__('Forbidden', 'aegislink') . '</p>';
    return;
}


$aegislink_active_tab = isset($_GET['tab']) ? sanitize_key((string) $_GET['tab']) : 'keyword';

if ($aegislink_active_tab === 'internal') { $aegislink_active_tab = 'keyword'; }
if ($aegislink_active_tab === 'external') { $aegislink_active_tab = 'shorturl'; }
if ($aegislink_active_tab === 'shorturl') { $aegislink_active_tab = 'shorturl'; }

if (!in_array($aegislink_active_tab, array('wordcloud','keyword','shorturl','tools'), true)) { $aegislink_active_tab = 'keyword'; }
$aegislink_smart_opt_key = 'aegislink_smart_links';
$aegislink_smart_opts = get_option($aegislink_smart_opt_key, array('enabled' => 0, 'map' => array()));
if (!is_array($aegislink_smart_opts)) { $aegislink_smart_opts = array('enabled' => 0, 'map' => array()); }
if (!isset($aegislink_smart_opts['enabled'])) { $aegislink_smart_opts['enabled'] = 0; }
if (!isset($aegislink_smart_opts['map']) || !is_array($aegislink_smart_opts['map'])) { $aegislink_smart_opts['map'] = array(); }

$aegislink_max_rows = 100;

if (!empty($_POST['aegislink_smart_links_save'])) {
    check_admin_referer('aegislink_smart_links_save');

    $aegislink_enabled = !empty($_POST['smart_links_enabled']) ? 1 : 0;

    $aegislink_keywords_raw = ( isset( $_POST['smart_keyword'] ) && is_array( $_POST['smart_keyword'] ) )
        ? array_map( 'sanitize_text_field', (array) wp_unslash( $_POST['smart_keyword'] ) )
        : array();

    $aegislink_keywords = array_map(
        static function ($v) {
            return sanitize_text_field(wp_unslash((string) $v));
        },
        $aegislink_keywords_raw
    );

    $aegislink_urls_raw = ( isset( $_POST['smart_url'] ) && is_array( $_POST['smart_url'] ) )
        ? array_map( 'sanitize_text_field', (array) wp_unslash( $_POST['smart_url'] ) )
        : array();

    $aegislink_urls = array_map(
        static function ($v) {
            return esc_url_raw(trim(wp_unslash((string) $v)));
        },
        $aegislink_urls_raw
    );

    $aegislink_map = array();
    $aegislink_count = min($aegislink_max_rows, max(count($aegislink_keywords), count($aegislink_urls)));

	for ($aegislink_i = 0; $aegislink_i < $aegislink_count; $aegislink_i++) {
		$aegislink_kw  = isset($aegislink_keywords[$aegislink_i]) ? sanitize_text_field((string) $aegislink_keywords[$aegislink_i]) : '';
		$aegislink_url = isset($aegislink_urls[$aegislink_i]) ? esc_url_raw(trim((string) $aegislink_urls[$aegislink_i])) : '';

        $aegislink_kw = trim($aegislink_kw);

        if ($aegislink_kw === '' || preg_match('/\s/', $aegislink_kw)) { continue; }
        if ($aegislink_url === '') { continue; }

        $aegislink_map[strtolower($aegislink_kw)] = array(
            'keyword' => $aegislink_kw,
            'url'     => $aegislink_url,
        );
    }

    $aegislink_smart_opts = array(
        'enabled' => $aegislink_enabled,
        'map'     => array_values($aegislink_map),
    );

    update_option($aegislink_smart_opt_key, $aegislink_smart_opts, false);

    echo '<div class="notice notice-success"><p>' . esc_html__('Smart Links saved.', 'aegislink') . '</p></div>';
}

$aegislink_post_id = isset($_GET['post_id']) ? (int) $_GET['post_id'] : 0;

echo '<div class="wrap">';
echo '<h1>' . esc_html__('Linking Assistant', 'aegislink') . '</h1>';
echo '<p class="description" style="max-width:1100px;">' . esc_html__('Generate internal link suggestions for a Page or Post and manage Smart Links (keyword → URL) that auto-link across your content.', 'aegislink') . '</p>';

$aegislink_base_url = admin_url('admin.php?page=aegislink');
$aegislink_tools_url = admin_url('admin.php?page=aegislink&tab=tools');

echo '<h2 class="nav-tab-wrapper" style="margin-top:14px;">';
echo '<a class="nav-tab ' . ($aegislink_active_tab === 'wordcloud' ? 'nav-tab-active' : '') . '" href="' . esc_url(add_query_arg(array('tab'=>'wordcloud'), $aegislink_base_url)) . '">' . esc_html__('Word Cloud', 'aegislink') . '</a>';
echo '<a class="nav-tab ' . ($aegislink_active_tab === 'keyword' ? 'nav-tab-active' : '') . '" href="' . esc_url(add_query_arg(array('tab'=>'keyword'), $aegislink_base_url)) . '">' . esc_html__('Keyword Links', 'aegislink') . '</a>';
echo '<a class="nav-tab ' . ($aegislink_active_tab === 'shorturl' ? 'nav-tab-active' : '') . '" href="' . esc_url(add_query_arg(array('tab'=>'shorturl'), $aegislink_base_url)) . '">' . esc_html__('ShortURL Links', 'aegislink') . '</a>';
echo '<a class="nav-tab ' . ($aegislink_active_tab === 'tools' ? 'nav-tab-active' : '') . '" href="' . esc_url($aegislink_tools_url) . '">' . esc_html__('Tools & Licensing', 'aegislink') . '</a>';
echo '</h2>';

if ($aegislink_active_tab === 'wordcloud') {
    require_once AEGISLINK_DIR . 'includes/admin/pages/wordcloud-page.php';
    return;
}

if ($aegislink_active_tab === 'tools') {
    require_once AEGISLINK_DIR . 'includes/admin/pages/license-page.php';
    return;
}

if ($aegislink_active_tab === 'shorturl') {
    require_once AEGISLINK_DIR . 'includes/admin/pages/external-links-page.php';
    return;
}


echo '<hr style="margin:18px 0;" />';
echo '<h2 style="margin:0 0 10px 0;">' . esc_html__('Select a Page or Post', 'aegislink') . '</h2>';

$aegislink_args = array(
    'post_type'      => array('post','page'),
    'post_status'    => array('publish','draft','private'),
    'posts_per_page' => 200,
    'orderby'        => 'type',
    'order'          => 'ASC',
);
$aegislink_q = new WP_Query($aegislink_args);

echo '<form method="get" action="" style="margin:0 0 10px 0;">';
echo '<input type="hidden" name="page" value="aegislink" />';
echo '<select name="post_id" style="min-width:420px; max-width:100%;">';
echo '<option value="0">' . esc_html__('— Select —', 'aegislink') . '</option>';
if ($aegislink_q->have_posts()) {
    foreach ($aegislink_q->posts as $aegislink_p) {
        $aegislink_label = sprintf('[%s] %s', strtoupper($aegislink_p->post_type), $aegislink_p->post_title ? $aegislink_p->post_title : '(no title)');
        echo '<option value="' . (int) $aegislink_p->ID . '" ' . selected($aegislink_post_id, $aegislink_p->ID, false) . '>' . esc_html($aegislink_label) . '</option>';
    }
}
echo '</select> ';
submit_button(__('Load Suggestions', 'aegislink'), 'secondary', 'submit', false);
echo '</form>';

echo '<hr style="margin:18px 0;" />';
echo '<h2 style="margin:0 0 6px 0;">' . esc_html__('Smart Links (Keyword → URL)', 'aegislink') . '</h2>';
echo '<p class="description" style="margin:0 0 12px 0; max-width:1100px;">' . esc_html__('Create one-word keywords that automatically link across your entire site content. Example: AegisWAF → https://aegisify.com/aegiswaf/', 'aegislink') . '</p>';

echo '<form method="post" action="" id="aegislink-smartlinks-form">';
wp_nonce_field('aegislink_smart_links_save');
echo '<input type="hidden" name="aegislink_smart_links_save" value="1" />';

echo '<label style="display:inline-flex; align-items:center; gap:8px; margin: 0 0 10px 0;">';
echo '<input type="checkbox" name="smart_links_enabled" value="1" ' . checked(!empty($aegislink_smart_opts['enabled']), true, false) . ' />';
echo '<strong>' . esc_html__('Enable Smart Links site-wide', 'aegislink') . '</strong>';
echo '</label>';

echo '<table class="widefat striped" style="max-width:1100px;" id="aegislink-smartlinks-table">';
echo '<thead><tr>';
echo '<th style="width:240px;">' . esc_html__('Keyword (one word)', 'aegislink') . '</th>';
echo '<th>' . esc_html__('Destination URL', 'aegislink') . '</th>';
echo '<th style="width:120px;">' . esc_html__('Actions', 'aegislink') . '</th>';
echo '</tr></thead><tbody>';

$aegislink_rows = !empty($aegislink_smart_opts['map']) ? $aegislink_smart_opts['map'] : array();
$aegislink_min_visible = 5;
if (count($aegislink_rows) < $aegislink_min_visible) {
    for ($aegislink_i = count($aegislink_rows); $aegislink_i < $aegislink_min_visible; $aegislink_i++) { $aegislink_rows[] = array('keyword'=>'', 'url'=>''); }
}

$aegislink_row_index = 0;
foreach ($aegislink_rows as $aegislink_row) {
    $aegislink_kw  = isset($aegislink_row['keyword']) ? $aegislink_row['keyword'] : '';
    $aegislink_url = isset($aegislink_row['url']) ? $aegislink_row['url'] : '';
    echo '<tr class="aegislink-smartlinks-row">';
    echo '<td><input class="regular-text" type="text" name="smart_keyword[]" value="' . esc_attr($aegislink_kw) . '" placeholder="AegisWAF" /></td>';
    echo '<td><input class="large-text" type="url" name="smart_url[]" value="' . esc_attr($aegislink_url) . '" placeholder="https://aegisify.com/aegiswaf/" /></td>';
    echo '<td>';
    echo '<button type="button" class="button aegislink-add-row" ' . ($aegislink_row_index === 0 ? '' : 'style="display:none;"') . '>' . esc_html__('Add', 'aegislink') . '</button> ';
    echo '<button type="button" class="button aegislink-remove-row">' . esc_html__('Remove', 'aegislink') . '</button>';
    echo '</td>';
    echo '</tr>';
    $aegislink_row_index++;
}

echo '</tbody></table>';

echo '<p class="description" style="margin-top:10px;">' . esc_html__('Rules: one keyword = one URL. Keywords are case-insensitive. Existing links are not modified. Max 100 rows.', 'aegislink') . '</p>';

submit_button(__('Save Smart Links', 'aegislink'), 'primary', 'submit', false);
echo '</form>';

echo '<hr style="margin:18px 0;" />';

echo '<h2 style="margin:0 0 8px 0;">' . esc_html__('Suggestions', 'aegislink') . '</h2>';

if ($aegislink_post_id > 0) {
    $aegislink_post = get_post($aegislink_post_id);
    if ($aegislink_post) {
        echo '<p class="description" style="margin:0 0 10px 0;">' . esc_html__('Showing suggestions for:', 'aegislink') . ' <strong>' . esc_html($aegislink_post->post_title ? $aegislink_post->post_title : '(no title)') . '</strong></p>';

        $aegislink_suggestions = aegislink()->linking->suggest_links($aegislink_post_id, 10);

        if (!empty($aegislink_suggestions) && is_array($aegislink_suggestions)) {
            echo '<ul style="max-width:1100px; margin:0; padding-left:18px;">';
            foreach ($aegislink_suggestions as $aegislink_s) {
                $aegislink_anchor = isset($aegislink_s['anchor']) ? $aegislink_s['anchor'] : '';
                $aegislink_url    = isset($aegislink_s['url']) ? $aegislink_s['url'] : '';
                $aegislink_why    = isset($aegislink_s['why']) ? $aegislink_s['why'] : '';
                echo '<li style="margin:0 0 8px 0;">';
                echo '<strong>' . esc_html($aegislink_anchor) . '</strong> → <a href="' . esc_url($aegislink_url) . '" target="_blank" rel="noopener noreferrer">' . esc_html($aegislink_url) . '</a>';
                if ($aegislink_why) {
                    echo '<div class="description" style="margin-top:2px;">' . esc_html($aegislink_why) . '</div>';
                }
                echo '</li>';
            }
            echo '</ul>';
        } else {
            echo '<p class="description">' . esc_html__('No suggestions available for this content yet.', 'aegislink') . '</p>';
        }
    } else {
        echo '<p class="description">' . esc_html__('Invalid post/page selected.', 'aegislink') . '</p>';
    }
} else {
    echo '<p class="description">' . esc_html__('Select a Page or Post above to generate internal link suggestions.', 'aegislink') . '</p>';
}

?>
<script>
(function(){
  const table = document.getElementById('aegislink-smartlinks-table');
  if(!table) return;
  const tbody = table.querySelector('tbody');
  const maxRows = <?php echo (int) $aegislink_max_rows; ?>;

  function updateAddButtons(){
    const rows = tbody.querySelectorAll('tr.aegislink-smartlinks-row');
    rows.forEach((r,i)=>{
      const addBtn = r.querySelector('.aegislink-add-row');
      if(addBtn) addBtn.style.display = (i === rows.length-1) ? '' : 'none';
    });
  }

  function rowCount(){
    return tbody.querySelectorAll('tr.aegislink-smartlinks-row').length;
  }

  tbody.addEventListener('click', function(e){
    const t = e.target;
    if(!(t instanceof HTMLElement)) return;

    if(t.classList.contains('aegislink-add-row')){
      e.preventDefault();
      if(rowCount() >= maxRows) return;

      const tr = t.closest('tr');
      if(!tr) return;

      const clone = tr.cloneNode(true);
      // clear values
      clone.querySelectorAll('input').forEach(inp => inp.value = '');
      tbody.appendChild(clone);
      updateAddButtons();
    }

    if(t.classList.contains('aegislink-remove-row')){
      e.preventDefault();
      const tr = t.closest('tr');
      if(!tr) return;
      const rows = tbody.querySelectorAll('tr.aegislink-smartlinks-row');
      if(rows.length <= 1) return;
      tr.remove();
      updateAddButtons();
    }
  });

  updateAddButtons();
})();
</script>
<?php

echo '</div>';