<?php
namespace AegisLink;

use AegisLink\Admin\Admin_Menu;
use AegisLink\Utils\License;
use AegisLink\SEO\Linking;
use AegisLink\Shortcodes\Shortcodes;
use AegisLink\Shortlinks\Shortlinks;

if (!defined('ABSPATH')) { exit; }

class Plugin {

    private static $instance = null;

    /** @var License */
    public $license;

    /** @var Shortlinks */
    public $shortlinks;

    /** @var Linking */
    public $linking;

    /** @var Admin_Menu */
    public $admin_menu;

    /** @var Shortcodes */
    public $shortcodes;

    public static function instance() : self {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function boot() : void {
        $this->includes();

        $this->license = new License();
		add_action('admin_init', function () {
			// Daily CLM check: refresh license status + (optional) free-install registration
			$this->license->maybe_daily_check(AEGISLINK_VERSION);
		});

		$this->linking = new Linking();
        $this->shortcodes = new Shortcodes();
        $this->shortlinks = new Shortlinks();

        // WooCommerce Share integration (optional)
        $opts = (array) get_option(Shortlinks::OPT_SETTINGS, array());
        if (!empty($opts['woo_share_enabled']) && class_exists('WooCommerce')) {
            $woo = new \AegisLink\Integrations\Woo_Share();
            $woo->hooks();
        }

        if (is_admin()) {
            $this->admin_menu = new Admin_Menu($this->license);
        }
        // Update checker removed (WordPress.org compliance)
    }

    private function includes() : void {
        require_once AEGISLINK_DIR . 'includes/utils/class-aegislink-license.php';
        require_once AEGISLINK_DIR . 'includes/seo/class-aegislink-linking.php';
        require_once AEGISLINK_DIR . 'includes/admin/class-aegislink-admin-menu.php';
        require_once AEGISLINK_DIR . 'includes/shortcodes/class-aegislink-shortcodes.php';
        require_once AEGISLINK_DIR . 'includes/shortlinks/class-aegislink-shortlinks.php';
        require_once AEGISLINK_DIR . 'includes/shortlinks/class-aegislink-shortlinks-bulk-terms.php';
        require_once AEGISLINK_DIR . 'includes/integrations/class-aegislink-woo-share.php';
    }
}