<?php
namespace AegisShield;

defined( 'ABSPATH' ) || exit;

$__aegisify_bundled_page = AEGISSHIELD_PLUGIN_DIR . 'includes/class-aegisify-bundled-plugins-page.php';
if ( file_exists( $__aegisify_bundled_page ) ) {
    require_once $__aegisify_bundled_page;
}

class AS_Admin_UI {

    protected $plugin;

    public function __construct( AS_Plugin $plugin ) {
        $this->plugin = $plugin;
    }

    public function init() {
        add_action( 'admin_menu', array( $this, 'register_menus' ) );
    }

    public function register_menus() {
        $capability = 'manage_options';

        add_menu_page(
            __( 'AegisShield Security', 'aegisshield-security' ),
            __( 'AegisShield', 'aegisshield-security' ),
            $capability,
            'aegisshield-dashboard',
            array( $this, 'render_dashboard' ),
            'dashicons-shield-alt',
            25
        );

        add_submenu_page(
            'aegisshield-dashboard',
            __( 'Dashboard', 'aegisshield-security' ),
            __( 'Dashboard', 'aegisshield-security' ),
            $capability,
            'aegisshield-dashboard',
            array( $this, 'render_dashboard' )
        );

        add_submenu_page(
            'aegisshield-dashboard',
            __( 'Activity Log', 'aegisshield-security' ),
            __( 'Activity Log', 'aegisshield-security' ),
            $capability,
            'aegisshield-activity-log',
            array( $this, 'render_activity_log' )
        );

        add_submenu_page(
            'aegisshield-dashboard',
            __( 'Login Guard', 'aegisshield-security' ),
            __( 'Login Guard', 'aegisshield-security' ),
            $capability,
            'aegisshield-login-guard',
            array( $this, 'render_login_guard' )
        );

        add_submenu_page(
            'aegisshield-dashboard',
            __( 'File Integrity', 'aegisshield-security' ),
            __( 'File Integrity', 'aegisshield-security' ),
            $capability,
            'aegisshield-file-integrity',
            array( $this, 'render_file_integrity' )
        );

        add_submenu_page(
            'aegisshield-dashboard',
            __( 'Hardening', 'aegisshield-security' ),
            __( 'Hardening', 'aegisshield-security' ),
            $capability,
            'aegisshield-hardening',
            array( $this, 'render_hardening' )
        );

        add_submenu_page(
            'aegisshield-dashboard',
            __( 'Security Headers', 'aegisshield-security' ),
            __( 'Security Headers', 'aegisshield-security' ),
            $capability,
            'aegisshield-sec-headers',
            array( $this, 'render_sec_headers' )
        );

        add_submenu_page(
            'aegisshield-dashboard',
            __( 'Malware Scan', 'aegisshield-security' ),
            __( 'Malware Scan', 'aegisshield-security' ),
            $capability,
            'aegisshield-malware',
            array( $this, 'render_malware' )
        );

        add_submenu_page(
            'aegisshield-dashboard',
            __( 'DB Tools', 'aegisshield-security' ),
            __( 'DB Tools', 'aegisshield-security' ),
            $capability,
            'aegisshield-db-tools',
            array( $this, 'render_db_tools' )
        );


        add_submenu_page(
            'aegisshield-dashboard',
            __( 'Settings, License & Upgrades', 'aegisshield-security' ),
            __( 'Settings, License & Upgrades', 'aegisshield-security' ),
            $capability,
            'aegisshield-license',
            array( $this, 'render_license' )
        );
  
		if ( class_exists( '\Aegisify_Bundled_Plugins_Page' ) ) {

			\Aegisify_Bundled_Plugins_Page::init( array(
				'parent_slug' => 'aegisshield-dashboard',
				'menu_slug'   => 'aegisify-bundled-plugins',
				'page_title'  => 'Aegisify Plugins',
				'menu_title'  => 'Aegisify Plugins',
			) );

			\Aegisify_Bundled_Plugins_Page::add_submenu();
		}

        // Hidden incident report page used for printable HTML/PDF exports.
        add_submenu_page(
            null,
            __( 'Incident Report', 'aegisshield-security' ),
            __( 'Incident Report', 'aegisshield-security' ),
            $capability,
            'aegisshield-incident-report',
            array( $this, 'render_incident_report' )
        );

    }


    public function render_dashboard() {
        $page = new \AegisShield\Admin_Pages\AS_Page_Dashboard( $this->plugin );
        $page->render();
    }

    public function render_activity_log() {
        $page = new \AegisShield\Admin_Pages\AS_Page_Activity_Log( $this->plugin );
        $page->render();
    }

    public function render_login_guard() {
        $page = new \AegisShield\Admin_Pages\AS_Page_Login_Guard( $this->plugin );
        $page->render();
    }

    public function render_file_integrity() {
        $page = new \AegisShield\Admin_Pages\AS_Page_File_Integrity( $this->plugin );
        $page->render();
    }

    public function render_hardening() {
        $page = new \AegisShield\Admin_Pages\AS_Page_Hardening( $this->plugin );
        $page->render();
    }


    public function render_sec_headers() {
        $page = new \AegisShield\Admin_Pages\AS_Page_Sec_Headers( $this->plugin );
        $page->render();
    }

    public function render_malware() {
        $page = new \AegisShield\Admin_Pages\AS_Page_Malware( $this->plugin );
        $page->render();
    }

    public function render_db_tools() {
        $page = new \AegisShield\Admin_Pages\AS_Page_DB_Tools( $this->plugin );
        $page->render();
    }

    public function render_license() {
        $page = new \AegisShield\Admin_Pages\AS_Page_License( $this->plugin );
        $page->render();
    }


    public function render_incident_report() {
        $page = new \AegisShield\Admin_Pages\AS_Page_Incident_Report( $this->plugin );
        $page->render();
    }

}
