<?php
namespace AegisShield;

defined( 'ABSPATH' ) || exit;

class AS_Autoloader {

    protected static $base_namespace = 'AegisShield\\';

    public static function init() {
        spl_autoload_register( array( __CLASS__, 'autoload' ) );
    }


    public static function autoload( $class ) {
        if ( strpos( $class, self::$base_namespace ) !== 0 ) {
            return;
        }

        // Remove base namespace prefix.
        $relative = substr( $class, strlen( self::$base_namespace ) );

        // Break into namespace parts.
        $parts      = explode( '\\', $relative );
        $class_name = array_pop( $parts );
        $sub_path   = '';

        if ( ! empty( $parts ) ) {
            $sub_path = strtolower( implode( DIRECTORY_SEPARATOR, $parts ) ) . DIRECTORY_SEPARATOR;
        }

        $file_name = 'class-' . strtolower( str_replace( '_', '-', $class_name ) ) . '.php';

        $base_dir = trailingslashit( AEGISSHIELD_PLUGIN_DIR ) . 'includes/';
        $file     = $base_dir . $sub_path . $file_name;

        if ( file_exists( $file ) ) {
            require $file;
        }
    }
}