<?php
namespace AegisShield\Modules\Malware;

defined( 'ABSPATH' ) || exit;

class AS_Malware_Incremental {

    public static function get_incremental_targets() {
        global $wpdb;

        if ( ! isset( $wpdb ) ) {
            return array();
        }

        $table = $wpdb->prefix . 'aegisshield_file_monitor';
        if ( empty( $table ) ) {
            return array();
        }

        $limit = 300;

        $rows = $wpdb->get_results(
            $wpdb->prepare(
                "SELECT file_path FROM {$table} WHERE status IN ('new','modified') ORDER BY mtime DESC LIMIT %d",
                $limit
            ),
            ARRAY_A
        );

        if ( empty( $rows ) || ! is_array( $rows ) ) {
            return array();
        }

        $paths = array();

        foreach ( $rows as $row ) {
            if ( empty( $row['file_path'] ) ) {
                continue;
            }

            $rel_path = ltrim( (string) $row['file_path'], "/\\" );
            if ( '' === $rel_path ) {
                continue;
            }

            $paths[] = $rel_path;
        }

        return $paths;
    }
}
