<?php
namespace AegisShield\Admin_Pages\Malware;

use AegisShield\AS_Plugin;
use AegisShield\Modules\Malware\AS_Malware_Profiles;

defined( 'ABSPATH' ) || exit;

class AS_Page_Malware_Tab_Profiles {

    public static function render_tab( AS_Plugin $plugin ) {
        $settings = $plugin->get_settings();
        $section  = 'malware';

        $is_pro = function_exists( 'aegisshield_is_pro_active' ) && aegisshield_is_pro_active();

        if (
            $is_pro
            && isset( $_POST['aegisshield_malware_profiles_nonce'] )
            && wp_verify_nonce(
                sanitize_text_field( wp_unslash( $_POST['aegisshield_malware_profiles_nonce'] ) ),
                'aegisshield_malware_profiles_save'
            )
        ) {
            $profile = isset( $_POST['malware_scan_profile'] )
                ? sanitize_text_field( wp_unslash( $_POST['malware_scan_profile'] ) )
                : '';

            $available = AS_Malware_Profiles::get_profiles();
            if ( isset( $available[ $profile ] ) ) {
                $settings->set( $section, 'scan_profile', $profile );
                $settings->save();
                ?>
                <div class="notice notice-success is-dismissible">
                    <p><?php esc_html_e( 'Malware scan profile saved.', 'aegisshield-security' ); ?></p>
                </div>
                <?php
            }
        }

        $profiles      = AS_Malware_Profiles::get_profiles();
        $current_key   = AS_Malware_Profiles::get_selected_profile( $settings, $section );
        $current_label = isset( $profiles[ $current_key ] ) ? $profiles[ $current_key ]['label'] : '';

        ?>
        <div class="wrap">
            <h1><?php esc_html_e( 'Malware Scan – Profiles', 'aegisshield-security' ); ?></h1>

            <p>
                <?php esc_html_e( 'Choose how sensitive the heuristic malware scanner should be. Higher sensitivity may report more suspicious files, including some that are not truly malicious.', 'aegisshield-security' ); ?>
            </p>

            <?php if ( ! $is_pro ) : ?>
                <p class="description">
                    <?php
                    printf(
                        esc_html__( 'Scan profiles are available in AegisShield Pro. Activate your license on the %s page to unlock this feature.', 'aegisshield-security' ),
                        '<a href="' . esc_url( admin_url( 'admin.php?page=aegisshield-license' ) ) . '">' . esc_html__( 'License &amp; Upgrades', 'aegisshield-security' ) . '</a>'
                    );
                    ?>
                </p>
            <?php else : ?>
                <form method="post">
                    <?php wp_nonce_field( 'aegisshield_malware_profiles_save', 'aegisshield_malware_profiles_nonce' ); ?>

                    <table class="form-table" role="presentation">
                        <tr>
                            <th scope="row">
                                <?php esc_html_e( 'Active profile', 'aegisshield-security' ); ?>
                            </th>
                            <td>
                                <?php foreach ( $profiles as $key => $profile ) : ?>
                                    <p>
                                        <label>
                                            <input type="radio" name="malware_scan_profile" value="<?php echo esc_attr( $key ); ?>" <?php checked( $current_key, $key ); ?> />
                                            <strong><?php echo esc_html( $profile['label'] ); ?></strong><br />
                                            <span class="description"><?php echo esc_html( $profile['description'] ); ?></span>
                                        </label>
                                    </p>
                                <?php endforeach; ?>
                            </td>
                        </tr>
                    </table>

                    <?php submit_button( __( 'Save scan profile', 'aegisshield-security' ) ); ?>
                </form>

                <p class="description">
                    <?php
                    printf(
                        esc_html__( 'Current profile: %s.', 'aegisshield-security' ),
                        $current_label ? $current_label : esc_html__( 'Balanced (default)', 'aegisshield-security' )
                    );
                    ?>
                </p>
            <?php endif; ?>
        </div>
        <?php
    }
}
